/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.bookkeeper.client.DynamicWeightedRandomSelectionImpl;
import org.apache.bookkeeper.client.WeightedRandomSelection;
import org.apache.bookkeeper.client.WeightedRandomSelectionImpl;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestWeightedRandomSelection {
    static final Logger LOG = LoggerFactory.getLogger(TestWeightedRandomSelection.class);
    Class<? extends WeightedRandomSelection> weightedRandomSelectionClass;
    WeightedRandomSelection<String> wRS;
    Configuration conf = new CompositeConfiguration();
    int multiplier = 3;

    @Parameterized.Parameters
    public static Collection<Object[]> weightedRandomSelectionClass() {
        return Arrays.asList({WeightedRandomSelectionImpl.class}, {DynamicWeightedRandomSelectionImpl.class});
    }

    public TestWeightedRandomSelection(Class<? extends WeightedRandomSelection> weightedRandomSelectionClass) {
        this.weightedRandomSelectionClass = weightedRandomSelectionClass;
    }

    @Before
    public void setUp() throws Exception {
        this.wRS = this.weightedRandomSelectionClass.equals(WeightedRandomSelectionImpl.class) ? new WeightedRandomSelectionImpl() : new DynamicWeightedRandomSelectionImpl();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testSelectionWithEqualWeights() throws Exception {
        HashMap<String, TestObj> map = new HashMap<String, TestObj>();
        Long val = 100L;
        int numKeys = 50;
        int totalTries = 1000000;
        HashMap<String, Integer> randomSelection = new HashMap<String, Integer>();
        Integer i = 0;
        while (i < numKeys) {
            map.put(i.toString(), new TestObj(val));
            randomSelection.put(i.toString(), 0);
            Integer n = i;
            i = i + 1;
            Integer n2 = i;
        }
        this.wRS.updateMap(map);
        for (int i2 = 0; i2 < totalTries; ++i2) {
            String key = (String)this.wRS.getNextRandom();
            randomSelection.put(key, (Integer)randomSelection.get(key) + 1);
        }
        double expectedPct = 1.0 / (double)numKeys * 100.0;
        for (Map.Entry e : randomSelection.entrySet()) {
            double actualPct = (double)((Integer)e.getValue()).intValue() / (double)totalTries * 100.0;
            double delta = Math.abs(expectedPct - actualPct) / expectedPct * 100.0;
            System.out.println("Key:" + (String)e.getKey() + " Value:" + e.getValue() + " Expected: " + expectedPct + " Actual: " + actualPct + " delta: " + delta);
            Assert.assertTrue((String)"Not doing uniform selection when weights are equal", (delta < 5.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSelectionWithAllZeroWeights() throws Exception {
        HashMap<String, TestObj> map = new HashMap<String, TestObj>();
        int numKeys = 50;
        int totalTries = 1000000;
        HashMap<String, Integer> randomSelection = new HashMap<String, Integer>();
        Integer i = 0;
        while (i < numKeys) {
            map.put(i.toString(), new TestObj(0L));
            randomSelection.put(i.toString(), 0);
            Integer n = i;
            i = i + 1;
            Integer n2 = i;
        }
        this.wRS.updateMap(map);
        for (int i2 = 0; i2 < totalTries; ++i2) {
            String key = (String)this.wRS.getNextRandom();
            randomSelection.put(key, (Integer)randomSelection.get(key) + 1);
        }
        double expectedPct = 1.0 / (double)numKeys * 100.0;
        for (Map.Entry e : randomSelection.entrySet()) {
            double actualPct = (double)((Integer)e.getValue()).intValue() / (double)totalTries * 100.0;
            double delta = Math.abs(expectedPct - actualPct) / expectedPct * 100.0;
            System.out.println("Key:" + (String)e.getKey() + " Value:" + e.getValue() + " Expected: " + expectedPct + " Actual: " + actualPct);
            Assert.assertTrue((String)"Not doing uniform selection when weights are equal", (delta < 5.0 ? 1 : 0) != 0);
        }
    }

    void verifyResult(Map<String, WeightedRandomSelection.WeightedObject> map, Map<String, Integer> randomSelection, int multiplier, long minWeight, long medianWeight, long totalWeight, int totalTries) {
        ArrayList<Integer> values = new ArrayList<Integer>(randomSelection.values());
        Collections.sort(values);
        int mid = values.size() / 2;
        double medianObserved = values.size() % 2 == 1 ? (double)((Integer)values.get(mid)).intValue() : (double)((Integer)values.get(mid - 1) + (Integer)values.get(mid)) / 2.0;
        double medianObservedWeight = medianObserved / (double)totalTries;
        double medianExpectedWeight = (double)medianWeight / (double)totalWeight;
        for (Map.Entry<String, Integer> e : randomSelection.entrySet()) {
            double observed = (double)e.getValue().intValue() / (double)totalTries;
            double expected = map.get(e.getKey()).getWeight() == 0L ? (double)minWeight / (double)totalWeight : (double)map.get(e.getKey()).getWeight() / (double)totalWeight;
            if (multiplier > 0 && expected > (double)multiplier * medianExpectedWeight) {
                expected = (double)multiplier * medianExpectedWeight;
            }
            double expectedMultiple = expected / medianExpectedWeight;
            double observedMultiple = observed / medianObservedWeight;
            double delta = Math.abs(expectedMultiple - observedMultiple) / expectedMultiple * 100.0;
            System.out.println("Key:" + e.getKey() + " Value:" + e.getValue() + " Expected " + expectedMultiple + " actual " + observedMultiple + " delta " + delta + "%");
            Assert.assertTrue((String)"Not doing uniform selection when weights are equal", (delta < 5.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSelectionWithSomeZeroWeights() throws Exception {
        long minWeight;
        HashMap<String, WeightedRandomSelection.WeightedObject> map = new HashMap<String, WeightedRandomSelection.WeightedObject>();
        HashMap<String, Integer> randomSelection = new HashMap<String, Integer>();
        int numKeys = 50;
        this.multiplier = 3;
        long val = 0L;
        long total = 0L;
        long medianWeight = minWeight = 100L;
        this.wRS.setMaxProbabilityMultiplier(this.multiplier);
        Integer i = 0;
        while (i < numKeys) {
            val = i < numKeys / 3 ? 0L : (i < 2 * (numKeys / 3) ? minWeight : 2L * minWeight);
            total += val;
            map.put(i.toString(), new TestObj(val));
            randomSelection.put(i.toString(), 0);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        this.wRS.updateMap(map);
        int totalTries = 1000000;
        for (int i2 = 0; i2 < totalTries; ++i2) {
            String key = (String)this.wRS.getNextRandom();
            randomSelection.put(key, (Integer)randomSelection.get(key) + 1);
        }
        this.verifyResult(map, randomSelection, this.multiplier, minWeight, medianWeight, total, totalTries);
    }

    @Test
    public void testSelectionWithUnequalWeights() throws Exception {
        HashMap<String, WeightedRandomSelection.WeightedObject> map = new HashMap<String, WeightedRandomSelection.WeightedObject>();
        HashMap<String, Integer> randomSelection = new HashMap<String, Integer>();
        int numKeys = 50;
        this.multiplier = 4;
        long val = 0L;
        long total = 0L;
        long minWeight = 100L;
        long medianWeight = 2L * minWeight;
        this.wRS.setMaxProbabilityMultiplier(this.multiplier);
        Integer i = 0;
        while (i < numKeys) {
            val = i < numKeys / 3 ? minWeight : (i < 2 * (numKeys / 3) ? 2L * minWeight : 10L * minWeight);
            total += val;
            map.put(i.toString(), new TestObj(val));
            randomSelection.put(i.toString(), 0);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        this.wRS.updateMap(map);
        int totalTries = 1000000;
        for (int i2 = 0; i2 < totalTries; ++i2) {
            String key = (String)this.wRS.getNextRandom();
            randomSelection.put(key, (Integer)randomSelection.get(key) + 1);
        }
        this.verifyResult(map, randomSelection, this.multiplier, minWeight, medianWeight, total, totalTries);
    }

    @Test
    public void testSelectionWithHotNode() throws Exception {
        long minWeight;
        HashMap<String, WeightedRandomSelection.WeightedObject> map = new HashMap<String, WeightedRandomSelection.WeightedObject>();
        HashMap<String, Integer> randomSelection = new HashMap<String, Integer>();
        this.multiplier = 3;
        int numKeys = 50;
        long total = 0L;
        long val = minWeight = 100L;
        long medianWeight = minWeight;
        this.wRS.setMaxProbabilityMultiplier(this.multiplier);
        Integer i = 0;
        while (i < numKeys) {
            if (i == numKeys - 1) {
                val = (long)(10 * (numKeys - 1)) * 100L;
            }
            total += val;
            map.put(i.toString(), new TestObj(val));
            randomSelection.put(i.toString(), 0);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        this.wRS.updateMap(map);
        int totalTries = 1000000;
        for (int i2 = 0; i2 < totalTries; ++i2) {
            String key = (String)this.wRS.getNextRandom();
            randomSelection.put(key, (Integer)randomSelection.get(key) + 1);
        }
        this.verifyResult(map, randomSelection, this.multiplier, minWeight, medianWeight, total, totalTries);
    }

    @Test
    public void testSelectionWithHotNodeWithLimit() throws Exception {
        long minWeight;
        HashMap<String, WeightedRandomSelection.WeightedObject> map = new HashMap<String, WeightedRandomSelection.WeightedObject>();
        HashMap<String, Integer> randomSelection = new HashMap<String, Integer>();
        this.multiplier = 3;
        int numKeys = 50;
        long total = 0L;
        long val = minWeight = 100L;
        long medianWeight = minWeight;
        this.wRS.setMaxProbabilityMultiplier(this.multiplier);
        Integer i = 0;
        while (i < numKeys) {
            if (i == numKeys - 1) {
                val = (long)(10 * (numKeys - 1)) * 100L;
            }
            total += val;
            map.put(i.toString(), new TestObj(val));
            randomSelection.put(i.toString(), 0);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        this.wRS.updateMap(map);
        int totalTries = 1000000;
        for (int i2 = 0; i2 < totalTries; ++i2) {
            String key = (String)this.wRS.getNextRandom();
            randomSelection.put(key, (Integer)randomSelection.get(key) + 1);
        }
        this.verifyResult(map, randomSelection, this.multiplier, minWeight, medianWeight, total, totalTries);
    }

    @Test
    public void testSelectionFromSelectedNodesWithEqualWeights() throws Exception {
        int i;
        Assume.assumeTrue((boolean)this.weightedRandomSelectionClass.equals(DynamicWeightedRandomSelectionImpl.class));
        HashMap<String, TestObj> map = new HashMap<String, TestObj>();
        Long val = 100L;
        int numKeys = 50;
        int totalTries = 1000;
        HashMap<String, Integer> randomSelection = new HashMap<String, Integer>();
        Integer i2 = 0;
        while (i2 < numKeys) {
            map.put(i2.toString(), new TestObj(val));
            randomSelection.put(i2.toString(), 0);
            Integer n = i2;
            Integer n2 = i2 = Integer.valueOf(i2 + 1);
        }
        HashSet<String> selectFrom = new HashSet<String>();
        for (i = 0; i < numKeys / 2; ++i) {
            selectFrom.add(Integer.toString(i));
        }
        this.wRS.updateMap(map);
        for (i = 0; i < totalTries; ++i) {
            String selectedKey = (String)this.wRS.getNextRandom(selectFrom);
            Assert.assertTrue((String)"NextRandom key should be from selected list", (boolean)selectFrom.contains(selectedKey));
        }
    }

    static class TestObj
    implements WeightedRandomSelection.WeightedObject {
        long val;

        TestObj(long value) {
            this.val = value;
        }

        public long getWeight() {
            return this.val;
        }
    }
}

