/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.discover;

import com.google.common.collect.Lists;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.testing.MoreAsserts;
import org.apache.bookkeeper.common.testing.executors.MockExecutorController;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.discover.ZKRegistrationClient;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.bookkeeper.zookeeper.MockZooKeeperTestCase;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ZKRegistrationClient.class, ZkUtils.class})
public abstract class AbstractTestZkRegistrationClient
extends MockZooKeeperTestCase {
    private static final Logger log = LoggerFactory.getLogger(AbstractTestZkRegistrationClient.class);
    @Rule
    public final TestName runtime = new TestName();
    private String ledgersPath;
    private String regPath;
    private String regAllPath;
    private String regReadonlyPath;
    private ZKRegistrationClient zkRegistrationClient;
    private ScheduledExecutorService mockExecutor;
    private MockExecutorController controller;
    private final boolean bookieAddressChangeTracking;

    public AbstractTestZkRegistrationClient(boolean bookieAddressChangeTracking) {
        this.bookieAddressChangeTracking = bookieAddressChangeTracking;
    }

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.ledgersPath = "/" + this.runtime.getMethodName();
        this.regPath = this.ledgersPath + "/" + "available";
        this.regAllPath = this.ledgersPath + "/" + "cookies";
        this.regReadonlyPath = this.regPath + "/" + "readonly";
        this.mockExecutor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        this.controller = new MockExecutorController().controlExecute(this.mockExecutor).controlSubmit(this.mockExecutor).controlSchedule(this.mockExecutor).controlScheduleAtFixedRate(this.mockExecutor, 10);
        this.zkRegistrationClient = new ZKRegistrationClient(this.mockZk, this.ledgersPath, this.mockExecutor, this.bookieAddressChangeTracking);
        Assert.assertEquals((Object)this.bookieAddressChangeTracking, (Object)this.zkRegistrationClient.isBookieAddressTracking());
    }

    @After
    public void teardown() {
        if (null != this.zkRegistrationClient) {
            this.zkRegistrationClient.close();
        }
    }

    private static Set<BookieId> prepareNBookies(int num) {
        HashSet<BookieId> bookies = new HashSet<BookieId>();
        for (int i = 0; i < num; ++i) {
            bookies.add(new BookieSocketAddress("127.0.0.1", 3181 + i).toBookieId());
        }
        return bookies;
    }

    private void prepareReadBookieServiceInfo(BookieId address, boolean readonly) throws Exception {
        if (readonly) {
            this.mockZkGetData(this.regPath + "/" + address.toString(), this.zkRegistrationClient.isBookieAddressTracking(), KeeperException.Code.NONODE.intValue(), new byte[0], new Stat());
            this.mockZkGetData(this.regReadonlyPath + "/" + address.toString(), this.zkRegistrationClient.isBookieAddressTracking(), KeeperException.Code.OK.intValue(), new byte[0], new Stat());
        } else {
            this.mockZkGetData(this.regPath + "/" + address.toString(), this.zkRegistrationClient.isBookieAddressTracking(), KeeperException.Code.OK.intValue(), new byte[0], new Stat());
            this.mockZkGetData(this.regReadonlyPath + "/" + address.toString(), this.zkRegistrationClient.isBookieAddressTracking(), KeeperException.Code.NONODE.intValue(), new byte[0], new Stat());
        }
    }

    @Test
    public void testGetWritableBookies() throws Exception {
        Set<BookieId> addresses = AbstractTestZkRegistrationClient.prepareNBookies(10);
        ArrayList children = Lists.newArrayList();
        for (BookieId address : addresses) {
            children.add(address.toString());
            this.prepareReadBookieServiceInfo(address, false);
        }
        Stat stat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)stat.getCversion()).thenReturn((Object)1234);
        this.mockGetChildren(this.regPath, false, KeeperException.Code.OK.intValue(), children, stat);
        Versioned result = (Versioned)FutureUtils.result((CompletableFuture)this.zkRegistrationClient.getWritableBookies());
        Assert.assertEquals((Object)new LongVersion(1234L), (Object)result.getVersion());
        MoreAsserts.assertSetEquals(addresses, (Set)((Set)result.getValue()));
    }

    @Test
    public void testGetAllBookies() throws Exception {
        Set<BookieId> addresses = AbstractTestZkRegistrationClient.prepareNBookies(10);
        ArrayList children = Lists.newArrayList();
        int i = 0;
        for (BookieId address : addresses) {
            children.add(address.toString());
            boolean readonly = i++ % 2 == 0;
            this.prepareReadBookieServiceInfo(address, readonly);
        }
        Stat stat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)stat.getCversion()).thenReturn((Object)1234);
        this.mockGetChildren(this.regAllPath, false, KeeperException.Code.OK.intValue(), children, stat);
        Versioned result = (Versioned)FutureUtils.result((CompletableFuture)this.zkRegistrationClient.getAllBookies());
        Assert.assertEquals((Object)new LongVersion(1234L), (Object)result.getVersion());
        MoreAsserts.assertSetEquals(addresses, (Set)((Set)result.getValue()));
    }

    @Test
    public void testGetReadOnlyBookies() throws Exception {
        Set<BookieId> addresses = AbstractTestZkRegistrationClient.prepareNBookies(10);
        ArrayList children = Lists.newArrayList();
        for (BookieId address : addresses) {
            children.add(address.toString());
            this.prepareReadBookieServiceInfo(address, false);
        }
        Stat stat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)stat.getCversion()).thenReturn((Object)1234);
        this.mockGetChildren(this.regReadonlyPath, false, KeeperException.Code.OK.intValue(), children, stat);
        Versioned result = (Versioned)FutureUtils.result((CompletableFuture)this.zkRegistrationClient.getReadOnlyBookies());
        Assert.assertEquals((Object)new LongVersion(1234L), (Object)result.getVersion());
        MoreAsserts.assertSetEquals(addresses, (Set)((Set)result.getValue()));
    }

    @Test
    public void testGetWritableBookiesFailure() throws Exception {
        this.mockGetChildren(this.regPath, false, KeeperException.Code.NONODE.intValue(), null, null);
        try {
            FutureUtils.result((CompletableFuture)this.zkRegistrationClient.getWritableBookies());
            Assert.fail((String)"Should fail to get writable bookies");
        }
        catch (BKException.ZKException zKException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAllBookiesFailure() throws Exception {
        this.mockGetChildren(this.regAllPath, false, KeeperException.Code.NONODE.intValue(), null, null);
        try {
            FutureUtils.result((CompletableFuture)this.zkRegistrationClient.getAllBookies());
            Assert.fail((String)"Should fail to get all bookies");
        }
        catch (BKException.ZKException zKException) {
            // empty catch block
        }
    }

    @Test
    public void testGetReadOnlyBookiesFailure() throws Exception {
        this.mockGetChildren(this.regReadonlyPath, false, KeeperException.Code.NONODE.intValue(), null, null);
        try {
            FutureUtils.result((CompletableFuture)this.zkRegistrationClient.getReadOnlyBookies());
            Assert.fail((String)"Should fail to get writable bookies");
        }
        catch (BKException.ZKException zKException) {
            // empty catch block
        }
    }

    @Test
    public void testWatchWritableBookiesSuccess() throws Exception {
        this.testWatchBookiesSuccess(true);
    }

    @Test
    public void testWatchReadonlyBookiesSuccess() throws Exception {
        this.testWatchBookiesSuccess(false);
    }

    /*
     * WARNING - void declaration
     */
    private void testWatchBookiesSuccess(boolean isWritable) throws Exception {
        void var14_18;
        LinkedBlockingQueue updates = (LinkedBlockingQueue)Mockito.spy(new LinkedBlockingQueue());
        RegistrationClient.RegistrationListener listener = bookies -> {
            try {
                updates.put(bookies);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted on enqueue bookie updates", (Throwable)e);
            }
        };
        Set<BookieId> addresses = AbstractTestZkRegistrationClient.prepareNBookies(10);
        ArrayList children = Lists.newArrayList();
        for (BookieId address : addresses) {
            children.add(address.toString());
            this.prepareReadBookieServiceInfo(address, !isWritable);
        }
        Stat stat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)stat.getCversion()).thenReturn((Object)1234);
        this.mockGetChildren(isWritable ? this.regPath : this.regReadonlyPath, true, KeeperException.Code.OK.intValue(), children, stat);
        if (isWritable) {
            FutureUtils.result((CompletableFuture)this.zkRegistrationClient.watchWritableBookies(listener));
        } else {
            FutureUtils.result((CompletableFuture)this.zkRegistrationClient.watchReadOnlyBookies(listener));
        }
        Versioned update = (Versioned)updates.take();
        ((LinkedBlockingQueue)Mockito.verify((Object)updates, (VerificationMode)Mockito.times((int)1))).put(ArgumentMatchers.any(Versioned.class));
        Assert.assertEquals((Object)new LongVersion(1234L), (Object)update.getVersion());
        MoreAsserts.assertSetEquals(addresses, (Set)((Set)update.getValue()));
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).getChildren(ArgumentMatchers.anyString(), (Watcher)ArgumentMatchers.any(Watcher.class), (AsyncCallback.Children2Callback)ArgumentMatchers.any(AsyncCallback.Children2Callback.class), ArgumentMatchers.any());
        LinkedBlockingQueue secondUpdates = (LinkedBlockingQueue)Mockito.spy(new LinkedBlockingQueue());
        RegistrationClient.RegistrationListener secondListener = bookies -> {
            try {
                secondUpdates.put(bookies);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted on enqueue bookie updates", (Throwable)e);
            }
        };
        if (isWritable) {
            FutureUtils.result((CompletableFuture)this.zkRegistrationClient.watchWritableBookies(secondListener));
        } else {
            FutureUtils.result((CompletableFuture)this.zkRegistrationClient.watchReadOnlyBookies(secondListener));
        }
        Versioned secondListenerUpdate = (Versioned)secondUpdates.take();
        ((LinkedBlockingQueue)Mockito.verify((Object)updates, (VerificationMode)Mockito.times((int)1))).put(ArgumentMatchers.any(Versioned.class));
        ((LinkedBlockingQueue)Mockito.verify((Object)secondUpdates, (VerificationMode)Mockito.times((int)1))).put(ArgumentMatchers.any(Versioned.class));
        Assert.assertSame((Object)update.getVersion(), (Object)secondListenerUpdate.getVersion());
        Assert.assertSame((Object)update.getValue(), (Object)secondListenerUpdate.getValue());
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)1))).getChildren(ArgumentMatchers.anyString(), (Watcher)ArgumentMatchers.any(Watcher.class), (AsyncCallback.Children2Callback)ArgumentMatchers.any(AsyncCallback.Children2Callback.class), ArgumentMatchers.any());
        this.notifyWatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, isWritable ? this.regPath : this.regReadonlyPath);
        this.controller.advance(Duration.ofMillis(200L));
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)2))).getChildren(ArgumentMatchers.anyString(), (Watcher)ArgumentMatchers.any(Watcher.class), (AsyncCallback.Children2Callback)ArgumentMatchers.any(AsyncCallback.Children2Callback.class), ArgumentMatchers.any());
        Assert.assertNull(updates.poll());
        ((LinkedBlockingQueue)Mockito.verify((Object)updates, (VerificationMode)Mockito.times((int)1))).put(ArgumentMatchers.any(Versioned.class));
        ((LinkedBlockingQueue)Mockito.verify((Object)secondUpdates, (VerificationMode)Mockito.times((int)1))).put(ArgumentMatchers.any(Versioned.class));
        Set<BookieId> newAddresses = AbstractTestZkRegistrationClient.prepareNBookies(20);
        ArrayList newChildren = Lists.newArrayList();
        for (BookieId bookieId : newAddresses) {
            newChildren.add(bookieId.toString());
            this.prepareReadBookieServiceInfo(bookieId, !isWritable);
        }
        Stat newStat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)newStat.getCversion()).thenReturn((Object)1235);
        this.mockGetChildren(isWritable ? this.regPath : this.regReadonlyPath, true, KeeperException.Code.OK.intValue(), newChildren, newStat);
        this.notifyWatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, isWritable ? this.regPath : this.regReadonlyPath);
        update = (Versioned)updates.take();
        Assert.assertEquals((Object)new LongVersion(1235L), (Object)update.getVersion());
        MoreAsserts.assertSetEquals(newAddresses, (Set)((Set)update.getValue()));
        secondListenerUpdate = (Versioned)secondUpdates.take();
        Assert.assertSame((Object)update.getVersion(), (Object)secondListenerUpdate.getVersion());
        Assert.assertSame((Object)update.getValue(), (Object)secondListenerUpdate.getValue());
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)3))).getChildren(ArgumentMatchers.anyString(), (Watcher)ArgumentMatchers.any(Watcher.class), (AsyncCallback.Children2Callback)ArgumentMatchers.any(AsyncCallback.Children2Callback.class), ArgumentMatchers.any());
        ((LinkedBlockingQueue)Mockito.verify((Object)updates, (VerificationMode)Mockito.times((int)2))).put(ArgumentMatchers.any(Versioned.class));
        ((LinkedBlockingQueue)Mockito.verify((Object)secondUpdates, (VerificationMode)Mockito.times((int)2))).put(ArgumentMatchers.any(Versioned.class));
        newAddresses = AbstractTestZkRegistrationClient.prepareNBookies(25);
        newChildren.clear();
        newChildren = Lists.newArrayList();
        for (BookieId address : newAddresses) {
            newChildren.add(address.toString());
            this.prepareReadBookieServiceInfo(address, !isWritable);
        }
        newStat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)newStat.getCversion()).thenReturn((Object)1236);
        this.mockGetChildren(isWritable ? this.regPath : this.regReadonlyPath, true, KeeperException.Code.OK.intValue(), newChildren, newStat);
        if (isWritable) {
            Assert.assertEquals((long)2L, (long)this.zkRegistrationClient.getWatchWritableBookiesTask().getNumListeners());
            this.zkRegistrationClient.unwatchWritableBookies(secondListener);
            Assert.assertEquals((long)1L, (long)this.zkRegistrationClient.getWatchWritableBookiesTask().getNumListeners());
        } else {
            Assert.assertEquals((long)2L, (long)this.zkRegistrationClient.getWatchReadOnlyBookiesTask().getNumListeners());
            this.zkRegistrationClient.unwatchReadOnlyBookies(secondListener);
            Assert.assertEquals((long)1L, (long)this.zkRegistrationClient.getWatchReadOnlyBookiesTask().getNumListeners());
        }
        this.notifyWatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, isWritable ? this.regPath : this.regReadonlyPath);
        update = (Versioned)updates.take();
        Assert.assertEquals((Object)new LongVersion(1236L), (Object)update.getVersion());
        MoreAsserts.assertSetEquals(newAddresses, (Set)((Set)update.getValue()));
        secondListenerUpdate = (Versioned)secondUpdates.poll();
        Assert.assertNull((Object)secondListenerUpdate);
        ((ZooKeeper)Mockito.verify((Object)this.mockZk, (VerificationMode)Mockito.times((int)4))).getChildren(ArgumentMatchers.anyString(), (Watcher)ArgumentMatchers.any(Watcher.class), (AsyncCallback.Children2Callback)ArgumentMatchers.any(AsyncCallback.Children2Callback.class), ArgumentMatchers.any());
        ((LinkedBlockingQueue)Mockito.verify((Object)updates, (VerificationMode)Mockito.times((int)3))).put(ArgumentMatchers.any(Versioned.class));
        ((LinkedBlockingQueue)Mockito.verify((Object)secondUpdates, (VerificationMode)Mockito.times((int)2))).put(ArgumentMatchers.any(Versioned.class));
        if (isWritable) {
            ZKRegistrationClient.WatchTask watchTask = this.zkRegistrationClient.getWatchWritableBookiesTask();
            Assert.assertFalse((boolean)watchTask.isClosed());
            this.zkRegistrationClient.unwatchWritableBookies(listener);
            Assert.assertNull((Object)this.zkRegistrationClient.getWatchWritableBookiesTask());
        } else {
            ZKRegistrationClient.WatchTask watchTask = this.zkRegistrationClient.getWatchReadOnlyBookiesTask();
            Assert.assertFalse((boolean)watchTask.isClosed());
            this.zkRegistrationClient.unwatchReadOnlyBookies(listener);
            Assert.assertNull((Object)this.zkRegistrationClient.getWatchReadOnlyBookiesTask());
        }
        Assert.assertTrue((boolean)var14_18.isClosed());
    }

    @Test
    public void testWatchWritableBookiesTwice() throws Exception {
        this.testWatchBookiesTwice(true);
    }

    @Test
    public void testWatchReadonlyBookiesTwice() throws Exception {
        this.testWatchBookiesTwice(false);
    }

    private void testWatchBookiesTwice(boolean isWritable) throws Exception {
        int zkCallbackDelayMs = 100;
        Set<BookieId> addresses = AbstractTestZkRegistrationClient.prepareNBookies(10);
        ArrayList children = Lists.newArrayList();
        for (BookieId address : addresses) {
            children.add(address.toString());
            this.prepareReadBookieServiceInfo(address, !isWritable);
        }
        Stat stat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)stat.getCversion()).thenReturn((Object)1234);
        this.mockGetChildren(isWritable ? this.regPath : this.regReadonlyPath, true, KeeperException.Code.OK.intValue(), children, stat, zkCallbackDelayMs);
        CompletableFuture firstResult = new CompletableFuture();
        RegistrationClient.RegistrationListener firstListener = bookies -> firstResult.complete(bookies);
        CompletableFuture secondResult = new CompletableFuture();
        RegistrationClient.RegistrationListener secondListener = bookies -> secondResult.complete(bookies);
        ArrayList watchFutures = Lists.newArrayListWithExpectedSize((int)2);
        if (isWritable) {
            watchFutures.add(this.zkRegistrationClient.watchWritableBookies(firstListener));
            watchFutures.add(this.zkRegistrationClient.watchWritableBookies(secondListener));
        } else {
            watchFutures.add(this.zkRegistrationClient.watchReadOnlyBookies(firstListener));
            watchFutures.add(this.zkRegistrationClient.watchReadOnlyBookies(secondListener));
        }
        this.zkCallbackController.advance(Duration.ofMillis(zkCallbackDelayMs));
        FutureUtils.result((CompletableFuture)FutureUtils.collect((List)watchFutures));
        Assert.assertEquals((Object)((Versioned)firstResult.get()).getVersion(), (Object)((Versioned)secondResult.get()).getVersion());
        MoreAsserts.assertSetEquals((Set)((Set)((Versioned)firstResult.get()).getValue()), (Set)((Set)((Versioned)secondResult.get()).getValue()));
    }

    @Test
    public void testWatchWritableBookiesFailure() throws Exception {
        this.testWatchBookiesFailure(true);
    }

    @Test
    public void testWatchReadonlyBookiesFailure() throws Exception {
        this.testWatchBookiesFailure(false);
    }

    private void testWatchBookiesFailure(boolean isWritable) throws Exception {
        ZKRegistrationClient.WatchTask watchTask;
        CompletableFuture watchFuture;
        int zkCallbackDelayMs = 100;
        this.mockGetChildren(isWritable ? this.regPath : this.regReadonlyPath, true, KeeperException.Code.NONODE.intValue(), null, null, zkCallbackDelayMs);
        CompletableFuture listenerResult = new CompletableFuture();
        RegistrationClient.RegistrationListener listener = bookies -> listenerResult.complete(bookies);
        if (isWritable) {
            watchFuture = this.zkRegistrationClient.watchWritableBookies(listener);
            watchTask = this.zkRegistrationClient.getWatchWritableBookiesTask();
        } else {
            watchFuture = this.zkRegistrationClient.watchReadOnlyBookies(listener);
            watchTask = this.zkRegistrationClient.getWatchReadOnlyBookiesTask();
        }
        Assert.assertNotNull((Object)watchTask);
        Assert.assertEquals((long)1L, (long)watchTask.getNumListeners());
        this.zkCallbackController.advance(Duration.ofMillis(zkCallbackDelayMs));
        try {
            FutureUtils.result((CompletableFuture)watchFuture);
            Assert.fail((String)"Should fail to watch writable bookies if reg path doesn't exist");
        }
        catch (BKException.ZKException zKException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)watchTask.getNumListeners());
        Assert.assertTrue((boolean)watchTask.isClosed());
        if (isWritable) {
            Assert.assertNull((Object)this.zkRegistrationClient.getWatchWritableBookiesTask());
        } else {
            Assert.assertNull((Object)this.zkRegistrationClient.getWatchReadOnlyBookiesTask());
        }
    }
}

