/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.discover;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;

public class MockRegistrationClient
implements RegistrationClient {
    final ExecutorService executor;
    private long currentVersion = 0L;
    private Set<BookieId> bookies = new HashSet<BookieId>();
    private Set<BookieId> allBookies = new HashSet<BookieId>();
    private Set<BookieId> readOnlyBookies = new HashSet<BookieId>();
    private Set<RegistrationClient.RegistrationListener> bookieWatchers = new HashSet<RegistrationClient.RegistrationListener>();
    private Set<RegistrationClient.RegistrationListener> readOnlyBookieWatchers = new HashSet<RegistrationClient.RegistrationListener>();

    public MockRegistrationClient() {
        this.executor = Executors.newSingleThreadExecutor(r -> new Thread(r, "MockRegistrationClient"));
    }

    public void close() {
        this.executor.shutdownNow();
    }

    private static Versioned<Set<BookieId>> versioned(Set<BookieId> bookies, long version) {
        return new Versioned(Collections.unmodifiableSet(bookies), (Version)new LongVersion(version));
    }

    public CompletableFuture<Void> addBookies(BookieId ... bookies) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        this.executor.submit(() -> {
            ++this.currentVersion;
            Collections.addAll(this.bookies, bookies);
            this.bookieWatchers.forEach(w -> w.onBookiesChanged(MockRegistrationClient.versioned(this.bookies, this.currentVersion)));
            promise.complete(null);
        });
        return promise;
    }

    public CompletableFuture<Void> removeBookies(BookieId ... bookies) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        this.executor.submit(() -> {
            ++this.currentVersion;
            this.bookies.addAll(Arrays.asList(bookies));
            this.bookieWatchers.forEach(w -> w.onBookiesChanged(MockRegistrationClient.versioned(this.bookies, this.currentVersion)));
            promise.complete(null);
        });
        return promise;
    }

    public CompletableFuture<Void> addReadOnlyBookies(BookieId ... bookies) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        this.executor.submit(() -> {
            ++this.currentVersion;
            this.readOnlyBookies.addAll(Arrays.asList(bookies));
            this.readOnlyBookieWatchers.forEach(w -> w.onBookiesChanged(MockRegistrationClient.versioned(this.readOnlyBookies, this.currentVersion)));
            promise.complete(null);
        });
        return promise;
    }

    public CompletableFuture<Void> removeReadOnlyBookies(BookieId ... bookies) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        this.executor.submit(() -> {
            ++this.currentVersion;
            this.readOnlyBookies.addAll(Arrays.asList(bookies));
            this.readOnlyBookieWatchers.forEach(w -> w.onBookiesChanged(MockRegistrationClient.versioned(this.readOnlyBookies, this.currentVersion)));
            promise.complete(null);
        });
        return promise;
    }

    public CompletableFuture<Versioned<Set<BookieId>>> getWritableBookies() {
        CompletableFuture<Versioned<Set<BookieId>>> promise = new CompletableFuture<Versioned<Set<BookieId>>>();
        this.executor.submit(() -> promise.complete(MockRegistrationClient.versioned(this.bookies, this.currentVersion)));
        return promise;
    }

    public CompletableFuture<Versioned<Set<BookieId>>> getAllBookies() {
        CompletableFuture<Versioned<Set<BookieId>>> promise = new CompletableFuture<Versioned<Set<BookieId>>>();
        this.executor.submit(() -> promise.complete(MockRegistrationClient.versioned(this.allBookies, this.currentVersion)));
        return promise;
    }

    public CompletableFuture<Versioned<Set<BookieId>>> getReadOnlyBookies() {
        CompletableFuture<Versioned<Set<BookieId>>> promise = new CompletableFuture<Versioned<Set<BookieId>>>();
        this.executor.submit(() -> promise.complete(MockRegistrationClient.versioned(this.readOnlyBookies, this.currentVersion)));
        return promise;
    }

    public CompletableFuture<Void> watchWritableBookies(RegistrationClient.RegistrationListener listener) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        this.executor.submit(() -> {
            this.bookieWatchers.add(listener);
            promise.complete(null);
        });
        return promise;
    }

    public void unwatchWritableBookies(RegistrationClient.RegistrationListener listener) {
        this.executor.submit(() -> this.bookieWatchers.remove(listener));
    }

    public CompletableFuture<Void> watchReadOnlyBookies(RegistrationClient.RegistrationListener listener) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        this.executor.submit(() -> {
            this.readOnlyBookieWatchers.add(listener);
            promise.complete(null);
        });
        return promise;
    }

    public void unwatchReadOnlyBookies(RegistrationClient.RegistrationListener listener) {
        this.executor.submit(() -> this.readOnlyBookieWatchers.remove(listener));
    }
}

