/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.meta.CleanupLedgerManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.versioning.Version;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CleanupLedgerManagerTest {
    protected LedgerManager ledgerManager = null;
    protected CleanupLedgerManager cleanupLedgerManager = null;

    @Before
    public void setup() throws Exception {
        this.ledgerManager = (LedgerManager)Mockito.mock(LedgerManager.class);
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new Exception("LedgerNotExistException"));
        Mockito.when((Object)this.ledgerManager.createLedgerMetadata(ArgumentMatchers.anyLong(), (LedgerMetadata)ArgumentMatchers.any())).thenReturn(future);
        Mockito.when((Object)this.ledgerManager.readLedgerMetadata(ArgumentMatchers.anyLong())).thenReturn(future);
        Mockito.when((Object)this.ledgerManager.writeLedgerMetadata(ArgumentMatchers.anyLong(), (LedgerMetadata)ArgumentMatchers.any(), (Version)ArgumentMatchers.any())).thenReturn(future);
        CompletableFuture removeFuture = new CompletableFuture();
        removeFuture.completeExceptionally(new Exception("LedgerNotExistException"));
        Mockito.when((Object)this.ledgerManager.removeLedgerMetadata(ArgumentMatchers.anyLong(), (Version)ArgumentMatchers.any())).thenReturn(removeFuture);
        this.cleanupLedgerManager = new CleanupLedgerManager(this.ledgerManager);
    }

    @Test
    public void testCreateLedgerMetadataException() throws Exception {
        this.cleanupLedgerManager.createLedgerMetadata(ArgumentMatchers.anyLong(), (LedgerMetadata)ArgumentMatchers.any(LedgerMetadata.class));
        Assert.assertEquals((long)0L, (long)this.cleanupLedgerManager.getCurrentFuturePromiseSize());
    }

    @Test
    public void testReadLedgerMetadataException() throws Exception {
        this.cleanupLedgerManager.readLedgerMetadata(ArgumentMatchers.anyLong());
        Assert.assertEquals((long)0L, (long)this.cleanupLedgerManager.getCurrentFuturePromiseSize());
    }

    @Test
    public void testWriteLedgerMetadataException() throws Exception {
        this.cleanupLedgerManager.writeLedgerMetadata(ArgumentMatchers.anyLong(), (LedgerMetadata)ArgumentMatchers.any(LedgerMetadata.class), (Version)ArgumentMatchers.any(Version.class));
        Assert.assertEquals((long)0L, (long)this.cleanupLedgerManager.getCurrentFuturePromiseSize());
    }

    @Test
    public void testRemoveLedgerMetadataException() throws Exception {
        this.cleanupLedgerManager.removeLedgerMetadata(ArgumentMatchers.anyLong(), (Version)ArgumentMatchers.any(Version.class));
        Assert.assertEquals((long)0L, (long)this.cleanupLedgerManager.getCurrentFuturePromiseSize());
    }
}

