/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.meta.LedgerMetadataSerDe;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.junit.Assert;
import org.junit.Test;

public class TestLedgerMetadataSerDe {
    private static final String version1 = "Qm9va2llTWV0YWRhdGFGb3JtYXRWZXJzaW9uCTEKMgozCjAKMAkxOTIuMC4yLjE6MTIzNAkxOTIuMC4yLjI6MTIzNAkxOTIuMC4yLjM6MTIzNAotMTAyCUNMT1NFRA==";
    private static final String version2 = "Qm9va2llTWV0YWRhdGFGb3JtYXRWZXJzaW9uCTIKcXVvcnVtU2l6ZTogMgplbnNlbWJsZVNpemU6IDMKbGVuZ3RoOiAwCmxhc3RFbnRyeUlkOiAtMQpzdGF0ZTogSU5fUkVDT1ZFUlkKc2VnbWVudCB7CiAgZW5zZW1ibGVNZW1iZXI6ICIxOTIuMC4yLjE6MTIzNCIKICBlbnNlbWJsZU1lbWJlcjogIjE5Mi4wLjIuMjoxMjM0IgogIGVuc2VtYmxlTWVtYmVyOiAiMTkyLjAuMi4zOjEyMzQiCiAgZmlyc3RFbnRyeUlkOiAwCn0KZGlnZXN0VHlwZTogQ1JDMzIKcGFzc3dvcmQ6ICJwYXNzd2QiCmFja1F1b3J1bVNpemU6IDIK";
    private static final String version2ctime = "Qm9va2llTWV0YWRhdGFGb3JtYXRWZXJzaW9uCTIKcXVvcnVtU2l6ZTogMgplbnNlbWJsZVNpemU6IDMKbGVuZ3RoOiAwCmxhc3RFbnRyeUlkOiAtMQpzdGF0ZTogSU5fUkVDT1ZFUlkKc2VnbWVudCB7CiAgZW5zZW1ibGVNZW1iZXI6ICIxOTIuMC4yLjE6MTIzNCIKICBlbnNlbWJsZU1lbWJlcjogIjE5Mi4wLjIuMjoxMjM0IgogIGVuc2VtYmxlTWVtYmVyOiAiMTkyLjAuMi4zOjEyMzQiCiAgZmlyc3RFbnRyeUlkOiAwCn0KZGlnZXN0VHlwZTogQ1JDMzIKcGFzc3dvcmQ6ICJwYXNzd2QiCmFja1F1b3J1bVNpemU6IDIKY3RpbWU6IDE1NDQwMDIzODMwNzUK";
    private static final String version3 = "Qm9va2llTWV0YWRhdGFGb3JtYXRWZXJzaW9uCTMKYAgCEAMYACD///////////8BKAEyMgoOMTkyLjAuMi4xOjMxODEKDjE5Mi4wLjIuMjozMTgxCg4xOTIuMC4yLjM6MzE4MRAAOANCBmZvb2JhckgBUP///////////wFgAA==";

    private static void testDecodeEncode(String encoded) throws Exception {
        LedgerMetadataSerDe serDe = new LedgerMetadataSerDe();
        LedgerMetadata md = serDe.parseConfig(Base64.getDecoder().decode(encoded), 59L, Optional.empty());
        String reserialized = Base64.getEncoder().encodeToString(serDe.serialize(md));
        Assert.assertEquals((Object)encoded, (Object)reserialized);
    }

    @Test
    public void testVersion1SerDe() throws Exception {
        TestLedgerMetadataSerDe.testDecodeEncode(version1);
    }

    @Test
    public void testVersion2SerDe() throws Exception {
        TestLedgerMetadataSerDe.testDecodeEncode(version2);
    }

    @Test
    public void testVersion2CtimeSerDe() throws Exception {
        TestLedgerMetadataSerDe.testDecodeEncode(version2ctime);
    }

    @Test
    public void testVersion3SerDe() throws Exception {
        TestLedgerMetadataSerDe.testDecodeEncode(version3);
    }

    @Test(expected=IOException.class)
    public void testJunkSerDe() throws Exception {
        LedgerMetadataSerDe serDe = new LedgerMetadataSerDe();
        String junk = "";
        serDe.parseConfig(junk.getBytes(StandardCharsets.UTF_8), 59L, Optional.empty());
    }

    @Test(expected=IOException.class)
    public void testJunk2SerDe() throws Exception {
        byte[] randomBytes = new byte[1000];
        new Random().nextBytes(randomBytes);
        LedgerMetadataSerDe serDe = new LedgerMetadataSerDe();
        serDe.parseConfig(randomBytes, 59L, Optional.empty());
    }

    @Test(expected=IOException.class)
    public void testJunkVersionSerDe() throws Exception {
        byte[] junkVersion = "BookieMetadataFormatVersion\tfoobar\nblahblah".getBytes(StandardCharsets.UTF_8);
        LedgerMetadataSerDe serDe = new LedgerMetadataSerDe();
        serDe.parseConfig(junkVersion, 59L, Optional.empty());
    }

    @Test(expected=IOException.class)
    public void testVeryLongVersionSerDe() throws Exception {
        byte[] veryLongVersion = "BookieMetadataFormatVersion\t123456789123456789\nblahblah".getBytes(StandardCharsets.UTF_8);
        LedgerMetadataSerDe serDe = new LedgerMetadataSerDe();
        serDe.parseConfig(veryLongVersion, 59L, Optional.empty());
    }

    @Test
    public void testPeggedToV3SerDe() throws Exception {
        LedgerMetadataSerDe serDe = new LedgerMetadataSerDe();
        LedgerMetadata metadata = LedgerMetadataBuilder.create().withId(13L).withEnsembleSize(3).withWriteQuorumSize(2).withAckQuorumSize(1).withPassword("foobar".getBytes(StandardCharsets.UTF_8)).withDigestType(DigestType.CRC32C).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{new BookieSocketAddress("192.0.2.1", 3181).toBookieId(), new BookieSocketAddress("192.0.2.2", 3181).toBookieId(), new BookieSocketAddress("192.0.2.3", 3181).toBookieId()})).build();
        byte[] encoded = serDe.serialize(metadata);
        LedgerMetadata decoded = serDe.parseConfig(encoded, 59L, Optional.empty());
        Assert.assertEquals((long)3L, (long)decoded.getMetadataFormatVersion());
    }

    @Test
    public void testStoreSystemtimeAsLedgerCtimeEnabledWithNewerVersion() throws Exception {
        LedgerMetadata lm = LedgerMetadataBuilder.create().withId(13L).withEnsembleSize(3).withWriteQuorumSize(2).withAckQuorumSize(1).withPassword("foobar".getBytes(StandardCharsets.UTF_8)).withDigestType(DigestType.CRC32C).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{new BookieSocketAddress("192.0.2.1", 1234).toBookieId(), new BookieSocketAddress("192.0.2.2", 1234).toBookieId(), new BookieSocketAddress("192.0.2.3", 1234).toBookieId()})).withCreationTime(123456L).storingCreationTime(true).build();
        LedgerMetadataSerDe serDe = new LedgerMetadataSerDe();
        byte[] serialized = serDe.serialize(lm);
        LedgerMetadata deserialized = serDe.parseConfig(serialized, 59L, Optional.of(654321L));
        Assert.assertEquals((long)deserialized.getCtime(), (long)123456L);
        LedgerMetadata deserialized2 = serDe.parseConfig(serDe.serialize(deserialized), 59L, Optional.of(98765L));
        Assert.assertEquals((long)deserialized2.getCtime(), (long)123456L);
    }

    @Test
    public void testStoreSystemtimeAsLedgerCtimeDisabledWithNewerVersion() throws Exception {
        LedgerMetadata lm = LedgerMetadataBuilder.create().withId(13L).withEnsembleSize(3).withWriteQuorumSize(2).withAckQuorumSize(1).withPassword("foobar".getBytes(StandardCharsets.UTF_8)).withDigestType(DigestType.CRC32C).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{new BookieSocketAddress("192.0.2.1", 1234).toBookieId(), new BookieSocketAddress("192.0.2.2", 1234).toBookieId(), new BookieSocketAddress("192.0.2.3", 1234).toBookieId()})).build();
        LedgerMetadataSerDe serDe = new LedgerMetadataSerDe();
        byte[] serialized = serDe.serialize(lm);
        LedgerMetadata deserialized = serDe.parseConfig(serialized, 59L, Optional.of(654321L));
        Assert.assertEquals((long)654321L, (long)deserialized.getCtime());
        LedgerMetadata deserialized2 = serDe.parseConfig(serDe.serialize(deserialized), 59L, Optional.of(98765L));
        Assert.assertEquals((long)98765L, (long)deserialized2.getCtime());
    }
}

