/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.bookkeeper.proto.BookieProtoEncoding;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class BookieProtoEncodingTest {
    private ExtensionRegistry registry;

    @Before
    public void setup() {
        this.registry = ExtensionRegistry.newInstance();
    }

    @Test
    public void testV3ResponseDecoderNoFallback() throws Exception {
        BookieProtocol.AddResponse v2Resp = BookieProtocol.AddResponse.create((byte)2, (int)0, (long)1L, (long)2L);
        BookkeeperProtocol.Response v3Resp = BookkeeperProtocol.Response.newBuilder().setHeader(BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setTxnId(1L).setOperation(BookkeeperProtocol.OperationType.ADD_ENTRY).build()).setStatus(BookkeeperProtocol.StatusCode.EOK).setAddResponse(BookkeeperProtocol.AddResponse.newBuilder().setStatus(BookkeeperProtocol.StatusCode.EOK).setLedgerId(1L).setEntryId(2L).build()).build();
        ArrayList outList = Lists.newArrayList();
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)ctx.fireChannelRead(ArgumentMatchers.any())).thenAnswer(iom -> {
            outList.add(iom.getArgument(0));
            return null;
        });
        BookieProtoEncoding.ResponseEnDeCoderPreV3 v2Encoder = new BookieProtoEncoding.ResponseEnDeCoderPreV3(this.registry);
        BookieProtoEncoding.ResponseEnDecoderV3 v3Encoder = new BookieProtoEncoding.ResponseEnDecoderV3(this.registry);
        BookieProtoEncoding.ResponseDecoder v3Decoder = new BookieProtoEncoding.ResponseDecoder(this.registry, false, false);
        try {
            v3Decoder.channelRead(ctx, v2Encoder.encode((Object)v2Resp, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            Assert.fail((String)"V3 response decoder should fail on decoding v2 response");
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)outList.size());
        ByteBuf serWithFrameSize = (ByteBuf)v3Encoder.encode((Object)v3Resp, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        ByteBuf ser = serWithFrameSize.slice(4, serWithFrameSize.readableBytes() - 4);
        v3Decoder.channelRead(ctx, (Object)ser);
        Assert.assertEquals((long)1L, (long)outList.size());
    }

    @Test(expected=IllegalStateException.class)
    public void testV2RequestDecoderThrowExceptionOnUnknownRequests() throws Exception {
        BookieProtoEncoding.RequestEnDeCoderPreV3 v2ReqEncoder = new BookieProtoEncoding.RequestEnDeCoderPreV3(this.registry);
        BookieProtoEncoding.RequestEnDecoderV3 v3ReqEncoder = new BookieProtoEncoding.RequestEnDecoderV3(this.registry);
        BookkeeperProtocol.Request v3Req = BookkeeperProtocol.Request.newBuilder().setHeader(BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setTxnId(1L).setOperation(BookkeeperProtocol.OperationType.ADD_ENTRY).build()).setAddRequest(BookkeeperProtocol.AddRequest.newBuilder().setLedgerId(1L).setEntryId(2L).setMasterKey(ByteString.copyFrom((String)"", (Charset)StandardCharsets.UTF_8)).setFlag(BookkeeperProtocol.AddRequest.Flag.RECOVERY_ADD).setBody(ByteString.copyFrom((String)"test", (Charset)StandardCharsets.UTF_8))).build();
        v2ReqEncoder.decode((ByteBuf)v3ReqEncoder.encode((Object)v3Req, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
    }
}

