/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.channel.Channel;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.GetBookieInfoProcessorV3;
import org.apache.bookkeeper.proto.RequestStats;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GetBookieInfoProcessorV3Test {
    private Channel channel;
    private BookieRequestProcessor requestProcessor;
    private Bookie bookie;
    private RequestStats requestStats;
    private OpStatsLogger getBookieInfoStats;
    private OpStatsLogger channelWriteStats;
    private OpStatsLogger getBookieInfoRequestStats;

    @Before
    public void setup() {
        this.getBookieInfoStats = (OpStatsLogger)Mockito.mock(OpStatsLogger.class);
        this.channelWriteStats = (OpStatsLogger)Mockito.mock(OpStatsLogger.class);
        this.getBookieInfoRequestStats = (OpStatsLogger)Mockito.mock(OpStatsLogger.class);
        this.requestStats = (RequestStats)Mockito.mock(RequestStats.class);
        this.requestProcessor = (BookieRequestProcessor)Mockito.mock(BookieRequestProcessor.class);
        this.bookie = (Bookie)Mockito.mock(Bookie.class);
        Mockito.when((Object)this.requestProcessor.getBookie()).thenReturn((Object)this.bookie);
        this.channel = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)this.channel.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.channel.isActive()).thenReturn((Object)true);
        Mockito.when((Object)this.requestProcessor.getRequestStats()).thenReturn((Object)this.requestStats);
        Mockito.when((Object)this.requestProcessor.getRequestStats().getGetBookieInfoStats()).thenReturn((Object)this.getBookieInfoStats);
        Mockito.when((Object)this.requestProcessor.getRequestStats().getChannelWriteStats()).thenReturn((Object)this.channelWriteStats);
        Mockito.when((Object)this.requestProcessor.getRequestStats().getGetBookieInfoRequestStats()).thenReturn((Object)this.getBookieInfoRequestStats);
    }

    @Test
    public void testGetBookieInfoProcessorStats() throws IOException {
        BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.GET_BOOKIE_INFO).setTxnId(0L);
        BookkeeperProtocol.GetBookieInfoRequest.Builder getBookieInfoBuilder = BookkeeperProtocol.GetBookieInfoRequest.newBuilder().setRequested(2L);
        BookkeeperProtocol.Request getBookieInfoRequest = BookkeeperProtocol.Request.newBuilder().setHeader(headerBuilder).setGetBookieInfoRequest(getBookieInfoBuilder).build();
        GetBookieInfoProcessorV3 getBookieInfo = new GetBookieInfoProcessorV3(getBookieInfoRequest, this.channel, this.requestProcessor);
        getBookieInfo.run();
        ((OpStatsLogger)Mockito.verify((Object)this.getBookieInfoStats, (VerificationMode)Mockito.times((int)1))).registerSuccessfulEvent(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS))));
        Mockito.when((Object)this.requestProcessor.getBookie().getTotalFreeSpace()).thenThrow(new Throwable[]{new IOException("test for failed.")});
        getBookieInfo.run();
        ((OpStatsLogger)Mockito.verify((Object)this.getBookieInfoStats, (VerificationMode)Mockito.times((int)1))).registerFailedEvent(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS))));
    }
}

