/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistry;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import org.apache.bookkeeper.auth.AuthProviderFactoryFactory;
import org.apache.bookkeeper.auth.ClientAuthProvider;
import org.apache.bookkeeper.auth.TestAuth;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.PerChannelBookieClient;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;

public class TestBackwardCompatCMS42
extends BookKeeperClusterTestCase {
    private static final byte[] SUCCESS_RESPONSE = new byte[]{1};
    private static final byte[] FAILURE_RESPONSE = new byte[]{2};
    private static final byte[] PAYLOAD_MESSAGE = new byte[]{3};
    ExtensionRegistry extRegistry = ExtensionRegistry.newInstance();
    ClientAuthProvider.Factory authProvider;
    EventLoopGroup eventLoopGroup = new NioEventLoopGroup();
    OrderedExecutor executor = OrderedExecutor.newBuilder().numThreads(1).name("TestBackwardCompatClient").build();

    public TestBackwardCompatCMS42() throws Exception {
        super(0);
        this.baseConf.setGcWaitTime(60000L);
        this.authProvider = AuthProviderFactoryFactory.newClientAuthProviderFactory((ClientConfiguration)new ClientConfiguration());
    }

    @Test
    public void testAuthSingleMessage() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setBookieAuthProviderFactoryClass(TestAuth.AlwaysSucceedBookieAuthProviderFactory.class.getName());
        BookieServer bookie1 = this.startAndStoreBookie(bookieConf);
        BookkeeperProtocol.AuthMessage.Builder builder = BookkeeperProtocol.AuthMessage.newBuilder().setAuthPluginName("TestAuthProviderPlugin");
        builder.setPayload(ByteString.copyFrom((byte[])PAYLOAD_MESSAGE));
        BookkeeperProtocol.AuthMessage authMessage = builder.build();
        CompatClient42 client = this.newCompatClient(bookie1.getBookieId());
        BookieProtocol.AuthRequest request = new BookieProtocol.AuthRequest(2, authMessage);
        client.sendRequest((BookieProtocol.Request)request);
        BookieProtocol.Response response = client.takeResponse();
        Assert.assertTrue((String)"Should be auth response", (boolean)(response instanceof BookieProtocol.AuthResponse));
        Assert.assertEquals((String)"Should have succeeded", (long)response.getErrorCode(), (long)0L);
    }

    @Test
    public void testAuthMultiMessage() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setBookieAuthProviderFactoryClass(TestAuth.SucceedAfter3BookieAuthProviderFactory.class.getName());
        BookieServer bookie1 = this.startAndStoreBookie(bookieConf);
        BookkeeperProtocol.AuthMessage.Builder builder = BookkeeperProtocol.AuthMessage.newBuilder().setAuthPluginName("TestAuthProviderPlugin");
        builder.setPayload(ByteString.copyFrom((byte[])PAYLOAD_MESSAGE));
        BookkeeperProtocol.AuthMessage authMessage = builder.build();
        CompatClient42 client = this.newCompatClient(bookie1.getBookieId());
        BookieProtocol.AuthRequest request = new BookieProtocol.AuthRequest(2, authMessage);
        for (int i = 0; i < 3; ++i) {
            client.sendRequest((BookieProtocol.Request)request);
            BookieProtocol.Response response = client.takeResponse();
            Assert.assertTrue((String)"Should be auth response", (boolean)(response instanceof BookieProtocol.AuthResponse));
            BookieProtocol.AuthResponse authResponse = (BookieProtocol.AuthResponse)response;
            Assert.assertEquals((String)"Should have succeeded", (long)response.getErrorCode(), (long)0L);
            byte[] type = authResponse.getAuthMessage().getPayload().toByteArray();
            if (i == 2) {
                Assert.assertArrayEquals((String)"Should succeed after 3", (byte[])type, (byte[])SUCCESS_RESPONSE);
                continue;
            }
            Assert.assertArrayEquals((String)"Should be payload", (byte[])type, (byte[])PAYLOAD_MESSAGE);
        }
    }

    @Test
    public void testAuthFail() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setBookieAuthProviderFactoryClass(TestAuth.FailAfter3BookieAuthProviderFactory.class.getName());
        BookieServer bookie1 = this.startAndStoreBookie(bookieConf);
        BookkeeperProtocol.AuthMessage.Builder builder = BookkeeperProtocol.AuthMessage.newBuilder().setAuthPluginName("TestAuthProviderPlugin");
        builder.setPayload(ByteString.copyFrom((byte[])PAYLOAD_MESSAGE));
        BookkeeperProtocol.AuthMessage authMessage = builder.build();
        CompatClient42 client = this.newCompatClient(bookie1.getBookieId());
        BookieProtocol.AuthRequest request = new BookieProtocol.AuthRequest(2, authMessage);
        for (int i = 0; i < 3; ++i) {
            client.sendRequest((BookieProtocol.Request)request);
            BookieProtocol.Response response = client.takeResponse();
            Assert.assertTrue((String)"Should be auth response", (boolean)(response instanceof BookieProtocol.AuthResponse));
            BookieProtocol.AuthResponse authResponse = (BookieProtocol.AuthResponse)response;
            Assert.assertEquals((String)"Should have succeeded", (long)response.getErrorCode(), (long)0L);
            byte[] type = authResponse.getAuthMessage().getPayload().toByteArray();
            if (i == 2) {
                Assert.assertArrayEquals((String)"Should fail after 3", (byte[])type, (byte[])FAILURE_RESPONSE);
                continue;
            }
            Assert.assertArrayEquals((String)"Should be payload", (byte[])type, (byte[])PAYLOAD_MESSAGE);
        }
        client.sendRequest((BookieProtocol.Request)new BookieProtocol.ReadRequest(2, 1L, 1L, 0, null));
        BookieProtocol.Response response = client.takeResponse();
        Assert.assertEquals((String)"Should have failed", (long)response.getErrorCode(), (long)102L);
    }

    BookieServer startAndStoreBookie(ServerConfiguration conf) throws Exception {
        return this.startAndAddBookie(conf).getServer();
    }

    CompatClient42 newCompatClient(BookieId addr) throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setUseV2WireProtocol(true);
        return new CompatClient42(conf, this.executor, this.eventLoopGroup, addr, this.authProvider, this.extRegistry);
    }

    class CompatClient42
    extends PerChannelBookieClient {
        final ArrayBlockingQueue<BookieProtocol.Response> responses;
        Channel channel;
        final CountDownLatch connected;

        CompatClient42(ClientConfiguration conf, OrderedExecutor executor, EventLoopGroup eventLoopGroup, BookieId addr, ClientAuthProvider.Factory authProviderFactory, ExtensionRegistry extRegistry) throws Exception {
            super(conf, executor, eventLoopGroup, addr, (StatsLogger)NullStatsLogger.INSTANCE, authProviderFactory, extRegistry, null, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
            this.responses = new ArrayBlockingQueue(10);
            this.connected = new CountDownLatch(1);
            this.state = PerChannelBookieClient.ConnectionState.CONNECTING;
            ChannelFuture future = this.connect();
            future.await();
            this.channel = future.channel();
            this.connected.countDown();
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (!(msg instanceof BookieProtocol.Response)) {
                LOG.error("Unknown message {}, passing upstream", msg);
                ctx.fireChannelRead(msg);
                return;
            }
            this.responses.add((BookieProtocol.Response)msg);
        }

        BookieProtocol.Response takeResponse() throws Exception {
            return this.responses.take();
        }

        BookieProtocol.Response pollResponse() throws Exception {
            return this.responses.poll();
        }

        void sendRequest(BookieProtocol.Request request) throws Exception {
            this.connected.await();
            this.channel.writeAndFlush((Object)request);
        }
    }
}

