/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import java.util.Set;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncLedgerOpsTest
extends BookKeeperClusterTestCase
implements AsyncCallback.AddCallback,
AsyncCallback.ReadCallback,
AsyncCallback.CreateCallback,
AsyncCallback.CloseCallback,
AsyncCallback.OpenCallback {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncLedgerOpsTest.class);
    private final BookKeeper.DigestType digestType;
    byte[] ledgerPassword = "aaa".getBytes();
    LedgerHandle lh;
    LedgerHandle lh2;
    long ledgerId;
    Enumeration<LedgerEntry> ls;
    int numEntriesToWrite = 20;
    int maxInt = Integer.MAX_VALUE;
    Random rng;
    ArrayList<byte[]> entries;
    ArrayList<Integer> entriesSize;
    SyncObj sync;
    Set<Object> syncObjs;

    public AsyncLedgerOpsTest() {
        super(3);
        this.digestType = BookKeeper.DigestType.CRC32;
        String ledgerManagerFactory = "org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory";
        this.baseConf.setLedgerManagerFactoryClassName(ledgerManagerFactory);
        this.baseClientConf.setLedgerManagerFactoryClassName(ledgerManagerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncCreateClose() throws IOException, BKException {
        try {
            ControlObj ctx;
            ControlObj controlObj = ctx = new ControlObj();
            synchronized (controlObj) {
                LOG.info("Going to create ledger asynchronously");
                this.bkc.asyncCreateLedger(3, 2, this.digestType, this.ledgerPassword, this, ctx);
                ctx.wait();
            }
            LedgerHandle lh = ctx.getLh();
            this.ledgerId = lh.getId();
            LOG.info("Ledger ID: " + lh.getId());
            for (int i = 0; i < this.numEntriesToWrite; ++i) {
                ByteBuffer entry = ByteBuffer.allocate(4);
                entry.putInt(this.rng.nextInt(this.maxInt));
                entry.position(0);
                this.entries.add(entry.array());
                this.entriesSize.add(entry.array().length);
                lh.asyncAddEntry(entry.array(), (AsyncCallback.AddCallback)this, (Object)this.sync);
            }
            Object i = this.sync;
            synchronized (i) {
                while (this.sync.counter < this.numEntriesToWrite) {
                    LOG.debug("Entries counter = " + this.sync.counter);
                    this.sync.wait();
                }
            }
            LOG.info("*** WRITE COMPLETE ***");
            i = ctx;
            synchronized (i) {
                lh.asyncClose((AsyncCallback.CloseCallback)this, (Object)ctx);
                ctx.wait();
            }
            i = ctx;
            synchronized (i) {
                this.bkc.asyncOpenLedger(this.ledgerId, this.digestType, this.ledgerPassword, this, ctx);
                ctx.wait();
            }
            lh = ctx.getLh();
            LOG.debug("Number of entries written: " + lh.getLastAddConfirmed());
            Assert.assertTrue((String)"Verifying number of entries written", (lh.getLastAddConfirmed() == (long)(this.numEntriesToWrite - 1) ? 1 : 0) != 0);
            lh.asyncReadEntries(0L, (long)(this.numEntriesToWrite - 1), (AsyncCallback.ReadCallback)this, (Object)this.sync);
            i = this.sync;
            synchronized (i) {
                while (!this.sync.value) {
                    this.sync.wait();
                }
            }
            LOG.debug("*** READ COMPLETE ***");
            int i2 = 0;
            while (this.ls.hasMoreElements()) {
                ByteBuffer origbb = ByteBuffer.wrap(this.entries.get(i2));
                Integer origEntry = origbb.getInt();
                byte[] entry = this.ls.nextElement().getEntry();
                ByteBuffer result = ByteBuffer.wrap(entry);
                LOG.debug("Length of result: " + result.capacity());
                LOG.debug("Original entry: " + origEntry);
                Integer retrEntry = result.getInt();
                LOG.debug("Retrieved entry: " + retrEntry);
                Assert.assertTrue((String)("Checking entry " + i2 + " for equality"), (boolean)origEntry.equals(retrEntry));
                Assert.assertTrue((String)("Checking entry " + i2 + " for size"), (entry.length == this.entriesSize.get(i2) ? 1 : 0) != 0);
                ++i2;
            }
            Assert.assertTrue((String)"Checking number of read entries", (i2 == this.numEntriesToWrite ? 1 : 0) != 0);
            lh.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Interrupted", (Throwable)e);
            Assert.fail((String)"InterruptedException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
        SyncObj x;
        SyncObj syncObj = x = (SyncObj)ctx;
        synchronized (syncObj) {
            ++x.counter;
            x.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readComplete(int rc, LedgerHandle lh, Enumeration<LedgerEntry> seq, Object ctx) {
        this.ls = seq;
        SyncObj syncObj = this.sync;
        synchronized (syncObj) {
            this.sync.value = true;
            this.sync.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createComplete(int rc, LedgerHandle lh, Object ctx) {
        Object object = ctx;
        synchronized (object) {
            ControlObj cobj = (ControlObj)ctx;
            cobj.setLh(lh);
            cobj.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openComplete(int rc, LedgerHandle lh, Object ctx) {
        Object object = ctx;
        synchronized (object) {
            ControlObj cobj = (ControlObj)ctx;
            cobj.setLh(lh);
            cobj.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeComplete(int rc, LedgerHandle lh, Object ctx) {
        Object object = ctx;
        synchronized (object) {
            ControlObj cobj = (ControlObj)ctx;
            cobj.notify();
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rng = new Random(System.currentTimeMillis());
        this.entries = new ArrayList();
        this.entriesSize = new ArrayList();
        this.sync = new SyncObj();
    }

    class ControlObj {
        LedgerHandle lh;

        ControlObj() {
        }

        void setLh(LedgerHandle lh) {
            this.lh = lh;
        }

        LedgerHandle getLh() {
            return this.lh;
        }
    }

    class SyncObj {
        int counter = 0;
        boolean value = false;
    }
}

