/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.File;
import java.util.HashSet;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.MockUncleanShutdownDetection;
import org.apache.bookkeeper.bookie.TestBookieImpl;
import org.apache.bookkeeper.bookie.UncleanShutdownDetection;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.PortManager;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieZKExpireTest
extends BookKeeperClusterTestCase {
    private static final Logger log = LoggerFactory.getLogger(BookieZKExpireTest.class);

    public BookieZKExpireTest() {
        super(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBookieServerZKRequestTimeoutBehaviour() throws Exception {
        System.setProperty("zookeeper.request.timeout", "6000");
        this.baseConf.setZkTimeout(24000);
        this.baseClientConf.setZkTimeout(24000);
        BookieServer server = null;
        try {
            File f = this.tmpDirs.createNew("bookieserver", "test");
            HashSet<Thread> threadset = new HashSet<Thread>();
            int threadCount = Thread.activeCount();
            Thread[] threads = new Thread[threadCount * 2];
            threadCount = Thread.enumerate(threads);
            for (int i = 0; i < threadCount; ++i) {
                if (threads[i].getName().indexOf("SendThread") == -1) continue;
                threadset.add(threads[i]);
            }
            ServerConfiguration conf = this.newServerConfiguration(PortManager.nextFreePort(), f, new File[]{f});
            server = new BookieServer(conf, (Bookie)new TestBookieImpl(conf), (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (UncleanShutdownDetection)new MockUncleanShutdownDetection());
            server.start();
            int secondsToWait = 5;
            while (!server.isRunning()) {
                Thread.sleep(1000L);
                if (secondsToWait-- > 0) continue;
                Assert.fail((String)"Bookie never started");
            }
            Thread sendthread = null;
            threadCount = Thread.activeCount();
            threads = new Thread[threadCount * 2];
            threadCount = Thread.enumerate(threads);
            for (int i = 0; i < threadCount; ++i) {
                if (threads[i].getName().indexOf("SendThread") == -1 || threadset.contains(threads[i])) continue;
                sendthread = threads[i];
                break;
            }
            Assert.assertNotNull((String)"Send thread not found", sendthread);
            log.info("Suspending threads");
            sendthread.suspend();
            Thread.sleep(12000L);
            log.info("Resuming threads");
            sendthread.resume();
            Thread.sleep(3000L);
            Assert.assertTrue((String)"Bookie should not shutdown on zk timeout", (boolean)server.isBookieRunning());
            Assert.assertTrue((String)"Bookie Server should not shutdown on zk timeout", (boolean)server.isRunning());
        }
        finally {
            System.clearProperty("zookeeper.request.timeout");
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBookieServerZKSessionExpireBehaviour() throws Exception {
        System.setProperty("zookeeper.request.timeout", "0");
        this.baseConf.setZkTimeout(6000);
        this.baseClientConf.setZkTimeout(6000);
        BookieServer server = null;
        try {
            File f = this.tmpDirs.createNew("bookieserver", "test");
            HashSet<Thread> threadset = new HashSet<Thread>();
            int threadCount = Thread.activeCount();
            Thread[] threads = new Thread[threadCount * 2];
            threadCount = Thread.enumerate(threads);
            for (int i = 0; i < threadCount; ++i) {
                if (threads[i].getName().indexOf("SendThread") == -1) continue;
                threadset.add(threads[i]);
            }
            ServerConfiguration conf = this.newServerConfiguration(PortManager.nextFreePort(), f, new File[]{f});
            server = new BookieServer(conf, (Bookie)new TestBookieImpl(conf), (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (UncleanShutdownDetection)new MockUncleanShutdownDetection());
            server.start();
            int secondsToWait = 5;
            while (!server.isRunning()) {
                Thread.sleep(1000L);
                if (secondsToWait-- > 0) continue;
                Assert.fail((String)"Bookie never started");
            }
            Thread sendthread = null;
            threadCount = Thread.activeCount();
            threads = new Thread[threadCount * 2];
            threadCount = Thread.enumerate(threads);
            for (int i = 0; i < threadCount; ++i) {
                if (threads[i].getName().indexOf("SendThread") == -1 || threadset.contains(threads[i])) continue;
                sendthread = threads[i];
                break;
            }
            Assert.assertNotNull((String)"Send thread not found", sendthread);
            log.info("Suspending threads");
            sendthread.suspend();
            Thread.sleep(2L * (long)conf.getZkTimeout());
            log.info("Resuming threads");
            sendthread.resume();
            Thread.sleep(3000L);
            Assert.assertFalse((String)"Bookie should shutdown on losing zk session", (boolean)server.isBookieRunning());
            Assert.assertFalse((String)"Bookie Server should shutdown on losing zk session", (boolean)server.isRunning());
        }
        finally {
            System.clearProperty("zookeeper.request.timeout");
            server.shutdown();
        }
    }
}

