/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurationTest {
    @Test
    public void testConfigurationOverwrite() {
        System.clearProperty("metadataServiceUri");
        ServerConfiguration conf = new ServerConfiguration();
        Assert.assertEquals(null, (Object)conf.getMetadataServiceUriUnchecked());
        System.setProperty("metadataServiceUri", "zk://server:2181/ledgers");
        Assert.assertEquals((Object)"zk://server:2181/ledgers", (Object)conf.getMetadataServiceUriUnchecked());
        ServerConfiguration conf2 = new ServerConfiguration();
        Assert.assertEquals((Object)"zk://server:2181/ledgers", (Object)conf2.getMetadataServiceUriUnchecked());
        System.clearProperty("metadataServiceUri");
        ServerConfiguration newConf = new ServerConfiguration();
        Assert.assertEquals(null, (Object)newConf.getMetadataServiceUriUnchecked());
        newConf.setMetadataServiceUri("zk://newserver:2181/ledgers");
        Assert.assertEquals((Object)"zk://newserver:2181/ledgers", (Object)newConf.getMetadataServiceUriUnchecked());
        conf2.loadConf((CompositeConfiguration)newConf);
        Assert.assertEquals((Object)"zk://newserver:2181/ledgers", (Object)conf2.getMetadataServiceUriUnchecked());
    }

    @Test
    public void testGetZkServers() {
        System.setProperty("metadataServiceUri", "zk://server1:port1;server2:port2/ledgers");
        ServerConfiguration conf = new ServerConfiguration();
        ClientConfiguration clientConf = new ClientConfiguration();
        Assert.assertEquals((String)"zookeeper connect string doesn't match in server configuration", (Object)"zk://server1:port1;server2:port2/ledgers", (Object)conf.getMetadataServiceUriUnchecked());
        Assert.assertEquals((String)"zookeeper connect string doesn't match in client configuration", (Object)"zk://server1:port1;server2:port2/ledgers", (Object)clientConf.getMetadataServiceUriUnchecked());
    }

    static {
        System.setProperty("org.apache.bookkeeper.conf.readsystemproperties", "true");
    }
}

