/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.test.ZooKeeperCluster;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.test.QuorumUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperClusterUtil
implements ZooKeeperCluster {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperClusterUtil.class);
    static final Logger LOG;
    private final int numOfZKNodes;
    public QuorumUtil quorumUtil;
    String connectString;
    protected ZooKeeper zkc;

    public static void enableZookeeperTestEnvVariables() {
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
        System.setProperty("zookeeper.admin.enableServer", "false");
        try {
            System.setProperty("build.test.dir", Files.createTempDirectory("zktests", new FileAttribute[0]).toFile().getCanonicalPath());
        }
        catch (IOException e) {
            log.error("Failed to create temp dir, so setting build.test.dir system property to /tmp");
            System.setProperty("build.test.dir", "/tmp");
        }
    }

    public ZooKeeperClusterUtil(int numOfZKNodes) throws IOException, KeeperException, InterruptedException {
        if (numOfZKNodes < 3 || numOfZKNodes % 2 == 0) {
            throw new IllegalArgumentException("numOfZKNodes should be atleast 3 and it should not be even number");
        }
        this.numOfZKNodes = numOfZKNodes;
    }

    @Override
    public String getZooKeeperConnectString() {
        return this.connectString;
    }

    @Override
    public String getMetadataServiceUri() {
        return this.getMetadataServiceUri("/ledgers");
    }

    @Override
    public String getMetadataServiceUri(String zkLedgersRootPath) {
        return this.getMetadataServiceUri(zkLedgersRootPath, "longhierarchical");
    }

    @Override
    public String getMetadataServiceUri(String zkLedgersRootPath, String type) {
        return "zk+" + type + "://" + this.connectString.replace(",", ";") + zkLedgersRootPath;
    }

    @Override
    public ZooKeeper getZooKeeperClient() {
        return this.zkc;
    }

    @Override
    public void startCluster() throws Exception {
        this.quorumUtil = new QuorumUtil(this.numOfZKNodes / 2);
        this.quorumUtil.startAll();
        this.connectString = this.quorumUtil.getConnString();
        LOG.debug("Instantiate ZK Client");
        this.zkc = ZooKeeperClient.newBuilder().connectString(this.getZooKeeperConnectString()).sessionTimeoutMs(10000).build();
        this.createBKEnsemble("/ledgers");
    }

    @Override
    public void stopCluster() throws Exception {
        if (this.zkc != null) {
            this.zkc.close();
        }
        this.quorumUtil.shutdownAll();
    }

    @Override
    public void restartCluster() throws Exception {
        this.quorumUtil.startAll();
    }

    @Override
    public void killCluster() throws Exception {
        this.quorumUtil.tearDown();
    }

    @Override
    public void sleepCluster(int time, TimeUnit timeUnit, CountDownLatch l) throws InterruptedException, IOException {
        throw new UnsupportedOperationException("sleepServer operation is not supported for ZooKeeperClusterUtil");
    }

    static {
        ZooKeeperClusterUtil.enableZookeeperTestEnvVariables();
        LOG = LoggerFactory.getLogger(ZooKeeperClusterUtil.class);
    }
}

