/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util.collections;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.bookkeeper.util.collections.ConcurrentLongLongPairHashMap;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrentLongLongPairHashMapTest {
    @Test
    public void testConstructor() {
        try {
            ConcurrentLongLongPairHashMap.newBuilder().expectedItems(0).build();
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ConcurrentLongLongPairHashMap.newBuilder().expectedItems(16).concurrencyLevel(0).build();
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ConcurrentLongLongPairHashMap.newBuilder().expectedItems(4).concurrencyLevel(8).build();
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void simpleInsertions() {
        ConcurrentLongLongPairHashMap map = ConcurrentLongLongPairHashMap.newBuilder().expectedItems(16).build();
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertTrue((boolean)map.put(1L, 1L, 11L, 11L));
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertTrue((boolean)map.put(2L, 2L, 22L, 22L));
        Assert.assertTrue((boolean)map.put(3L, 3L, 33L, 33L));
        Assert.assertEquals((long)map.size(), (long)3L);
        Assert.assertEquals((Object)map.get(1L, 1L), (Object)new ConcurrentLongLongPairHashMap.LongPair(11L, 11L));
        Assert.assertEquals((long)map.size(), (long)3L);
        Assert.assertTrue((boolean)map.remove(1L, 1L));
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertEquals((Object)map.get(1L, 1L), null);
        Assert.assertEquals((Object)map.get(5L, 5L), null);
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertTrue((boolean)map.put(1L, 1L, 11L, 11L));
        Assert.assertEquals((long)map.size(), (long)3L);
        Assert.assertTrue((boolean)map.put(1L, 1L, 111L, 111L));
        Assert.assertEquals((long)map.size(), (long)3L);
    }

    @Test
    public void testRemove() {
        ConcurrentLongLongPairHashMap map = ConcurrentLongLongPairHashMap.newBuilder().build();
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertTrue((boolean)map.put(1L, 1L, 11L, 11L));
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertFalse((boolean)map.remove(0L, 0L));
        Assert.assertFalse((boolean)map.remove(1L, 1L, 111L, 111L));
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertTrue((boolean)map.remove(1L, 1L, 11L, 11L));
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testClear() {
        ConcurrentLongLongPairHashMap map = ConcurrentLongLongPairHashMap.newBuilder().expectedItems(2).concurrencyLevel(1).autoShrink(true).mapIdleFactor(0.25f).build();
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.put(1L, 1L, 11L, 11L));
        Assert.assertTrue((boolean)map.put(2L, 2L, 22L, 22L));
        Assert.assertTrue((boolean)map.put(3L, 3L, 33L, 33L));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        map.clear();
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
    }

    @Test
    public void testExpandAndShrink() {
        ConcurrentLongLongPairHashMap map = ConcurrentLongLongPairHashMap.newBuilder().expectedItems(2).concurrencyLevel(1).autoShrink(true).mapIdleFactor(0.25f).build();
        Assert.assertTrue((boolean)map.put(1L, 1L, 11L, 11L));
        Assert.assertTrue((boolean)map.put(2L, 2L, 22L, 22L));
        Assert.assertTrue((boolean)map.put(3L, 3L, 33L, 33L));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove(1L, 1L, 11L, 11L));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove(2L, 2L, 22L, 22L));
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.put(4L, 4L, 44L, 44L));
        Assert.assertTrue((boolean)map.put(5L, 5L, 55L, 55L));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.put(6L, 6L, 66L, 66L));
        Assert.assertTrue((boolean)map.remove(6L, 6L, 66L, 66L));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
    }

    @Test
    public void testExpandShrinkAndClear() {
        ConcurrentLongLongPairHashMap map = ConcurrentLongLongPairHashMap.newBuilder().expectedItems(2).concurrencyLevel(1).autoShrink(true).mapIdleFactor(0.25f).build();
        long initCapacity = map.capacity();
        Assert.assertTrue((boolean)map.put(1L, 1L, 11L, 11L));
        Assert.assertTrue((boolean)map.put(2L, 2L, 22L, 22L));
        Assert.assertTrue((boolean)map.put(3L, 3L, 33L, 33L));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove(1L, 1L, 11L, 11L));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove(2L, 2L, 22L, 22L));
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove(3L, 3L, 33L, 33L));
        Assert.assertTrue((map.capacity() == initCapacity ? 1 : 0) != 0);
        map.clear();
        Assert.assertTrue((map.capacity() == initCapacity ? 1 : 0) != 0);
    }

    @Test
    public void testNegativeUsedBucketCount() {
        ConcurrentLongLongPairHashMap map = ConcurrentLongLongPairHashMap.newBuilder().expectedItems(16).concurrencyLevel(1).build();
        map.put(0L, 0L, 0L, 0L);
        Assert.assertEquals((long)1L, (long)map.getUsedBucketCount());
        map.put(0L, 0L, 1L, 1L);
        Assert.assertEquals((long)1L, (long)map.getUsedBucketCount());
        map.remove(0L, 0L);
        Assert.assertEquals((long)0L, (long)map.getUsedBucketCount());
        map.remove(0L, 0L);
        Assert.assertEquals((long)0L, (long)map.getUsedBucketCount());
    }

    @Test
    public void testReduceUnnecessaryExpansions() {
        ConcurrentLongLongPairHashMap map = ConcurrentLongLongPairHashMap.newBuilder().expectedItems(2).concurrencyLevel(1).mapFillFactor(0.9f).build();
        map.put(1L, 1L, 1L, 1L);
        map.put(2L, 2L, 2L, 2L);
        map.put(3L, 3L, 3L, 3L);
        map.remove(1L, 1L);
        map.remove(2L, 2L);
        map.remove(3L, 3L);
        Assert.assertEquals((long)0L, (long)map.getUsedBucketCount());
    }

    @Test
    public void testRehashing() {
        int n = 16;
        ConcurrentLongLongPairHashMap map = ConcurrentLongLongPairHashMap.newBuilder().expectedItems(n / 2).concurrencyLevel(1).build();
        Assert.assertEquals((long)map.capacity(), (long)n);
        Assert.assertEquals((long)map.size(), (long)0L);
        for (int i = 0; i < n; ++i) {
            map.put((long)i, (long)i, (long)i, (long)i);
        }
        Assert.assertEquals((long)map.capacity(), (long)(2 * n));
        Assert.assertEquals((long)map.size(), (long)n);
    }

    @Test
    public void testRehashingWithDeletes() {
        int i;
        int n = 16;
        ConcurrentLongLongPairHashMap map = ConcurrentLongLongPairHashMap.newBuilder().expectedItems(n / 2).concurrencyLevel(1).build();
        Assert.assertEquals((long)map.capacity(), (long)n);
        Assert.assertEquals((long)map.size(), (long)0L);
        for (i = 0; i < n / 2; ++i) {
            map.put((long)i, (long)i, (long)i, (long)i);
        }
        for (i = 0; i < n / 2; ++i) {
            map.remove((long)i, (long)i);
        }
        for (i = n; i < 2 * n; ++i) {
            map.put((long)i, (long)i, (long)i, (long)i);
        }
        Assert.assertEquals((long)map.capacity(), (long)(2 * n));
        Assert.assertEquals((long)map.size(), (long)n);
    }

    @Test
    public void concurrentInsertions() throws Throwable {
        ConcurrentLongLongPairHashMap map = ConcurrentLongLongPairHashMap.newBuilder().build();
        ExecutorService executor = Executors.newCachedThreadPool();
        int nThreads = 16;
        int n = 100000;
        long value = 55L;
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 16) {
            int n2 = i++;
            futures.add(executor.submit(() -> {
                Random random = new Random();
                for (int j = 0; j < 100000; ++j) {
                    long key1 = Math.abs(random.nextLong());
                    key1 -= key1 % (long)(threadIdx + 1);
                    long key2 = Math.abs(random.nextLong());
                    key2 -= key2 % (long)(threadIdx + 1);
                    map.put(key1, key2, value, value);
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)map.size(), (long)1600000L);
        executor.shutdown();
    }

    @Test
    public void concurrentInsertionsAndReads() throws Throwable {
        ConcurrentLongLongPairHashMap map = ConcurrentLongLongPairHashMap.newBuilder().build();
        ExecutorService executor = Executors.newCachedThreadPool();
        int nThreads = 16;
        int n = 100000;
        long value = 55L;
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 16) {
            int n2 = i++;
            futures.add(executor.submit(() -> {
                Random random = new Random();
                for (int j = 0; j < 100000; ++j) {
                    long key1 = Math.abs(random.nextLong());
                    key1 -= key1 % (long)(threadIdx + 1);
                    long key2 = Math.abs(random.nextLong());
                    key2 -= key2 % (long)(threadIdx + 1);
                    map.put(key1, key2, 55L, 55L);
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)map.size(), (long)1600000L);
        executor.shutdown();
    }

    @Test
    public void testIteration() {
        ConcurrentLongLongPairHashMap map = ConcurrentLongLongPairHashMap.newBuilder().build();
        Assert.assertEquals((Object)map.keys(), Collections.emptyList());
        Assert.assertEquals((Object)map.values(), Collections.emptyList());
        map.put(0L, 0L, 0L, 0L);
        Assert.assertEquals((Object)map.keys(), (Object)Lists.newArrayList((Object[])new ConcurrentLongLongPairHashMap.LongPair[]{new ConcurrentLongLongPairHashMap.LongPair(0L, 0L)}));
        Assert.assertEquals((Object)map.values(), (Object)Lists.newArrayList((Object[])new ConcurrentLongLongPairHashMap.LongPair[]{new ConcurrentLongLongPairHashMap.LongPair(0L, 0L)}));
        map.remove(0L, 0L);
        Assert.assertEquals((Object)map.keys(), Collections.emptyList());
        Assert.assertEquals((Object)map.values(), Collections.emptyList());
        map.put(0L, 0L, 0L, 0L);
        map.put(1L, 1L, 11L, 11L);
        map.put(2L, 2L, 22L, 22L);
        List keys = map.keys();
        Collections.sort(keys);
        Assert.assertEquals((Object)keys, (Object)Lists.newArrayList((Object[])new ConcurrentLongLongPairHashMap.LongPair[]{new ConcurrentLongLongPairHashMap.LongPair(0L, 0L), new ConcurrentLongLongPairHashMap.LongPair(1L, 1L), new ConcurrentLongLongPairHashMap.LongPair(2L, 2L)}));
        List values = map.values();
        Collections.sort(values);
        Assert.assertEquals((Object)values, (Object)Lists.newArrayList((Object[])new ConcurrentLongLongPairHashMap.LongPair[]{new ConcurrentLongLongPairHashMap.LongPair(0L, 0L), new ConcurrentLongLongPairHashMap.LongPair(11L, 11L), new ConcurrentLongLongPairHashMap.LongPair(22L, 22L)}));
        map.put(1L, 1L, 111L, 111L);
        keys = map.keys();
        Collections.sort(keys);
        Assert.assertEquals((Object)keys, (Object)Lists.newArrayList((Object[])new ConcurrentLongLongPairHashMap.LongPair[]{new ConcurrentLongLongPairHashMap.LongPair(0L, 0L), new ConcurrentLongLongPairHashMap.LongPair(1L, 1L), new ConcurrentLongLongPairHashMap.LongPair(2L, 2L)}));
        values = map.values();
        Collections.sort(values);
        Assert.assertEquals((Object)values, (Object)Lists.newArrayList((Object[])new ConcurrentLongLongPairHashMap.LongPair[]{new ConcurrentLongLongPairHashMap.LongPair(0L, 0L), new ConcurrentLongLongPairHashMap.LongPair(22L, 22L), new ConcurrentLongLongPairHashMap.LongPair(111L, 111L)}));
        map.clear();
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testPutIfAbsent() {
        ConcurrentLongLongPairHashMap map = ConcurrentLongLongPairHashMap.newBuilder().build();
        Assert.assertTrue((boolean)map.putIfAbsent(1L, 1L, 11L, 11L));
        Assert.assertEquals((Object)map.get(1L, 1L), (Object)new ConcurrentLongLongPairHashMap.LongPair(11L, 11L));
        Assert.assertFalse((boolean)map.putIfAbsent(1L, 1L, 111L, 111L));
        Assert.assertEquals((Object)map.get(1L, 1L), (Object)new ConcurrentLongLongPairHashMap.LongPair(11L, 11L));
    }

    @Test
    public void testIvalidKeys() {
        ConcurrentLongLongPairHashMap map = ConcurrentLongLongPairHashMap.newBuilder().expectedItems(16).concurrencyLevel(1).build();
        try {
            map.put(-5L, 3L, 4L, 4L);
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            map.get(-1L, 0L);
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            map.containsKey(-1L, 0L);
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            map.putIfAbsent(-1L, 1L, 1L, 1L);
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAsMap() {
        ConcurrentLongLongPairHashMap lmap = ConcurrentLongLongPairHashMap.newBuilder().expectedItems(16).concurrencyLevel(1).build();
        lmap.put(1L, 1L, 11L, 11L);
        lmap.put(2L, 2L, 22L, 22L);
        lmap.put(3L, 3L, 33L, 33L);
        TreeMap map = Maps.newTreeMap();
        map.put(new ConcurrentLongLongPairHashMap.LongPair(1L, 1L), new ConcurrentLongLongPairHashMap.LongPair(11L, 11L));
        map.put(new ConcurrentLongLongPairHashMap.LongPair(2L, 2L), new ConcurrentLongLongPairHashMap.LongPair(22L, 22L));
        map.put(new ConcurrentLongLongPairHashMap.LongPair(3L, 3L), new ConcurrentLongLongPairHashMap.LongPair(33L, 33L));
        Assert.assertEquals((Object)map, (Object)lmap.asMap());
    }

    @Test
    public void testSizeInBytes() {
        ConcurrentLongLongPairHashMap lmap = new ConcurrentLongLongPairHashMap(4, 2);
        Assert.assertEquals((long)256L, (long)lmap.sizeInBytes());
        lmap.put(1L, 1L, 1L, 1L);
        Assert.assertEquals((long)256L, (long)lmap.sizeInBytes());
        lmap.put(2L, 2L, 2L, 2L);
        Assert.assertEquals((long)256L, (long)lmap.sizeInBytes());
        lmap.put(3L, 3L, 3L, 3L);
        Assert.assertEquals((long)256L, (long)lmap.sizeInBytes());
        lmap.put(4L, 4L, 4L, 4L);
        Assert.assertEquals((long)256L, (long)lmap.sizeInBytes());
        lmap.put(5L, 5L, 5L, 5L);
        Assert.assertEquals((long)384L, (long)lmap.sizeInBytes());
        lmap.put(6L, 6L, 6L, 6L);
        Assert.assertEquals((long)512L, (long)lmap.sizeInBytes());
        lmap.put(7L, 7L, 7L, 7L);
        Assert.assertEquals((long)512L, (long)lmap.sizeInBytes());
    }
}

