/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util.collections;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.bookkeeper.util.collections.ConcurrentOpenHashSet;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrentOpenHashSetTest {
    @Test
    public void testConstructor() {
        try {
            ConcurrentOpenHashSet.newBuilder().expectedItems(0).build();
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ConcurrentOpenHashSet.newBuilder().expectedItems(14).concurrencyLevel(0).build();
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ConcurrentOpenHashSet.newBuilder().expectedItems(4).concurrencyLevel(8).build();
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void simpleInsertions() {
        ConcurrentOpenHashSet set = ConcurrentOpenHashSet.newBuilder().expectedItems(16).build();
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertTrue((boolean)set.add((Object)"1"));
        Assert.assertFalse((boolean)set.isEmpty());
        Assert.assertTrue((boolean)set.add((Object)"2"));
        Assert.assertTrue((boolean)set.add((Object)"3"));
        Assert.assertEquals((long)set.size(), (long)3L);
        Assert.assertTrue((boolean)set.contains((Object)"1"));
        Assert.assertEquals((long)set.size(), (long)3L);
        Assert.assertTrue((boolean)set.remove((Object)"1"));
        Assert.assertEquals((long)set.size(), (long)2L);
        Assert.assertFalse((boolean)set.contains((Object)"1"));
        Assert.assertFalse((boolean)set.contains((Object)"5"));
        Assert.assertEquals((long)set.size(), (long)2L);
        Assert.assertTrue((boolean)set.add((Object)"1"));
        Assert.assertEquals((long)set.size(), (long)3L);
        Assert.assertFalse((boolean)set.add((Object)"1"));
        Assert.assertEquals((long)set.size(), (long)3L);
    }

    @Test
    public void testClear() {
        ConcurrentOpenHashSet map = ConcurrentOpenHashSet.newBuilder().expectedItems(2).concurrencyLevel(1).autoShrink(true).mapIdleFactor(0.25f).build();
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.add((Object)"k1"));
        Assert.assertTrue((boolean)map.add((Object)"k2"));
        Assert.assertTrue((boolean)map.add((Object)"k3"));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        map.clear();
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
    }

    @Test
    public void testExpandAndShrink() {
        ConcurrentOpenHashSet map = ConcurrentOpenHashSet.newBuilder().expectedItems(2).concurrencyLevel(1).autoShrink(true).mapIdleFactor(0.25f).build();
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.add((Object)"k1"));
        Assert.assertTrue((boolean)map.add((Object)"k2"));
        Assert.assertTrue((boolean)map.add((Object)"k3"));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove((Object)"k1"));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove((Object)"k2"));
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.add((Object)"k4"));
        Assert.assertTrue((boolean)map.add((Object)"k5"));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.add((Object)"k6"));
        Assert.assertTrue((boolean)map.remove((Object)"k6"));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
    }

    @Test
    public void testExpandShrinkAndClear() {
        ConcurrentOpenHashSet map = ConcurrentOpenHashSet.newBuilder().expectedItems(2).concurrencyLevel(1).autoShrink(true).mapIdleFactor(0.25f).build();
        long initCapacity = map.capacity();
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.add((Object)"k1"));
        Assert.assertTrue((boolean)map.add((Object)"k2"));
        Assert.assertTrue((boolean)map.add((Object)"k3"));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove((Object)"k1"));
        Assert.assertTrue((map.capacity() == 8L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove((Object)"k2"));
        Assert.assertTrue((map.capacity() == 4L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)map.remove((Object)"k3"));
        Assert.assertTrue((map.capacity() == initCapacity ? 1 : 0) != 0);
        map.clear();
        Assert.assertTrue((map.capacity() == initCapacity ? 1 : 0) != 0);
    }

    @Test
    public void testReduceUnnecessaryExpansions() {
        ConcurrentOpenHashSet set = ConcurrentOpenHashSet.newBuilder().expectedItems(2).concurrencyLevel(1).build();
        Assert.assertTrue((boolean)set.add((Object)"1"));
        Assert.assertTrue((boolean)set.add((Object)"2"));
        Assert.assertTrue((boolean)set.add((Object)"3"));
        Assert.assertTrue((boolean)set.add((Object)"4"));
        Assert.assertTrue((boolean)set.remove((Object)"1"));
        Assert.assertTrue((boolean)set.remove((Object)"2"));
        Assert.assertTrue((boolean)set.remove((Object)"3"));
        Assert.assertTrue((boolean)set.remove((Object)"4"));
        Assert.assertEquals((long)0L, (long)set.getUsedBucketCount());
    }

    @Test
    public void testRemove() {
        ConcurrentOpenHashSet set = ConcurrentOpenHashSet.newBuilder().build();
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertTrue((boolean)set.add((Object)"1"));
        Assert.assertFalse((boolean)set.isEmpty());
        Assert.assertFalse((boolean)set.remove((Object)"0"));
        Assert.assertFalse((boolean)set.isEmpty());
        Assert.assertTrue((boolean)set.remove((Object)"1"));
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testRehashing() {
        int n = 16;
        ConcurrentOpenHashSet set = ConcurrentOpenHashSet.newBuilder().expectedItems(n / 2).concurrencyLevel(1).build();
        Assert.assertEquals((long)set.capacity(), (long)n);
        Assert.assertEquals((long)set.size(), (long)0L);
        for (int i = 0; i < n; ++i) {
            set.add((Object)i);
        }
        Assert.assertEquals((long)set.capacity(), (long)(2 * n));
        Assert.assertEquals((long)set.size(), (long)n);
    }

    @Test
    public void testRehashingWithDeletes() {
        int i;
        int n = 16;
        ConcurrentOpenHashSet set = ConcurrentOpenHashSet.newBuilder().expectedItems(n / 2).concurrencyLevel(1).build();
        Assert.assertEquals((long)set.capacity(), (long)n);
        Assert.assertEquals((long)set.size(), (long)0L);
        for (i = 0; i < n / 2; ++i) {
            set.add((Object)i);
        }
        for (i = 0; i < n / 2; ++i) {
            set.remove((Object)i);
        }
        for (i = n; i < 2 * n; ++i) {
            set.add((Object)i);
        }
        Assert.assertEquals((long)set.capacity(), (long)(2 * n));
        Assert.assertEquals((long)set.size(), (long)n);
    }

    @Test
    public void concurrentInsertions() throws Throwable {
        ConcurrentOpenHashSet set = ConcurrentOpenHashSet.newBuilder().build();
        ExecutorService executor = Executors.newCachedThreadPool();
        int nThreads = 16;
        int n = 100000;
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 16) {
            int n2 = i++;
            futures.add(executor.submit(() -> {
                Random random = new Random();
                for (int j = 0; j < 100000; ++j) {
                    long key = random.nextLong();
                    key -= key % (long)(threadIdx + 1);
                    set.add((Object)key);
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)set.size(), (long)1600000L);
        executor.shutdown();
    }

    @Test
    public void concurrentInsertionsAndReads() throws Throwable {
        ConcurrentOpenHashSet map = ConcurrentOpenHashSet.newBuilder().build();
        ExecutorService executor = Executors.newCachedThreadPool();
        int nThreads = 16;
        int n = 100000;
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 16) {
            int n2 = i++;
            futures.add(executor.submit(() -> {
                Random random = new Random();
                for (int j = 0; j < 100000; ++j) {
                    long key = random.nextLong();
                    key -= key % (long)(threadIdx + 1);
                    map.add((Object)key);
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)map.size(), (long)1600000L);
        executor.shutdown();
    }

    @Test
    public void testIteration() {
        ConcurrentOpenHashSet set = ConcurrentOpenHashSet.newBuilder().build();
        Assert.assertEquals((Object)set.values(), Collections.emptyList());
        set.add((Object)0L);
        Assert.assertEquals((Object)set.values(), (Object)Lists.newArrayList((Object[])new Long[]{0L}));
        set.remove((Object)0L);
        Assert.assertEquals((Object)set.values(), Collections.emptyList());
        set.add((Object)0L);
        set.add((Object)1L);
        set.add((Object)2L);
        List values = set.values();
        Collections.sort(values);
        Assert.assertEquals((Object)values, (Object)Lists.newArrayList((Object[])new Long[]{0L, 1L, 2L}));
        set.clear();
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testHashConflictWithDeletion() {
        int buckets = 16;
        ConcurrentOpenHashSet set = ConcurrentOpenHashSet.newBuilder().expectedItems(16).concurrencyLevel(1).build();
        long key1 = 1L;
        long key2 = 27L;
        int bucket1 = ConcurrentOpenHashSet.signSafeMod((long)ConcurrentOpenHashSet.hash((Object)key1), (int)16);
        int bucket2 = ConcurrentOpenHashSet.signSafeMod((long)ConcurrentOpenHashSet.hash((Object)key2), (int)16);
        Assert.assertEquals((long)bucket1, (long)bucket2);
        Assert.assertTrue((boolean)set.add((Object)key1));
        Assert.assertTrue((boolean)set.add((Object)key2));
        Assert.assertEquals((long)set.size(), (long)2L);
        Assert.assertTrue((boolean)set.remove((Object)key1));
        Assert.assertEquals((long)set.size(), (long)1L);
        Assert.assertTrue((boolean)set.add((Object)key1));
        Assert.assertEquals((long)set.size(), (long)2L);
        Assert.assertTrue((boolean)set.remove((Object)key1));
        Assert.assertEquals((long)set.size(), (long)1L);
        Assert.assertFalse((boolean)set.add((Object)key2));
        Assert.assertTrue((boolean)set.contains((Object)key2));
        Assert.assertEquals((long)set.size(), (long)1L);
        Assert.assertTrue((boolean)set.remove((Object)key2));
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testEqualsObjects() {
        ConcurrentOpenHashSet set = ConcurrentOpenHashSet.newBuilder().build();
        class T {
            int value;

            T(int value) {
                this.value = value;
            }

            public int hashCode() {
                return Integer.hashCode(this.value);
            }

            public boolean equals(Object obj) {
                if (obj instanceof T) {
                    return this.value == ((T)obj).value;
                }
                return false;
            }
        }
        T t1 = new T(1);
        T t1B = new T(1);
        T t2 = new T(2);
        Assert.assertEquals((Object)t1, (Object)t1B);
        Assert.assertFalse((boolean)t1.equals(t2));
        Assert.assertFalse((boolean)t1B.equals(t2));
        set.add((Object)t1);
        Assert.assertTrue((boolean)set.contains((Object)t1));
        Assert.assertTrue((boolean)set.contains((Object)t1B));
        Assert.assertFalse((boolean)set.contains((Object)t2));
        Assert.assertTrue((boolean)set.remove((Object)t1B));
        Assert.assertFalse((boolean)set.contains((Object)t1));
        Assert.assertFalse((boolean)set.contains((Object)t1B));
    }
}

