/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.BookieResources;
import org.apache.bookkeeper.bookie.TestBookieImpl;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.ByteBufList;
import org.apache.bookkeeper.util.PortManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieImplTest
extends BookKeeperClusterTestCase {
    private static final Logger log = LoggerFactory.getLogger(BookieImplTest.class);
    private static final int bookiePort = PortManager.nextFreePort();

    public BookieImplTest() {
        super(0);
    }

    @Test
    public void testWriteLac() throws Exception {
        String metadataServiceUri = this.zkUtil.getMetadataServiceUri();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setMetadataServiceUri(metadataServiceUri);
        MetadataBookieDriver metadataDriver = BookieResources.createMetadataDriver((ServerConfiguration)conf, (StatsLogger)NullStatsLogger.INSTANCE);
        RegistrationManager rm = metadataDriver.createRegistrationManager();
        TestBookieImpl.Resources resources = new TestBookieImpl.ResourceBuilder(conf).withMetadataDriver(metadataDriver).withRegistrationManager(rm).build();
        TestBookieImpl b = new TestBookieImpl(resources);
        b.start();
        BookieImpl spyBookie = (BookieImpl)Mockito.spy((Object)((Object)b));
        long ledgerId = 10L;
        long lac = 23L;
        DigestManager digestManager = DigestManager.instantiate((long)10L, (byte[])"".getBytes(StandardCharsets.UTF_8), (DataFormats.LedgerMetadataFormat.DigestType)BookKeeper.DigestType.toProtoDigestType((BookKeeper.DigestType)BookKeeper.DigestType.CRC32), (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)this.baseClientConf.getUseV2WireProtocol());
        ByteBufList toSend = digestManager.computeDigestAndPackageForSendingLac(23L);
        ByteString body = UnsafeByteOperations.unsafeWrap((byte[])toSend.array(), (int)toSend.arrayOffset(), (int)toSend.readableBytes());
        ByteBuf lacToAdd = Unpooled.wrappedBuffer((ByteBuffer)body.asReadOnlyByteBuffer());
        byte[] masterKey = ByteString.copyFrom((byte[])"masterKey".getBytes()).toByteArray();
        ByteBuf explicitLACEntry = b.createExplicitLACEntry(10L, lacToAdd);
        lacToAdd.resetReaderIndex();
        ((BookieImpl)Mockito.doReturn((Object)explicitLACEntry).when((Object)spyBookie)).createExplicitLACEntry(ArgumentMatchers.eq((long)10L), (ByteBuf)ArgumentMatchers.eq((Object)lacToAdd));
        spyBookie.setExplicitLac(lacToAdd, null, null, masterKey);
        Assert.assertEquals((long)0L, (long)lacToAdd.refCnt());
        Assert.assertEquals((long)0L, (long)explicitLACEntry.refCnt());
        b.shutdown();
    }
}

