/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.util.Collections;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.Journal;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieJournalBypassTest
extends BookKeeperClusterTestCase {
    private static final Logger log = LoggerFactory.getLogger(BookieJournalBypassTest.class);
    private int bookieIdx = 0;

    public BookieJournalBypassTest() {
        super(2);
    }

    @Override
    protected BookKeeperClusterTestCase.ServerTester startBookie(ServerConfiguration conf) throws Exception {
        if (this.bookieIdx++ == 0) {
            conf.setJournalWriteData(false);
        }
        return super.startBookie(conf);
    }

    @Test
    public void testJournalBypass() throws Exception {
        ClientConfiguration conf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        BookieImpl bookieImpl = (BookieImpl)this.serverByIndex(0).getBookie();
        Journal journal0 = (Journal)bookieImpl.journals.get(0);
        LedgerStorage ls0 = this.serverByIndex(0).getBookie().getLedgerStorage();
        bookieImpl = (BookieImpl)this.serverByIndex(1).getBookie();
        Journal journal1 = (Journal)bookieImpl.journals.get(0);
        LedgerStorage ls1 = this.serverByIndex(1).getBookie().getLedgerStorage();
        ls0.flush();
        ls1.flush();
        long bk0OffsetBefore = journal0.getLastLogMark().getCurMark().getLogFileOffset();
        long bk1OffsetBefore = journal1.getLastLogMark().getCurMark().getLogFileOffset();
        this.writeEntries(conf);
        ls0.flush();
        ls1.flush();
        long bk0OffsetAfter = journal0.getLastLogMark().getCurMark().getLogFileOffset();
        long bk1OffsetAfter = journal1.getLastLogMark().getCurMark().getLogFileOffset();
        int flushDelta = 10240;
        int dataSize = 0xA00000;
        Assert.assertEquals((float)bk0OffsetBefore, (float)bk0OffsetAfter, (float)flushDelta);
        Assert.assertEquals((float)(bk1OffsetBefore + (long)dataSize), (float)bk1OffsetAfter, (float)flushDelta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEntries(ClientConfiguration conf) throws Exception {
        BookKeeper bkc = new BookKeeper(conf);
        try {
            WriteHandle wh = (WriteHandle)bkc.newCreateLedgerOp().withEnsembleSize(2).withWriteQuorumSize(2).withAckQuorumSize(2).withPassword("".getBytes()).execute().join();
            try {
                for (int i = 0; i < 10; ++i) {
                    wh.append(new byte[0x100000]);
                }
            }
            finally {
                if (Collections.singletonList(wh).get(0) != null) {
                    wh.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(bkc).get(0) != null) {
                bkc.close();
            }
        }
    }
}

