/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.BookieCriticalThread;
import org.apache.bookkeeper.bookie.BookieThread;
import org.junit.Assert;
import org.junit.Test;

public class BookieThreadTest {
    private CountDownLatch runningLatch = new CountDownLatch(1);

    @Test
    public void testUncaughtException() throws Exception {
        MyThread myThread = new MyThread("Test-Thread");
        myThread.start();
        Assert.assertTrue((String)"Uncaught exception is not properly handled.", (boolean)this.runningLatch.await(10000L, TimeUnit.MILLISECONDS));
        this.runningLatch = new CountDownLatch(1);
        MyCriticalThread myCriticalThread = new MyCriticalThread("Test-Critical-Thread");
        myCriticalThread.start();
        Assert.assertTrue((String)"Uncaught exception is not properly handled.", (boolean)this.runningLatch.await(10000L, TimeUnit.MILLISECONDS));
    }

    public class MyCriticalThread
    extends BookieCriticalThread {
        public MyCriticalThread(String threadName) {
            super(threadName);
        }

        public void run() {
            throw new Error();
        }

        protected void handleException(Thread t, Throwable e) {
            Assert.assertEquals((String)"Unknown thread!", (Object)((Object)this), (Object)t);
            BookieThreadTest.this.runningLatch.countDown();
        }
    }

    public class MyThread
    extends BookieThread {
        public MyThread(String threadName) {
            super(threadName);
        }

        public void run() {
            throw new Error();
        }

        protected void handleException(Thread t, Throwable e) {
            Assert.assertEquals((String)"Unknown thread!", (Object)((Object)this), (Object)t);
            BookieThreadTest.this.runningLatch.countDown();
        }
    }
}

