/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.SortedLedgerStorage;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeperClientTestsWithBookieErrors
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(BookKeeperClientTestsWithBookieErrors.class);
    private static final int NUM_BOOKIES = 3;
    private final long sleepTime;
    private final Consumer<ByteBuf> injectSleepWhileRead;
    private final Consumer<ByteBuf> injectCorruptData;
    private static List<Consumer<ByteBuf>> faultInjections = new ArrayList<Consumer<ByteBuf>>();
    private static HashMap<MockSortedLedgerStorage, Consumer<ByteBuf>> storageFaultInjectionsMap = new HashMap();
    private static final Object lock = new Object();

    public BookKeeperClientTestsWithBookieErrors() {
        super(3);
        this.baseConf.setLedgerStorageClass(MockSortedLedgerStorage.class.getName());
        this.injectCorruptData = byteBuf -> {
            ByteBuffer buf = byteBuf.nioBuffer();
            int lastByteIndex = buf.limit() - 1;
            buf.put(lastByteIndex, (byte)(buf.get(lastByteIndex) - 1));
        };
        this.sleepTime = (this.baseClientConf.getReadEntryTimeout() + 2) * 1000;
        this.injectSleepWhileRead = byteBuf -> {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
    }

    @Override
    @Before
    public void setUp() throws Exception {
        faultInjections.clear();
        storageFaultInjectionsMap.clear();
        super.setUp();
    }

    @Test(timeout=60000L)
    public void testBookkeeperAllDigestErrors() throws Exception {
        ClientConfiguration conf = (ClientConfiguration)new ClientConfiguration().setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper bkc = new BookKeeper(conf);
        byte[] passwd = "AAAAAAA".getBytes();
        faultInjections.add(this.injectCorruptData);
        faultInjections.add(this.injectCorruptData);
        faultInjections.add(this.injectCorruptData);
        LedgerHandle wlh = bkc.createLedger(3, 3, 2, BookKeeper.DigestType.CRC32, passwd);
        long id = wlh.getId();
        for (int i = 0; i < 10; ++i) {
            wlh.addEntry("foobarfoo".getBytes());
        }
        wlh.close();
        LedgerHandle rlh = bkc.openLedger(id, BookKeeper.DigestType.CRC32, passwd);
        try {
            rlh.readEntries(4L, 4L);
            Assert.fail((String)"It is expected to fail with BKDigestMatchException");
        }
        catch (BKException.BKDigestMatchException bKDigestMatchException) {
            // empty catch block
        }
        rlh.close();
        bkc.close();
    }

    @Test(timeout=60000L)
    public void testBKReadFirstTimeoutThenDigestError() throws Exception {
        ClientConfiguration conf = (ClientConfiguration)new ClientConfiguration().setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper bkc = new BookKeeper(conf);
        byte[] passwd = "AAAAAAA".getBytes();
        faultInjections.add(this.injectSleepWhileRead);
        faultInjections.add(this.injectSleepWhileRead);
        faultInjections.add(this.injectCorruptData);
        LedgerHandle wlh = bkc.createLedger(3, 3, 2, BookKeeper.DigestType.CRC32, passwd);
        long id = wlh.getId();
        for (int i = 0; i < 10; ++i) {
            wlh.addEntry("foobarfoo".getBytes());
        }
        wlh.close();
        LedgerHandle rlh = bkc.openLedger(id, BookKeeper.DigestType.CRC32, passwd);
        try {
            rlh.readEntries(4L, 4L);
            Assert.fail((String)"It is expected to fail with BKDigestMatchException");
        }
        catch (BKException.BKDigestMatchException bKDigestMatchException) {
            // empty catch block
        }
        rlh.close();
        bkc.close();
    }

    @Test(timeout=60000L)
    public void testBKReadFirstDigestErrorThenTimeout() throws Exception {
        ClientConfiguration conf = (ClientConfiguration)new ClientConfiguration().setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper bkc = new BookKeeper(conf);
        byte[] passwd = "AAAAAAA".getBytes();
        faultInjections.add(this.injectCorruptData);
        faultInjections.add(this.injectSleepWhileRead);
        faultInjections.add(this.injectSleepWhileRead);
        LedgerHandle wlh = bkc.createLedger(3, 3, 2, BookKeeper.DigestType.CRC32, passwd);
        long id = wlh.getId();
        for (int i = 0; i < 10; ++i) {
            wlh.addEntry("foobarfoo".getBytes());
        }
        wlh.close();
        LedgerHandle rlh = bkc.openLedger(id, BookKeeper.DigestType.CRC32, passwd);
        try {
            rlh.readEntries(4L, 4L);
            Assert.fail((String)"It is expected to fail with BKDigestMatchException");
        }
        catch (BKException.BKDigestMatchException bKDigestMatchException) {
            // empty catch block
        }
        rlh.close();
        bkc.close();
    }

    @Test(timeout=60000L)
    public void testBKReadFirstBookiesDownThenDigestError() throws Exception {
        ClientConfiguration conf = (ClientConfiguration)new ClientConfiguration().setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper bkc = new BookKeeper(conf);
        byte[] passwd = "AAAAAAA".getBytes();
        faultInjections.add(this.injectCorruptData);
        LedgerHandle wlh = bkc.createLedger(3, 3, 2, BookKeeper.DigestType.CRC32, passwd);
        long id = wlh.getId();
        wlh.addEntry("foobarfoo".getBytes());
        wlh.close();
        super.killBookie(0);
        super.killBookie(1);
        Thread.sleep(500L);
        LedgerHandle rlh = bkc.openLedger(id, BookKeeper.DigestType.CRC32, passwd);
        try {
            rlh.readEntries(0L, 0L);
            Assert.fail((String)"It is expected to fail with BKDigestMatchException");
        }
        catch (BKException.BKDigestMatchException bKDigestMatchException) {
            // empty catch block
        }
        rlh.close();
        bkc.close();
    }

    @Test(timeout=60000L)
    public void testBKReadAllTimeouts() throws Exception {
        ClientConfiguration conf = (ClientConfiguration)new ClientConfiguration().setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper bkc = new BookKeeper(conf);
        byte[] passwd = "AAAAAAA".getBytes();
        faultInjections.add(this.injectSleepWhileRead);
        faultInjections.add(this.injectSleepWhileRead);
        faultInjections.add(this.injectSleepWhileRead);
        LedgerHandle wlh = bkc.createLedger(3, 3, 2, BookKeeper.DigestType.CRC32, passwd);
        long id = wlh.getId();
        for (int i = 0; i < 10; ++i) {
            wlh.addEntry("foobarfoo".getBytes());
        }
        wlh.close();
        LedgerHandle rlh = bkc.openLedger(id, BookKeeper.DigestType.CRC32, passwd);
        try {
            rlh.readEntries(4L, 4L);
            Assert.fail((String)"It is expected to fail with BKTimeoutException");
        }
        catch (BKException.BKTimeoutException bKTimeoutException) {
            // empty catch block
        }
        rlh.close();
        bkc.close();
    }

    @Test(timeout=60000L)
    public void testBKReadTwoBookiesTimeout() throws Exception {
        ClientConfiguration conf = (ClientConfiguration)new ClientConfiguration().setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper bkc = new BookKeeper(conf);
        byte[] passwd = "AAAAAAA".getBytes();
        faultInjections.add(this.injectSleepWhileRead);
        faultInjections.add(this.injectSleepWhileRead);
        faultInjections.add(byteBuf -> {});
        LedgerHandle wlh = bkc.createLedger(3, 3, 2, BookKeeper.DigestType.CRC32, passwd);
        long id = wlh.getId();
        for (int i = 0; i < 10; ++i) {
            wlh.addEntry("foobarfoo".getBytes());
        }
        wlh.close();
        LedgerHandle rlh = bkc.openLedger(id, BookKeeper.DigestType.CRC32, passwd);
        LedgerEntry entry = (LedgerEntry)rlh.readEntries(4L, 4L).nextElement();
        Assert.assertTrue((String)"The read Entry should match with what have been written", (boolean)new String(entry.getEntry()).equals("foobarfoo"));
        rlh.close();
        bkc.close();
    }

    @Test(timeout=60000L)
    public void testBKReadTwoBookiesWithDigestError() throws Exception {
        ClientConfiguration conf = (ClientConfiguration)new ClientConfiguration().setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper bkc = new BookKeeper(conf);
        byte[] passwd = "AAAAAAA".getBytes();
        faultInjections.add(this.injectCorruptData);
        faultInjections.add(this.injectCorruptData);
        faultInjections.add(byteBuf -> {});
        LedgerHandle wlh = bkc.createLedger(3, 3, 2, BookKeeper.DigestType.CRC32, passwd);
        long id = wlh.getId();
        for (int i = 0; i < 10; ++i) {
            wlh.addEntry("foobarfoo".getBytes());
        }
        wlh.close();
        LedgerHandle rlh = bkc.openLedger(id, BookKeeper.DigestType.CRC32, passwd);
        LedgerEntry entry = (LedgerEntry)rlh.readEntries(4L, 4L).nextElement();
        Assert.assertTrue((String)"The read Entry should match with what have been written", (boolean)new String(entry.getEntry()).equals("foobarfoo"));
        rlh.close();
        bkc.close();
    }

    static class MockSortedLedgerStorage
    extends SortedLedgerStorage {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBuf getEntry(long ledgerId, long entryId) throws IOException, BookieException {
            Consumer faultInjection;
            Object object = lock;
            synchronized (object) {
                faultInjection = (Consumer)storageFaultInjectionsMap.get((Object)this);
                if (faultInjection == null) {
                    int readLedgerStorageIndex = storageFaultInjectionsMap.size();
                    faultInjection = (Consumer)faultInjections.get(readLedgerStorageIndex);
                    storageFaultInjectionsMap.put(this, faultInjection);
                }
            }
            ByteBuf byteBuf = super.getEntry(ledgerId, entryId);
            faultInjection.accept(byteBuf);
            return byteBuf;
        }
    }
}

