/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.ClientContext;
import org.apache.bookkeeper.client.ClientUtil;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.LedgerRecovery2Test;
import org.apache.bookkeeper.client.MockClientContext;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.versioning.Versioned;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerClose2Test {
    private static final Logger log = LoggerFactory.getLogger(LedgerRecovery2Test.class);
    private static final BookieId b1 = new BookieSocketAddress("b1", 3181).toBookieId();
    private static final BookieId b2 = new BookieSocketAddress("b2", 3181).toBookieId();
    private static final BookieId b3 = new BookieSocketAddress("b3", 3181).toBookieId();
    private static final BookieId b4 = new BookieSocketAddress("b4", 3181).toBookieId();
    private static final BookieId b5 = new BookieSocketAddress("b5", 3181).toBookieId();

    @Test
    public void testTryAddAfterCloseHasBeenCalled() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        for (int i = 0; i < 1000; ++i) {
            Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, (long)i, LedgerMetadataBuilder.create().newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
            LedgerHandle lh = new LedgerHandle((ClientContext)clientCtx, (long)i, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
            CompletableFuture closeFuture = lh.closeAsync();
            try {
                long eid = lh.append("entry".getBytes());
                closeFuture.get();
                Assert.assertTrue((boolean)lh.getLedgerMetadata().isClosed());
                Assert.assertEquals((long)lh.getLedgerMetadata().getLastEntryId(), (long)eid);
                continue;
            }
            catch (BKException.BKLedgerClosedException bke) {
                closeFuture.get();
                Assert.assertTrue((boolean)lh.getLedgerMetadata().isClosed());
                Assert.assertEquals((long)lh.getLedgerMetadata().getLastEntryId(), (long)-1L);
            }
        }
    }

    @Test
    public void testMetadataChangedDuringClose() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, 10L, LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(2).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
        LedgerHandle lh = new LedgerHandle((ClientContext)clientCtx, 10L, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        lh.append("entry1".getBytes());
        clientCtx.getMockRegistrationClient().addBookies(b4).get();
        clientCtx.getMockBookieClient().errorBookies(b3);
        lh.append("entry2".getBytes());
        CompletableFuture closeInProgress = new CompletableFuture();
        CompletableFuture<Object> blockClose = new CompletableFuture<Object>();
        clientCtx.getMockLedgerManager().setPreWriteHook((ledgerId, metadata) -> {
            if (metadata.isClosed()) {
                closeInProgress.complete(null);
                return blockClose;
            }
            return FutureUtils.value(null);
        });
        CompletableFuture closeFuture = lh.closeAsync();
        closeInProgress.get();
        ClientUtil.transformMetadata(clientCtx, 10L, metadata -> LedgerMetadataBuilder.from((LedgerMetadata)metadata).replaceEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b4, b2, b5})).build());
        blockClose.complete(null);
        closeFuture.get();
        Assert.assertTrue((boolean)lh.getLedgerMetadata().isClosed());
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)2L);
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieId[]{b4, b2, b5}));
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(1L), (Object)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b4}));
        Assert.assertEquals((long)lh.getLedgerMetadata().getLastEntryId(), (long)1L);
    }

    @Test
    public void testMetadataCloseWithCorrectLengthDuringClose() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, 10L, LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(2).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
        LedgerHandle lh = new LedgerHandle((ClientContext)clientCtx, 10L, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        long lac = lh.append("entry1".getBytes());
        long length = lh.getLength();
        CompletableFuture closeInProgress = new CompletableFuture();
        CompletableFuture<Object> blockClose = new CompletableFuture<Object>();
        clientCtx.getMockLedgerManager().setPreWriteHook((ledgerId, metadata) -> {
            if (!closeInProgress.isDone() && metadata.isClosed()) {
                closeInProgress.complete(null);
                return blockClose;
            }
            return FutureUtils.value(null);
        });
        CompletableFuture closeFuture = lh.closeAsync();
        closeInProgress.get();
        ClientUtil.transformMetadata(clientCtx, 10L, metadata -> LedgerMetadataBuilder.from((LedgerMetadata)metadata).withClosedState().withLastEntryId(lac).withLength(length).build());
        blockClose.complete(null);
        closeFuture.get();
        Assert.assertTrue((boolean)lh.getLedgerMetadata().isClosed());
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)1L);
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        Assert.assertEquals((long)lh.getLedgerMetadata().getLastEntryId(), (long)lac);
        Assert.assertEquals((long)lh.getLedgerMetadata().getLength(), (long)length);
    }

    @Test
    public void testMetadataCloseWithDifferentLengthDuringClose() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, 10L, LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(2).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
        LedgerHandle lh = new LedgerHandle((ClientContext)clientCtx, 10L, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        long lac = lh.append("entry1".getBytes());
        long length = lh.getLength();
        CompletableFuture closeInProgress = new CompletableFuture();
        CompletableFuture<Object> blockClose = new CompletableFuture<Object>();
        clientCtx.getMockLedgerManager().setPreWriteHook((ledgerId, metadata) -> {
            if (!closeInProgress.isDone() && metadata.isClosed()) {
                closeInProgress.complete(null);
                return blockClose;
            }
            return FutureUtils.value(null);
        });
        CompletableFuture closeFuture = lh.closeAsync();
        closeInProgress.get();
        ClientUtil.transformMetadata(clientCtx, 10L, metadata -> LedgerMetadataBuilder.from((LedgerMetadata)metadata).withClosedState().withLastEntryId(lac + 1L).withLength(length + 100L).build());
        blockClose.complete(null);
        try {
            closeFuture.get();
            Assert.fail((String)"Close should fail. Ledger has been closed in a state we don't know how to untangle");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals(ee.getCause().getClass(), BKException.BKMetadataVersionException.class);
        }
    }

    @Test
    public void testMetadataCloseMarkedInRecoveryWhileClosing() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, 10L, LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(2).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
        LedgerHandle lh = new LedgerHandle((ClientContext)clientCtx, 10L, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        long lac = lh.append("entry1".getBytes());
        long length = lh.getLength();
        CompletableFuture closeInProgress = new CompletableFuture();
        CompletableFuture<Object> blockClose = new CompletableFuture<Object>();
        clientCtx.getMockLedgerManager().setPreWriteHook((ledgerId, metadata) -> {
            if (metadata.isClosed()) {
                closeInProgress.complete(null);
                return blockClose;
            }
            return FutureUtils.value(null);
        });
        CompletableFuture closeFuture = lh.closeAsync();
        closeInProgress.get();
        ClientUtil.transformMetadata(clientCtx, 10L, metadata -> LedgerMetadataBuilder.from((LedgerMetadata)metadata).withInRecoveryState().build());
        blockClose.complete(null);
        closeFuture.get();
        Assert.assertTrue((boolean)lh.getLedgerMetadata().isClosed());
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)1L);
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        Assert.assertEquals((long)lh.getLedgerMetadata().getLastEntryId(), (long)lac);
        Assert.assertEquals((long)lh.getLedgerMetadata().getLength(), (long)length);
    }

    @Test
    public void testCloseWhileAddInProgress() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, 10L, LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(2).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
        CompletableFuture writesHittingBookies = new CompletableFuture();
        clientCtx.getMockBookieClient().setPreWriteHook((bookie, ledgerId, entryId) -> {
            writesHittingBookies.complete(null);
            return new CompletableFuture();
        });
        LedgerHandle lh = new LedgerHandle((ClientContext)clientCtx, 10L, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        CompletableFuture future = lh.appendAsync("entry1".getBytes());
        writesHittingBookies.get();
        lh.close();
        try {
            future.get();
            Assert.fail((String)"That write shouldn't have succeeded");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals(ee.getCause().getClass(), BKException.BKLedgerClosedException.class);
        }
        Assert.assertTrue((boolean)lh.getLedgerMetadata().isClosed());
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)1L);
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3}));
        Assert.assertEquals((long)lh.getLedgerMetadata().getLastEntryId(), (long)-1L);
        Assert.assertEquals((long)lh.getLedgerMetadata().getLength(), (long)0L);
    }

    @Test
    public void testDoubleCloseOnHandle() throws Exception {
        long ledgerId = 123L;
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = ClientUtil.setupLedger(clientCtx, ledgerId, LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{b1, b2, b3})));
        CompletableFuture metadataPromise = new CompletableFuture();
        CompletableFuture clientPromise = new CompletableFuture();
        LedgerHandle writer = new LedgerHandle((ClientContext)clientCtx, ledgerId, md, BookKeeper.DigestType.CRC32C, ClientUtil.PASSWD, WriteFlag.NONE);
        long eid1 = writer.append("entry1".getBytes());
        log.info("block writes from completing on bookies and metadata");
        clientCtx.getMockBookieClient().setPostWriteHook((bookie, lid, eid) -> clientPromise);
        clientCtx.getMockLedgerManager().setPreWriteHook((lid, metadata) -> metadataPromise);
        log.info("try to add another entry, it will block");
        writer.appendAsync("entry2".getBytes());
        log.info("attempt one close, should block forever");
        CompletableFuture firstClose = writer.closeAsync();
        log.info("attempt second close, should not finish before first one");
        CompletableFuture secondClose = writer.closeAsync();
        Thread.sleep(500L);
        Assert.assertFalse((boolean)firstClose.isDone());
        Assert.assertFalse((boolean)secondClose.isDone());
    }
}

