/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client.api;

import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.api.BookKeeper;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.TestUtils;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplicitLACWithWriteHandleAPITest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ExplicitLACWithWriteHandleAPITest.class);

    public ExplicitLACWithWriteHandleAPITest() {
        super(1);
    }

    @Test
    public void testUseExplicitLAC() throws Exception {
        ClientConfiguration conf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        conf.setExplictLacInterval(1000);
        try (BookKeeper bkc = BookKeeper.newBuilder((ClientConfiguration)conf).build();
             WriteHandle writer = (WriteHandle)bkc.newCreateLedgerOp().withAckQuorumSize(1).withEnsembleSize(1).withPassword(new byte[0]).withWriteQuorumSize(1).execute().get();){
            writer.append("foo".getBytes("utf-8"));
            writer.append("foo".getBytes("utf-8"));
            writer.append("foo".getBytes("utf-8"));
            long expectedLastAddConfirmed = writer.append("foo".getBytes("utf-8"));
            try (ReadHandle r = (ReadHandle)bkc.newOpenLedgerOp().withRecovery(false).withPassword(new byte[0]).withLedgerId(writer.getId()).execute().get();){
                TestUtils.assertEventuallyTrue("ExplicitLAC did not ork", () -> {
                    try {
                        long value = r.readLastAddConfirmed();
                        LOG.info("current value " + value + " vs " + expectedLastAddConfirmed);
                        return value == expectedLastAddConfirmed;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }, 30L, TimeUnit.SECONDS);
            }
        }
    }
}

