/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.discover;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;

public class MockRegistrationManager
implements RegistrationManager {
    private final ConcurrentHashMap<BookieId, Versioned<byte[]>> cookies = new ConcurrentHashMap();

    public void close() {
    }

    public String getClusterInstanceId() throws BookieException {
        return "mock-cluster";
    }

    public void registerBookie(BookieId bookieId, boolean readOnly, BookieServiceInfo serviceInfo) throws BookieException {
        throw new UnsupportedOperationException("Not implemented in mock. Implement if you need it");
    }

    public void unregisterBookie(BookieId bookieId, boolean readOnly) throws BookieException {
        throw new UnsupportedOperationException("Not implemented in mock. Implement if you need it");
    }

    public boolean isBookieRegistered(BookieId bookieId) throws BookieException {
        throw new UnsupportedOperationException("Not implemented in mock. Implement if you need it");
    }

    public void writeCookie(BookieId bookieId, Versioned<byte[]> cookieData) throws BookieException {
        block2: {
            try {
                this.cookies.compute(bookieId, (bookieId1, current) -> {
                    if (cookieData.getVersion() == Version.NEW) {
                        if (current == null) {
                            return new Versioned(cookieData.getValue(), (Version)new LongVersion(1L));
                        }
                        throw new RuntimeException((Throwable)new BookieException.CookieExistException(bookieId.getId()));
                    }
                    if (current != null && cookieData.getVersion().equals(current.getVersion())) {
                        LongVersion oldVersion = (LongVersion)current.getVersion();
                        LongVersion newVersion = new LongVersion(oldVersion.getLongVersion() + 1L);
                        return new Versioned(cookieData.getValue(), (Version)newVersion);
                    }
                    throw new RuntimeException((Throwable)new BookieException.CookieExistException(bookieId.getId()));
                });
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof BookieException)) break block2;
                throw (BookieException)e.getCause();
            }
        }
    }

    public Versioned<byte[]> readCookie(BookieId bookieId) throws BookieException {
        Versioned<byte[]> cookie = this.cookies.get(bookieId);
        if (cookie == null) {
            throw new BookieException.CookieNotFoundException(bookieId.toString());
        }
        return cookie;
    }

    public void removeCookie(BookieId bookieId, Version version) throws BookieException {
        block2: {
            try {
                this.cookies.compute(bookieId, (bookieId1, current) -> {
                    if (current == null) {
                        throw new RuntimeException((Throwable)new BookieException.CookieNotFoundException(bookieId.toString()));
                    }
                    if (current.getVersion().equals(version)) {
                        return null;
                    }
                    throw new RuntimeException((Throwable)new BookieException.MetadataStoreException("Bad version"));
                });
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof BookieException)) break block2;
                throw (BookieException)e.getCause();
            }
        }
    }

    public boolean prepareFormat() throws Exception {
        throw new UnsupportedOperationException("Not implemented in mock. Implement if you need it");
    }

    public boolean initNewCluster() throws Exception {
        throw new UnsupportedOperationException("Not implemented in mock. Implement if you need it");
    }

    public boolean format() throws Exception {
        throw new UnsupportedOperationException("Not implemented in mock. Implement if you need it");
    }

    public boolean nukeExistingCluster() throws Exception {
        throw new UnsupportedOperationException("Not implemented in mock. Implement if you need it");
    }

    public void addRegistrationListener(RegistrationManager.RegistrationListener listener) {
        throw new UnsupportedOperationException("Not implemented in mock. Implement if you need it");
    }
}

