/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.TreeMap;

public class MockLedgerData {
    final long ledgerId;
    boolean isFenced;
    private TreeMap<Long, ByteBuf> entries = new TreeMap();

    MockLedgerData(long ledgerId) {
        this.ledgerId = ledgerId;
    }

    boolean isFenced() {
        return this.isFenced;
    }

    void fence() {
        this.isFenced = true;
    }

    void addEntry(long entryId, ByteBuf entry) {
        this.entries.put(entryId, entry);
    }

    ByteBuf getEntry(long entryId) {
        if (entryId == -1L) {
            Map.Entry<Long, ByteBuf> lastEntry = this.entries.lastEntry();
            if (lastEntry != null) {
                return lastEntry.getValue();
            }
            return null;
        }
        return this.entries.get(entryId);
    }
}

