/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.channel.Channel;
import io.netty.channel.local.LocalChannel;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;

public class NetworkLessBookieTest
extends BookKeeperClusterTestCase {
    public NetworkLessBookieTest() {
        super(1);
        this.baseConf.setDisableServerSocketBind(true);
        this.baseConf.setEnableLocalTransport(true);
    }

    @Test
    public void testUseLocalBookie() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        conf.setZkTimeout(20000);
        BookKeeper bkc = new BookKeeper(conf);
        Object object = null;
        try (LedgerHandle h2 = bkc.createLedger(1, 1, BookKeeper.DigestType.CRC32, "testPasswd".getBytes());){
            h2.addEntry("test".getBytes());
        }
        catch (Throwable h2) {
            object = h2;
            throw h2;
        }
        finally {
            if (bkc != null) {
                if (object != null) {
                    try {
                        bkc.close();
                    }
                    catch (Throwable h2) {
                        ((Throwable)object).addSuppressed(h2);
                    }
                } else {
                    bkc.close();
                }
            }
        }
        for (int i = 0; i < this.bookieCount(); ++i) {
            for (Channel channel : this.serverByIndex((int)i).nettyServer.allChannels) {
                if (channel instanceof LocalChannel) continue;
                Assert.fail();
            }
        }
    }
}

