/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import java.io.IOException;
import java.io.Writer;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.server.http.service.MetricsService;
import org.apache.bookkeeper.stats.StatsProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class MetricsServiceTest {
    private StatsProvider mockStatsProvider;
    private MetricsService service;

    @Before
    public void setup() {
        this.mockStatsProvider = (StatsProvider)Mockito.mock(StatsProvider.class);
        this.service = new MetricsService(new ServerConfiguration(), this.mockStatsProvider);
    }

    @Test
    public void testForbiddenMethods() throws Exception {
        HttpServiceRequest request = new HttpServiceRequest().setMethod(HttpServer.Method.PUT);
        HttpServiceResponse response = this.service.handle(request);
        Assert.assertEquals((long)HttpServer.StatusCode.FORBIDDEN.getValue(), (long)response.getStatusCode());
        Assert.assertEquals((Object)"PUT is forbidden. Should be GET method", (Object)response.getBody());
    }

    @Test
    public void testNullStatsProvider() throws Exception {
        this.service = new MetricsService(new ServerConfiguration(), null);
        HttpServiceRequest request = new HttpServiceRequest().setMethod(HttpServer.Method.GET);
        HttpServiceResponse response = this.service.handle(request);
        Assert.assertEquals((long)HttpServer.StatusCode.INTERNAL_ERROR.getValue(), (long)response.getStatusCode());
        Assert.assertEquals((Object)"Stats provider is not enabled. Please enable it by set statsProviderClass on bookie configuration", (Object)response.getBody());
    }

    @Test
    public void testWriteMetrics() throws Exception {
        String content = "test-metrics";
        ((StatsProvider)Mockito.doAnswer(invocationOnMock -> {
            Writer writer = (Writer)invocationOnMock.getArgument(0);
            writer.write(content);
            return null;
        }).when((Object)this.mockStatsProvider)).writeAllMetrics((Writer)ArgumentMatchers.any(Writer.class));
        HttpServiceRequest request = new HttpServiceRequest().setMethod(HttpServer.Method.GET);
        HttpServiceResponse response = this.service.handle(request);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response.getStatusCode());
        Assert.assertEquals((Object)content, (Object)response.getBody());
    }

    @Test
    public void testWriteMetricsException() throws Exception {
        ((StatsProvider)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("write-metrics-exception")}).when((Object)this.mockStatsProvider)).writeAllMetrics((Writer)ArgumentMatchers.any(Writer.class));
        HttpServiceRequest request = new HttpServiceRequest().setMethod(HttpServer.Method.GET);
        HttpServiceResponse response = this.service.handle(request);
        Assert.assertEquals((long)HttpServer.StatusCode.INTERNAL_ERROR.getValue(), (long)response.getStatusCode());
        Assert.assertEquals((Object)"Exceptions are thrown when exporting metrics : write-metrics-exception", (Object)response.getBody());
    }

    @Test
    public void testWriteMetricsUnimplemented() throws Exception {
        this.mockStatsProvider = (StatsProvider)Mockito.mock(StatsProvider.class, (Answer)Mockito.CALLS_REAL_METHODS);
        this.service = new MetricsService(new ServerConfiguration(), this.mockStatsProvider);
        HttpServiceRequest request = new HttpServiceRequest().setMethod(HttpServer.Method.GET);
        HttpServiceResponse response = this.service.handle(request);
        Assert.assertEquals((long)HttpServer.StatusCode.INTERNAL_ERROR.getValue(), (long)response.getStatusCode());
        Assert.assertEquals((Object)"Currently stats provider doesn't support exporting metrics in http service", (Object)response.getBody());
    }
}

