/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.apache.bookkeeper.util.IteratorUtility;
import org.junit.Assert;
import org.junit.Test;

public class IteratorUtilityTest {
    @Test
    public void testWithPrimitiveItrMerge() {
        long[][] arrays = new long[][]{{0L, 1L, 2L}, {0L, 1L}, {1L, 2L}, {1L, 2L, 3L, 5L, 6L, 7L, 8L}, {1L, 2L, 3L, 5L, 6L, 7L, 8L}, {0L, 1L, 5L}, {3L}, {1L, 2L, 4L, 5L, 7L, 8L}, new long[0], new long[0], {0L}, {1L, 2L, 3L, 5L, 6L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 100L, 1000L, 1001L, 10000L, 20000L, 20001L}, {201L, 202L, 203L, 205L, 206L, 2011L, 2012L, 2013L, 2014L, 2015L, 2016L, 2017L, 20100L, 201000L, 201001L, 2010000L, 2020000L, 2020001L}};
        for (int i = 0; i < arrays.length; ++i) {
            for (int j = i + 1; j < arrays.length; ++j) {
                int k2;
                long[] tempArray1 = arrays[i];
                long[] tempArray2 = arrays[j];
                HashSet<Long> unionSet = new HashSet<Long>();
                for (k2 = 0; k2 < tempArray1.length; ++k2) {
                    unionSet.add(tempArray1[k2]);
                }
                for (k2 = 0; k2 < tempArray2.length; ++k2) {
                    unionSet.add(tempArray2[k2]);
                }
                PrimitiveIterator.OfLong primitiveIterator1 = Arrays.stream(tempArray1).iterator();
                PrimitiveIterator.OfLong primitiveIterator2 = Arrays.stream(tempArray2).iterator();
                PrimitiveIterator.OfLong mergedItr = IteratorUtility.mergePrimitiveLongIterator((PrimitiveIterator.OfLong)primitiveIterator1, (PrimitiveIterator.OfLong)primitiveIterator2);
                ArrayList mergedArrayList = new ArrayList();
                Consumer<Long> addMethod = mergedArrayList::add;
                mergedItr.forEachRemaining((Consumer<? super Long>)addMethod);
                int mergedListSize = mergedArrayList.size();
                Assert.assertEquals((String)"Size of the mergedArrayList", (long)unionSet.size(), (long)mergedArrayList.size());
                Assert.assertTrue((String)"mergedArrayList should contain all elements in unionSet", (boolean)mergedArrayList.containsAll(unionSet));
                Assert.assertTrue((String)"Merged Iterator should be sorted", (boolean)IntStream.range(0, mergedListSize - 1).allMatch(k -> (Long)mergedArrayList.get(k) <= (Long)mergedArrayList.get(k + 1)));
                Assert.assertTrue((String)"All elements of tempArray1 should be in mergedArrayList", (boolean)IntStream.range(0, tempArray1.length).allMatch(k -> mergedArrayList.contains(tempArray1[k])));
                Assert.assertTrue((String)"All elements of tempArray2 should be in mergedArrayList", (boolean)IntStream.range(0, tempArray2.length).allMatch(k -> mergedArrayList.contains(tempArray2[k])));
            }
        }
    }

    @Test
    public void testWithItrMerge() {
        long[][] arrays = new long[][]{{0L, 1L, 2L}, {0L, 1L}, {1L, 2L}, {1L, 2L, 3L, 5L, 6L, 7L, 8L}, {1L, 2L, 3L, 5L, 6L, 7L, 8L}, {0L, 1L, 5L}, {3L}, {1L, 2L, 4L, 5L, 7L, 8L}, new long[0], new long[0], {0L}, {1L, 2L, 3L, 5L, 6L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 100L, 1000L, 1001L, 10000L, 20000L, 20001L}, {201L, 202L, 203L, 205L, 206L, 2011L, 2012L, 2013L, 2014L, 2015L, 2016L, 2017L, 20100L, 201000L, 201001L, 2010000L, 2020000L, 2020001L}};
        for (int i = 0; i < arrays.length; ++i) {
            for (int j = i + 1; j < arrays.length; ++j) {
                long[] tempArray1 = arrays[i];
                ArrayList tempArrayList1 = new ArrayList();
                IntStream.range(0, tempArray1.length).forEach(k -> tempArrayList1.add(tempArray1[k]));
                long[] tempArray2 = arrays[j];
                ArrayList tempArrayList2 = new ArrayList();
                IntStream.range(0, tempArray2.length).forEach(k -> tempArrayList2.add(tempArray2[k]));
                HashSet unionSet = new HashSet();
                unionSet.addAll(tempArrayList1);
                unionSet.addAll(tempArrayList2);
                Iterator itr1 = tempArrayList1.iterator();
                Iterator itr2 = tempArrayList2.iterator();
                PrimitiveIterator.OfLong mergedItr = IteratorUtility.mergeIteratorsForPrimitiveLongIterator(itr1, itr2, Long::compare, l -> l);
                ArrayList mergedArrayList = new ArrayList();
                Consumer<Long> addMethod = mergedArrayList::add;
                mergedItr.forEachRemaining(addMethod);
                int mergedListSize = mergedArrayList.size();
                Assert.assertEquals((String)"Size of the mergedArrayList", (long)unionSet.size(), (long)mergedArrayList.size());
                Assert.assertTrue((String)"mergedArrayList should contain all elements in unionSet", (boolean)mergedArrayList.containsAll(unionSet));
                Assert.assertTrue((String)"Merged Iterator should be sorted", (boolean)IntStream.range(0, mergedListSize - 1).allMatch(k -> (Long)mergedArrayList.get(k) <= (Long)mergedArrayList.get(k + 1)));
                Assert.assertTrue((String)"All elements of tempArray1 should be in mergedArrayList", (boolean)IntStream.range(0, tempArray1.length).allMatch(k -> mergedArrayList.contains(tempArray1[k])));
                Assert.assertTrue((String)"All elements of tempArray2 should be in mergedArrayList", (boolean)IntStream.range(0, tempArray2.length).allMatch(k -> mergedArrayList.contains(tempArray2[k])));
            }
        }
    }
}

