/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.Journal;
import org.apache.bookkeeper.bookie.LedgerDescriptor;
import org.apache.bookkeeper.bookie.TestBookieImpl;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointOnNewLedgersTest {
    private static final Logger log = LoggerFactory.getLogger(CheckpointOnNewLedgersTest.class);
    @Rule
    public final TemporaryFolder testDir = new TemporaryFolder();
    private ServerConfiguration conf;
    private BookieImpl bookie;
    private CountDownLatch getLedgerDescCalledLatch;
    private CountDownLatch getLedgerDescWaitLatch;

    @Before
    public void setup() throws Exception {
        File bkDir = this.testDir.newFolder("dbLedgerStorageCheckpointTest");
        File curDir = BookieImpl.getCurrentDirectory((File)bkDir);
        BookieImpl.checkDirectoryStructure((File)curDir);
        int gcWaitTime = 1000;
        this.conf = TestBKConfiguration.newServerConfiguration();
        this.conf.setGcWaitTime((long)gcWaitTime);
        this.conf.setLedgerStorageClass(InterleavedLedgerStorage.class.getName());
        this.conf.setJournalDirsName(new String[]{bkDir.toString()});
        this.conf.setLedgerDirNames(new String[]{bkDir.toString()});
        this.conf.setEntryLogSizeLimit(10240L);
        this.bookie = (BookieImpl)Mockito.spy((Object)((Object)new TestBookieImpl(this.conf)));
        this.bookie.start();
        this.getLedgerDescCalledLatch = new CountDownLatch(1);
        this.getLedgerDescWaitLatch = new CountDownLatch(1);
        ((BookieImpl)Mockito.doAnswer(invocationOnMock -> {
            ByteBuf entry = (ByteBuf)invocationOnMock.getArgument(0);
            long ledgerId = entry.getLong(entry.readerIndex());
            LedgerDescriptor ld = (LedgerDescriptor)invocationOnMock.callRealMethod();
            if (ledgerId % 2L == 1L) {
                this.getLedgerDescCalledLatch.countDown();
                this.getLedgerDescWaitLatch.await();
            }
            return ld;
        }).when((Object)this.bookie)).getLedgerForEntry((ByteBuf)ArgumentMatchers.any(ByteBuf.class), (byte[])ArgumentMatchers.any(byte[].class));
    }

    @After
    public void teardown() throws Exception {
        if (null != this.bookie) {
            this.bookie.shutdown();
        }
    }

    private static ByteBuf createByteBuf(long ledgerId, long entryId, int entrySize) {
        byte[] data = new byte[entrySize];
        ThreadLocalRandom.current().nextBytes(data);
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])data);
        buffer.writerIndex(0);
        buffer.writeLong(ledgerId);
        buffer.writeLong(entryId);
        buffer.writeLong(entryId - 1L);
        buffer.writerIndex(entrySize);
        return buffer;
    }

    @Test
    public void testCheckpoint() throws Exception {
        int entrySize = 1024;
        long l1 = 1L;
        long l2 = 2L;
        CountDownLatch writeL1Latch = new CountDownLatch(1);
        Thread t1 = new Thread(() -> {
            ByteBuf entry = CheckpointOnNewLedgersTest.createByteBuf(l1, 0L, entrySize);
            try {
                this.bookie.addEntry(entry, false, (rc, ledgerId, entryId, addr, ctx) -> writeL1Latch.countDown(), null, new byte[0]);
            }
            catch (Exception e) {
                log.info("Failed to write entry to l1", (Throwable)e);
            }
        }, "ledger-1-writer");
        t1.start();
        this.getLedgerDescCalledLatch.await();
        Journal.LastLogMark logMark = ((Journal)this.bookie.journals.get(0)).getLastLogMark().markLog();
        int numEntries = 10;
        CountDownLatch writeL2Latch = new CountDownLatch(numEntries);
        for (int i = 0; i < numEntries; ++i) {
            ByteBuf entry = CheckpointOnNewLedgersTest.createByteBuf(l2, i, entrySize);
            this.bookie.addEntry(entry, false, (rc, ledgerId, entryId, addr, ctx) -> writeL2Latch.countDown(), null, new byte[0]);
        }
        writeL2Latch.await();
        this.bookie.syncThread.getExecutor().submit(() -> {}).get();
        log.info("Wait until checkpoint is completed");
        Journal.LastLogMark newLogMark = ((Journal)this.bookie.journals.get(0)).getLastLogMark().markLog();
        Assert.assertTrue((newLogMark.getCurMark().compare(logMark.getCurMark()) > 0 ? 1 : 0) != 0);
        this.getLedgerDescWaitLatch.countDown();
        writeL1Latch.await();
        t1.join();
        TestBookieImpl newBookie = new TestBookieImpl(this.conf);
        newBookie.start();
        for (int i = 0; i < numEntries; ++i) {
            ByteBuf entry = newBookie.readEntry(l2, i);
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((long)l2, (long)entry.readLong());
            Assert.assertEquals((long)i, (long)entry.readLong());
            ReferenceCountUtil.release((Object)entry);
        }
        ByteBuf entry = newBookie.readEntry(l1, 0L);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)l1, (long)entry.readLong());
        Assert.assertEquals((long)0L, (long)entry.readLong());
        ReferenceCountUtil.release((Object)entry);
        newBookie.shutdown();
    }
}

