/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.Cookie;
import org.apache.bookkeeper.bookie.LegacyCookieValidation;
import org.apache.bookkeeper.bookie.UpgradeTest;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.PortManager;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieTest
extends BookKeeperClusterTestCase {
    private static final Logger log = LoggerFactory.getLogger(CookieTest.class);
    final int bookiePort = PortManager.nextFreePort();
    MetadataBookieDriver metadataBookieDriver;
    RegistrationManager rm;

    public CookieTest() {
        super(0);
    }

    private String newDirectory() throws Exception {
        return this.newDirectory(true);
    }

    private String newDirectory(boolean createCurDir) throws Exception {
        File d = this.tmpDirs.createNew("cookie", "tmpdir");
        if (createCurDir) {
            new File(d, "current").mkdirs();
        }
        return d.getPath();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.baseConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.metadataBookieDriver = MetadataDrivers.getBookieDriver((URI)URI.create(this.baseConf.getMetadataServiceUri()));
        this.metadataBookieDriver.initialize(this.baseConf, (StatsLogger)NullStatsLogger.INSTANCE);
        this.rm = this.metadataBookieDriver.createRegistrationManager();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.rm != null) {
            this.rm.close();
        }
        if (this.metadataBookieDriver != null) {
            this.metadataBookieDriver.close();
        }
    }

    private static List<File> currentDirectoryList(File[] dirs) {
        return Arrays.asList(BookieImpl.getCurrentDirectories((File[])dirs));
    }

    private void validateConfig(ServerConfiguration conf) throws Exception {
        File cur;
        ArrayList<File> dirs = new ArrayList<File>();
        for (File f : conf.getJournalDirs()) {
            cur = BookieImpl.getCurrentDirectory((File)f);
            dirs.add(cur);
            BookieImpl.checkDirectoryStructure((File)cur);
        }
        for (File f : conf.getLedgerDirs()) {
            cur = BookieImpl.getCurrentDirectory((File)f);
            dirs.add(cur);
            BookieImpl.checkDirectoryStructure((File)cur);
        }
        LegacyCookieValidation cookieValidation = new LegacyCookieValidation(conf, this.rm);
        cookieValidation.checkCookies(dirs);
    }

    @Test
    public void testCleanStart() throws Exception {
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(this.newDirectory(true)).setLedgerDirNames(new String[]{this.newDirectory(true)}).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.validateConfig(conf);
    }

    @Test
    public void testBadJournalCookie() throws Exception {
        ServerConfiguration conf1 = TestBKConfiguration.newServerConfiguration().setJournalDirName(this.newDirectory()).setLedgerDirNames(new String[]{this.newDirectory()}).setBookiePort(this.bookiePort);
        Cookie.Builder cookieBuilder = Cookie.generateCookie((ServerConfiguration)conf1);
        Cookie c = cookieBuilder.build();
        c.writeToRegistrationManager(this.rm, conf1, Version.NEW);
        String journalDir = this.newDirectory();
        String ledgerDir = this.newDirectory();
        ServerConfiguration conf2 = TestBKConfiguration.newServerConfiguration();
        conf2.setJournalDirName(journalDir).setLedgerDirNames(new String[]{ledgerDir}).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        Cookie.Builder cookieBuilder2 = Cookie.generateCookie((ServerConfiguration)conf2);
        Cookie c2 = cookieBuilder2.build();
        c2.writeToDirectory(new File(journalDir, "current"));
        c2.writeToDirectory(new File(ledgerDir, "current"));
        try {
            this.validateConfig(conf2);
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testDirectoryMissing() throws Exception {
        String[] ledgerDirs = new String[]{this.newDirectory(), this.newDirectory(), this.newDirectory()};
        String journalDir = this.newDirectory();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir).setLedgerDirNames(ledgerDirs).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.validateConfig(conf);
        conf.setLedgerDirNames(new String[]{ledgerDirs[0], ledgerDirs[1]});
        try {
            this.validateConfig(conf);
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
        conf.setJournalDirName(this.newDirectory()).setLedgerDirNames(ledgerDirs);
        try {
            this.validateConfig(conf);
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
        conf.setJournalDirName(journalDir);
        this.validateConfig(conf);
    }

    @Test
    public void testCookieMissingOnJournalDir() throws Exception {
        String[] ledgerDirs = new String[]{this.newDirectory(), this.newDirectory(), this.newDirectory()};
        String journalDir = this.newDirectory();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir).setLedgerDirNames(ledgerDirs).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.validateConfig(conf);
        File cookieFile = new File(BookieImpl.getCurrentDirectory((File)new File(journalDir)), "VERSION");
        Assert.assertTrue((boolean)cookieFile.delete());
        try {
            this.validateConfig(conf);
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testCookieMissingOnLedgerDir() throws Exception {
        String[] ledgerDirs = new String[]{this.newDirectory(), this.newDirectory(), this.newDirectory()};
        String journalDir = this.newDirectory();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir).setLedgerDirNames(ledgerDirs).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.validateConfig(conf);
        File cookieFile = new File(BookieImpl.getCurrentDirectory((File)new File(ledgerDirs[0])), "VERSION");
        Assert.assertTrue((boolean)cookieFile.delete());
        try {
            this.validateConfig(conf);
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testDirectoryAdded() throws Exception {
        String ledgerDir0 = this.newDirectory();
        String journalDir = this.newDirectory();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir).setLedgerDirNames(new String[]{ledgerDir0}).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.validateConfig(conf);
        conf.setLedgerDirNames(new String[]{ledgerDir0, this.newDirectory()});
        try {
            this.validateConfig(conf);
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
        conf.setLedgerDirNames(new String[]{ledgerDir0});
        this.validateConfig(conf);
    }

    @Test
    public void testStorageExpansionOption() throws Exception {
        String ledgerDir0 = this.newDirectory();
        String indexDir0 = this.newDirectory();
        String journalDir = this.newDirectory();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir).setLedgerDirNames(new String[]{ledgerDir0}).setIndexDirName(new String[]{indexDir0}).setBookiePort(this.bookiePort).setAllowStorageExpansion(true).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.validateConfig(conf);
        Object[] lPaths = new String[]{ledgerDir0, this.newDirectory(), this.newDirectory()};
        HashSet configuredLedgerDirs = Sets.newHashSet((Object[])lPaths);
        conf.setLedgerDirNames((String[])lPaths);
        Object[] iPaths = new String[]{indexDir0, this.newDirectory()};
        HashSet configuredIndexDirs = Sets.newHashSet((Object[])iPaths);
        conf.setIndexDirName((String[])iPaths);
        try {
            this.validateConfig(conf);
        }
        catch (BookieException.InvalidCookieException ice) {
            Assert.fail((String)"Should have been able to start the bookie");
        }
        List<File> l = CookieTest.currentDirectoryList(conf.getLedgerDirs());
        HashSet bookieLedgerDirs = Sets.newHashSet();
        for (File file : l) {
            bookieLedgerDirs.add(file.getParent());
        }
        Assert.assertTrue((String)("Configured ledger dirs: " + configuredLedgerDirs + " doesn't match bookie's ledger dirs: " + bookieLedgerDirs), (boolean)configuredLedgerDirs.equals(bookieLedgerDirs));
        l = CookieTest.currentDirectoryList(conf.getIndexDirs());
        HashSet bookieIndexDirs = Sets.newHashSet();
        for (File f : l) {
            bookieIndexDirs.add(f.getParent());
        }
        Assert.assertTrue((String)("Configured Index dirs: " + configuredIndexDirs + " doesn't match bookie's index dirs: " + bookieIndexDirs), (boolean)configuredIndexDirs.equals(bookieIndexDirs));
        String[] stringArray = new String[]{lPaths[0], lPaths[1], this.newDirectory()};
        conf.setLedgerDirNames(stringArray);
        try {
            this.validateConfig(conf);
            Assert.fail((String)"Should not have been able to start the bookie");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
        String[] stringArray2 = new String[]{lPaths[0], lPaths[1]};
        conf.setLedgerDirNames(stringArray2);
        try {
            this.validateConfig(conf);
            Assert.fail((String)"Should not have been able to start the bookie");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testNonEmptyDirAddWithStorageExpansionOption() throws Exception {
        String ledgerDir0 = this.newDirectory();
        String indexDir0 = this.newDirectory();
        String journalDir = this.newDirectory();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir).setLedgerDirNames(new String[]{ledgerDir0}).setIndexDirName(new String[]{indexDir0}).setBookiePort(this.bookiePort).setAllowStorageExpansion(true).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.validateConfig(conf);
        String[] lPaths = new String[]{ledgerDir0, this.newDirectory()};
        conf.setLedgerDirNames(lPaths);
        File currentDir = BookieImpl.getCurrentDirectory((File)new File(lPaths[1]));
        new File(currentDir, "foo").createNewFile();
        Assert.assertTrue((currentDir.list().length == 1 ? 1 : 0) != 0);
        try {
            this.validateConfig(conf);
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
        String[] iPaths = new String[]{indexDir0, this.newDirectory()};
        conf.setIndexDirName(iPaths);
        currentDir = BookieImpl.getCurrentDirectory((File)new File(iPaths[1]));
        new File(currentDir, "bar").mkdirs();
        Assert.assertTrue((currentDir.list().length == 1 ? 1 : 0) != 0);
        try {
            this.validateConfig(conf);
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testDirectoryCleared() throws Exception {
        String ledgerDir0 = this.newDirectory();
        String journalDir = this.newDirectory();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir).setLedgerDirNames(new String[]{ledgerDir0, this.newDirectory()}).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.validateConfig(conf);
        FileUtils.deleteDirectory((File)new File(ledgerDir0));
        try {
            this.validateConfig(conf);
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testBookiePortChanged() throws Exception {
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(this.newDirectory()).setLedgerDirNames(new String[]{this.newDirectory(), this.newDirectory()}).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.validateConfig(conf);
        conf.setBookiePort(3182);
        try {
            this.validateConfig(conf);
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testNewBookieStartingWithAnotherBookiesPort() throws Exception {
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(this.newDirectory()).setLedgerDirNames(new String[]{this.newDirectory(), this.newDirectory()}).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.validateConfig(conf);
        conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(this.newDirectory()).setLedgerDirNames(new String[]{this.newDirectory(), this.newDirectory()}).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        try {
            this.validateConfig(conf);
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testVerifyCookieWithFormat() throws Exception {
        ServerConfiguration adminConf = new ServerConfiguration();
        adminConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        adminConf.setProperty("bookkeeper.format", (Object)true);
        BookKeeperAdmin.format((ServerConfiguration)adminConf, (boolean)false, (boolean)true);
        ServerConfiguration bookieConf = TestBKConfiguration.newServerConfiguration();
        bookieConf.setJournalDirName(this.newDirectory(true)).setLedgerDirNames(new String[]{this.newDirectory(true)}).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.validateConfig(bookieConf);
        BookKeeperAdmin.format((ServerConfiguration)adminConf, (boolean)false, (boolean)true);
        try {
            this.validateConfig(bookieConf);
            Assert.fail((String)"Bookie should not start with previous instance id.");
        }
        catch (BookieException.InvalidCookieException e) {
            Assert.assertTrue((String)"Bookie startup should fail because of invalid instance id", (boolean)e.getMessage().contains("instanceId"));
        }
        BookieImpl.format((ServerConfiguration)bookieConf, (boolean)false, (boolean)true);
        this.validateConfig(bookieConf);
    }

    @Test
    public void testV2data() throws Exception {
        File journalDir = UpgradeTest.initV2JournalDirectory(this.tmpDirs.createNew("bookie", "journal"));
        File ledgerDir = UpgradeTest.initV2LedgerDirectory(this.tmpDirs.createNew("bookie", "ledger"));
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir.getPath()).setLedgerDirNames(new String[]{ledgerDir.getPath()}).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        try {
            BookieImpl.checkDirectoryStructure((File)BookieImpl.getCurrentDirectory((File)journalDir));
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)"wrong exception", (boolean)ioe.getMessage().contains("upgrade needed"));
        }
        try {
            BookieImpl.checkDirectoryStructure((File)BookieImpl.getCurrentDirectory((File)ledgerDir));
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)"wrong exception", (boolean)ioe.getMessage().contains("upgrade needed"));
        }
    }

    @Test
    public void testV1data() throws Exception {
        File journalDir = UpgradeTest.initV1JournalDirectory(this.tmpDirs.createNew("bookie", "journal"));
        File ledgerDir = UpgradeTest.initV1LedgerDirectory(this.tmpDirs.createNew("bookie", "ledger"));
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir.getPath()).setLedgerDirNames(new String[]{ledgerDir.getPath()}).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        try {
            BookieImpl.checkDirectoryStructure((File)BookieImpl.getCurrentDirectory((File)journalDir));
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)"wrong exception", (boolean)ioe.getMessage().contains("upgrade needed"));
        }
        try {
            BookieImpl.checkDirectoryStructure((File)BookieImpl.getCurrentDirectory((File)ledgerDir));
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)"wrong exception", (boolean)ioe.getMessage().contains("upgrade needed"));
        }
    }

    @Test
    public void testRestartWithHostNameAsBookieID() throws Exception {
        String[] ledgerDirs = new String[]{this.newDirectory(), this.newDirectory(), this.newDirectory()};
        String journalDir = this.newDirectory();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir).setLedgerDirNames(ledgerDirs).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.validateConfig(conf);
        conf.setUseHostNameAsBookieID(true);
        try {
            this.validateConfig(conf);
            Assert.fail((String)"Should not start a bookie with hostname if the bookie has been started with an ip");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testRestartWithAdvertisedAddressAsBookieID() throws Exception {
        String[] ledgerDirs = new String[]{this.newDirectory(), this.newDirectory(), this.newDirectory()};
        String journalDir = this.newDirectory();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir).setLedgerDirNames(ledgerDirs).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        conf.setUseHostNameAsBookieID(false);
        this.validateConfig(conf);
        conf.setAdvertisedAddress("unknown");
        try {
            this.validateConfig(conf);
            Assert.fail((String)"Should not start a bookie with ip if the bookie has been started with an ip");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testRestartWithIpAddressAsBookieID() throws Exception {
        String[] ledgerDirs = new String[]{this.newDirectory(), this.newDirectory(), this.newDirectory()};
        String journalDir = this.newDirectory();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir).setLedgerDirNames(ledgerDirs).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        conf.setUseHostNameAsBookieID(true);
        this.validateConfig(conf);
        conf.setUseHostNameAsBookieID(false);
        try {
            this.validateConfig(conf);
            Assert.fail((String)"Should not start a bookie with ip if the bookie has been started with an ip");
        }
        catch (BookieException.InvalidCookieException invalidCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testV2dataWithHostNameAsBookieID() throws Exception {
        File journalDir = UpgradeTest.initV2JournalDirectory(this.tmpDirs.createNew("bookie", "journal"));
        File ledgerDir = UpgradeTest.initV2LedgerDirectory(this.tmpDirs.createNew("bookie", "ledger"));
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir.getPath()).setLedgerDirNames(new String[]{ledgerDir.getPath()}).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        try {
            BookieImpl.checkDirectoryStructure((File)BookieImpl.getCurrentDirectory((File)ledgerDir));
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)"wrong exception", (boolean)ioe.getMessage().contains("upgrade needed"));
        }
        try {
            BookieImpl.checkDirectoryStructure((File)BookieImpl.getCurrentDirectory((File)journalDir));
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)"wrong exception", (boolean)ioe.getMessage().contains("upgrade needed"));
        }
    }

    @Test
    public void testWriteToZooKeeper() throws Exception {
        String[] ledgerDirs = new String[]{this.newDirectory(), this.newDirectory(), this.newDirectory()};
        String journalDir = this.newDirectory();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir).setLedgerDirNames(ledgerDirs).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.validateConfig(conf);
        Versioned zkCookie = Cookie.readFromRegistrationManager((RegistrationManager)this.rm, (ServerConfiguration)conf);
        Version version1 = zkCookie.getVersion();
        Assert.assertTrue((String)"Invalid type expected ZkVersion type", (boolean)(version1 instanceof LongVersion));
        LongVersion zkVersion1 = (LongVersion)version1;
        Cookie cookie = (Cookie)zkCookie.getValue();
        cookie.writeToRegistrationManager(this.rm, conf, version1);
        zkCookie = Cookie.readFromRegistrationManager((RegistrationManager)this.rm, (ServerConfiguration)conf);
        Version version2 = zkCookie.getVersion();
        Assert.assertTrue((String)"Invalid type expected ZkVersion type", (boolean)(version2 instanceof LongVersion));
        LongVersion zkVersion2 = (LongVersion)version2;
        Assert.assertEquals((String)"Version mismatches!", (long)(zkVersion1.getLongVersion() + 1L), (long)zkVersion2.getLongVersion());
    }

    @Test
    public void testDeleteFromZooKeeper() throws Exception {
        String[] ledgerDirs = new String[]{this.newDirectory(), this.newDirectory(), this.newDirectory()};
        String journalDir = this.newDirectory();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir).setLedgerDirNames(ledgerDirs).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.validateConfig(conf);
        Versioned zkCookie = Cookie.readFromRegistrationManager((RegistrationManager)this.rm, (ServerConfiguration)conf);
        Cookie cookie = (Cookie)zkCookie.getValue();
        cookie.deleteFromRegistrationManager(this.rm, conf, zkCookie.getVersion());
    }

    @Test
    public void testBookieIdSetting() throws Exception {
        String customBookieId = "myCustomBookieId" + new Random().nextInt();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(this.newDirectory()).setLedgerDirNames(new String[]{this.newDirectory(), this.newDirectory()}).setBookiePort(this.bookiePort).setBookieId(customBookieId).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.validateConfig(conf);
        Versioned zkCookie = Cookie.readFromRegistrationManager((RegistrationManager)this.rm, (ServerConfiguration)conf);
        Version version1 = zkCookie.getVersion();
        Assert.assertTrue((String)"Invalid type expected ZkVersion type", (boolean)(version1 instanceof LongVersion));
        Cookie cookie = (Cookie)zkCookie.getValue();
        cookie.writeToRegistrationManager(this.rm, conf, version1);
        Assert.assertTrue((boolean)cookie.toString().contains(customBookieId));
    }
}

