/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.bookie.AbstractLogCompactor;
import org.apache.bookkeeper.bookie.CompactableLedgerStorage;
import org.apache.bookkeeper.bookie.EntryLocation;
import org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.bookkeeper.bookie.EntryLogMetadataMap;
import org.apache.bookkeeper.bookie.GarbageCollectorThread;
import org.apache.bookkeeper.bookie.MockLedgerStorage;
import org.apache.bookkeeper.bookie.storage.EntryLogTestUtils;
import org.apache.bookkeeper.bookie.storage.EntryLogger;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.MockLedgerManager;
import org.apache.bookkeeper.slogger.Slogger;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TmpDirs;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.powermock.reflect.Whitebox;

public class GarbageCollectorThreadTest {
    private static final Slogger slog = Slogger.CONSOLE;
    private final TmpDirs tmpDirs = new TmpDirs();
    @InjectMocks
    @Spy
    private GarbageCollectorThread mockGCThread;
    @Mock
    private LedgerManager ledgerManager;
    @Mock
    private StatsLogger statsLogger;
    @Mock
    private ScheduledExecutorService gcExecutor;
    private ServerConfiguration conf = (ServerConfiguration)Mockito.spy((Object)new ServerConfiguration().setAllowLoopback(true));
    private CompactableLedgerStorage ledgerStorage = (CompactableLedgerStorage)Mockito.mock(CompactableLedgerStorage.class);

    @Before
    public void setUp() throws Exception {
        this.conf.setAllowLoopback(true);
        MockitoAnnotations.openMocks((Object)this);
    }

    @After
    public void cleanup() throws Exception {
        this.tmpDirs.cleanup();
    }

    @Test
    public void testCompactEntryLogWithException() throws Exception {
        AbstractLogCompactor mockCompactor = (AbstractLogCompactor)Mockito.mock(AbstractLogCompactor.class);
        Mockito.when((Object)mockCompactor.compact((EntryLogMetadata)Mockito.any(EntryLogMetadata.class))).thenThrow(new Throwable[]{new RuntimeException("Unexpected compaction error")});
        Whitebox.setInternalState((Object)this.mockGCThread, (String)"compactor", (Object)mockCompactor);
        AtomicBoolean compacting = (AtomicBoolean)Whitebox.getInternalState((Object)this.mockGCThread, (String)"compacting");
        Assert.assertFalse((boolean)compacting.get());
        this.mockGCThread.compactEntryLog(new EntryLogMetadata(9999L));
        Assert.assertFalse((boolean)compacting.get());
    }

    @Test
    public void testCalculateUsageBucket() {
        int numBuckets = 10;
        int[] usageBuckets = new int[10];
        String[] bucketNames = new String[10];
        for (int i = 0; i < 10; ++i) {
            usageBuckets[i] = 0;
            bucketNames[i] = String.format("%d%%", (i + 1) * 10);
        }
        int items = 10000;
        for (int item = 0; item <= items; ++item) {
            double usage = (double)item / (double)items;
            int index = this.mockGCThread.calculateUsageIndex(10, usage);
            Assert.assertFalse((String)"Boundary condition exceeded", (index < 0 || index >= 10 ? 1 : 0) != 0);
            slog.kv((Object)"usage", (Object)usage).kv((Object)"index", (Object)index).info("Mapped usage to index");
            int n = index;
            usageBuckets[n] = usageBuckets[n] + 1;
        }
        Slogger sl = slog.ctx();
        for (int i = 0; i < 10; ++i) {
            sl = sl.kv((Object)bucketNames[i], (Object)usageBuckets[i]);
        }
        sl.info("Compaction: entry log usage buckets");
        int sum = 0;
        for (int i = 0; i < 10; ++i) {
            sum += usageBuckets[i];
        }
        Assert.assertEquals((String)"Incorrect number of items", (long)(items + 1), (long)sum);
    }

    @Test
    public void testExtractMetaFromEntryLogsLegacy() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("testExtractMeta", "ledgers");
        this.testExtractMetaFromEntryLogs(EntryLogTestUtils.newLegacyEntryLogger(20000, ledgerDir), ledgerDir);
    }

    @Test
    public void testExtractMetaFromEntryLogsDirect() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("testExtractMeta", "ledgers");
        this.testExtractMetaFromEntryLogs((EntryLogger)EntryLogTestUtils.newDirectEntryLogger(23000, ledgerDir), ledgerDir);
    }

    private void testExtractMetaFromEntryLogs(EntryLogger entryLogger, File ledgerDir) throws Exception {
        MockLedgerStorage storage = new MockLedgerStorage();
        MockLedgerManager lm = new MockLedgerManager();
        GarbageCollectorThread gcThread = new GarbageCollectorThread(TestBKConfiguration.newServerConfiguration(), (LedgerManager)lm, EntryLogTestUtils.newDirsManager(ledgerDir), (CompactableLedgerStorage)storage, entryLogger, (StatsLogger)NullStatsLogger.INSTANCE);
        long loc1 = entryLogger.addEntry(1L, EntryLogTestUtils.makeEntry(1L, 1L, 5000));
        long loc2 = entryLogger.addEntry(2L, EntryLogTestUtils.makeEntry(2L, 1L, 5000));
        MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc2), (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc1)));
        long loc3 = entryLogger.addEntry(2L, EntryLogTestUtils.makeEntry(2L, 1L, 15000));
        MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc3), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(EntryLogTestUtils.logIdFromLocation(loc2))));
        long loc4 = entryLogger.addEntry(2L, EntryLogTestUtils.makeEntry(2L, 1L, 15000));
        MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc4), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(EntryLogTestUtils.logIdFromLocation(loc3))));
        long loc5 = entryLogger.addEntry(3L, EntryLogTestUtils.makeEntry(3L, 1L, 1000));
        MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc5), (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc4)));
        long logId1 = EntryLogTestUtils.logIdFromLocation(loc2);
        long logId2 = EntryLogTestUtils.logIdFromLocation(loc3);
        long logId3 = EntryLogTestUtils.logIdFromLocation(loc5);
        entryLogger.flush();
        storage.setMasterKey(1L, new byte[0]);
        storage.setMasterKey(2L, new byte[0]);
        storage.setMasterKey(3L, new byte[0]);
        MatcherAssert.assertThat((Object)entryLogger.getFlushedLogIds(), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{logId1, logId2}));
        Assert.assertTrue((boolean)entryLogger.logExists(logId3));
        EntryLogMetadataMap entryLogMetaMap = gcThread.getEntryLogMetaMap();
        gcThread.extractMetaFromEntryLogs();
        MatcherAssert.assertThat((Object)entryLogger.getFlushedLogIds(), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{logId1, logId2}));
        Assert.assertTrue((boolean)entryLogMetaMap.containsKey(logId1));
        Assert.assertTrue((boolean)entryLogMetaMap.containsKey(logId2));
        Assert.assertTrue((boolean)entryLogger.logExists(logId3));
        entryLogMetaMap.clear();
        storage.deleteLedger(2L);
        gcThread.extractMetaFromEntryLogs();
        MatcherAssert.assertThat((Object)entryLogger.getFlushedLogIds(), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{logId1}));
        Assert.assertTrue((boolean)entryLogMetaMap.containsKey(logId1));
        Assert.assertTrue((boolean)entryLogger.logExists(logId3));
        entryLogMetaMap.clear();
        storage.deleteLedger(1L);
        storage.deleteLedger(3L);
        gcThread.extractMetaFromEntryLogs();
        MatcherAssert.assertThat((Object)entryLogger.getFlushedLogIds(), (Matcher)Matchers.empty());
        Assert.assertTrue((boolean)entryLogMetaMap.isEmpty());
        Assert.assertTrue((boolean)entryLogger.logExists(logId3));
        long loc6 = entryLogger.addEntry(3L, EntryLogTestUtils.makeEntry(3L, 1L, 25000));
        MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc6), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(EntryLogTestUtils.logIdFromLocation(loc5))));
        entryLogger.flush();
        MatcherAssert.assertThat((Object)entryLogger.getFlushedLogIds(), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{logId3}));
        entryLogMetaMap.clear();
        gcThread.extractMetaFromEntryLogs();
        MatcherAssert.assertThat((Object)entryLogger.getFlushedLogIds(), (Matcher)Matchers.empty());
        Assert.assertTrue((boolean)entryLogMetaMap.isEmpty());
        Assert.assertFalse((boolean)entryLogger.logExists(logId3));
    }

    @Test
    public void testCompactionWithFileSizeCheck() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("testFileSize", "ledgers");
        EntryLogger entryLogger = EntryLogTestUtils.newLegacyEntryLogger(20000, ledgerDir);
        MockLedgerStorage storage = new MockLedgerStorage();
        MockLedgerManager lm = new MockLedgerManager();
        GarbageCollectorThread gcThread = new GarbageCollectorThread(TestBKConfiguration.newServerConfiguration().setUseTargetEntryLogSizeForGc(true), (LedgerManager)lm, EntryLogTestUtils.newDirsManager(ledgerDir), (CompactableLedgerStorage)storage, entryLogger, (StatsLogger)NullStatsLogger.INSTANCE);
        long loc1 = entryLogger.addEntry(1L, EntryLogTestUtils.makeEntry(1L, 1L, 5000));
        long loc2 = entryLogger.addEntry(2L, EntryLogTestUtils.makeEntry(2L, 1L, 5000));
        MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc2), (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc1)));
        long loc3 = entryLogger.addEntry(2L, EntryLogTestUtils.makeEntry(2L, 2L, 15000));
        MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc3), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(EntryLogTestUtils.logIdFromLocation(loc2))));
        long loc4 = entryLogger.addEntry(2L, EntryLogTestUtils.makeEntry(2L, 3L, 15000));
        MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc4), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(EntryLogTestUtils.logIdFromLocation(loc3))));
        long loc5 = entryLogger.addEntry(3L, EntryLogTestUtils.makeEntry(3L, 1L, 1000));
        MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc5), (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc4)));
        long loc6 = entryLogger.addEntry(3L, EntryLogTestUtils.makeEntry(3L, 2L, 5000));
        long logId1 = EntryLogTestUtils.logIdFromLocation(loc2);
        long logId2 = EntryLogTestUtils.logIdFromLocation(loc3);
        long logId3 = EntryLogTestUtils.logIdFromLocation(loc5);
        long logId4 = EntryLogTestUtils.logIdFromLocation(loc6);
        entryLogger.flush();
        storage.setMasterKey(1L, new byte[0]);
        storage.setMasterKey(2L, new byte[0]);
        storage.setMasterKey(3L, new byte[0]);
        MatcherAssert.assertThat((Object)entryLogger.getFlushedLogIds(), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{logId1, logId2, logId3}));
        Assert.assertTrue((boolean)entryLogger.logExists(logId1));
        Assert.assertTrue((boolean)entryLogger.logExists(logId2));
        Assert.assertTrue((boolean)entryLogger.logExists(logId3));
        Assert.assertTrue((boolean)entryLogger.logExists(logId4));
        EntryLogMetadataMap entryLogMetaMap = gcThread.getEntryLogMetaMap();
        gcThread.extractMetaFromEntryLogs();
        MatcherAssert.assertThat((Object)entryLogger.getFlushedLogIds(), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{logId1, logId2, logId3}));
        Assert.assertTrue((boolean)entryLogMetaMap.containsKey(logId1));
        Assert.assertTrue((boolean)entryLogMetaMap.containsKey(logId2));
        Assert.assertTrue((boolean)entryLogger.logExists(logId3));
        storage.deleteLedger(1L);
        gcThread.runWithFlags(true, true, false);
        Assert.assertFalse((boolean)entryLogger.logExists(logId1));
        Assert.assertTrue((boolean)entryLogger.logExists(logId2));
        Assert.assertTrue((boolean)entryLogger.logExists(logId3));
        Assert.assertFalse((boolean)entryLogMetaMap.containsKey(logId1));
        Assert.assertTrue((boolean)entryLogMetaMap.containsKey(logId2));
        Assert.assertEquals((long)1L, (long)storage.getUpdatedLocations().size());
        EntryLocation location2 = storage.getUpdatedLocations().get(0);
        Assert.assertEquals((long)2L, (long)location2.getLedger());
        Assert.assertEquals((long)1L, (long)location2.getEntry());
        Assert.assertEquals((long)EntryLogTestUtils.logIdFromLocation(location2.getLocation()), (long)logId4);
    }

    @Test
    public void testCompactionWithoutFileSizeCheck() throws Exception {
        File ledgerDir = this.tmpDirs.createNew("testFileSize", "ledgers");
        EntryLogger entryLogger = EntryLogTestUtils.newLegacyEntryLogger(20000, ledgerDir);
        MockLedgerStorage storage = new MockLedgerStorage();
        MockLedgerManager lm = new MockLedgerManager();
        GarbageCollectorThread gcThread = new GarbageCollectorThread(TestBKConfiguration.newServerConfiguration(), (LedgerManager)lm, EntryLogTestUtils.newDirsManager(ledgerDir), (CompactableLedgerStorage)storage, entryLogger, (StatsLogger)NullStatsLogger.INSTANCE);
        long loc1 = entryLogger.addEntry(1L, EntryLogTestUtils.makeEntry(1L, 1L, 5000));
        long loc2 = entryLogger.addEntry(2L, EntryLogTestUtils.makeEntry(2L, 1L, 5000));
        MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc2), (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc1)));
        long loc3 = entryLogger.addEntry(2L, EntryLogTestUtils.makeEntry(2L, 2L, 15000));
        MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc3), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(EntryLogTestUtils.logIdFromLocation(loc2))));
        long loc4 = entryLogger.addEntry(2L, EntryLogTestUtils.makeEntry(2L, 3L, 15000));
        MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc4), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(EntryLogTestUtils.logIdFromLocation(loc3))));
        long loc5 = entryLogger.addEntry(3L, EntryLogTestUtils.makeEntry(3L, 1L, 1000));
        MatcherAssert.assertThat((Object)EntryLogTestUtils.logIdFromLocation(loc5), (Matcher)Matchers.equalTo((Object)EntryLogTestUtils.logIdFromLocation(loc4)));
        long logId1 = EntryLogTestUtils.logIdFromLocation(loc2);
        long logId2 = EntryLogTestUtils.logIdFromLocation(loc3);
        long logId3 = EntryLogTestUtils.logIdFromLocation(loc5);
        entryLogger.flush();
        storage.setMasterKey(1L, new byte[0]);
        storage.setMasterKey(2L, new byte[0]);
        storage.setMasterKey(3L, new byte[0]);
        MatcherAssert.assertThat((Object)entryLogger.getFlushedLogIds(), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{logId1, logId2}));
        Assert.assertTrue((boolean)entryLogger.logExists(logId1));
        Assert.assertTrue((boolean)entryLogger.logExists(logId2));
        Assert.assertTrue((boolean)entryLogger.logExists(logId3));
        EntryLogMetadataMap entryLogMetaMap = gcThread.getEntryLogMetaMap();
        gcThread.extractMetaFromEntryLogs();
        MatcherAssert.assertThat((Object)entryLogger.getFlushedLogIds(), (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{logId1, logId2}));
        Assert.assertTrue((boolean)entryLogMetaMap.containsKey(logId1));
        Assert.assertTrue((boolean)entryLogMetaMap.containsKey(logId2));
        Assert.assertTrue((boolean)entryLogger.logExists(logId3));
        gcThread.runWithFlags(true, true, false);
        Assert.assertTrue((boolean)entryLogger.logExists(logId1));
        Assert.assertTrue((boolean)entryLogger.logExists(logId2));
        Assert.assertTrue((boolean)entryLogger.logExists(logId3));
        Assert.assertTrue((boolean)entryLogMetaMap.containsKey(logId1));
        Assert.assertTrue((boolean)entryLogMetaMap.containsKey(logId2));
        Assert.assertEquals((long)0L, (long)storage.getUpdatedLocations().size());
    }
}

