/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.DefaultEntryLogger;
import org.apache.bookkeeper.bookie.EntryLogManagerBase;
import org.apache.bookkeeper.bookie.EntryLogManagerForEntryLogPerLedger;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.Journal;
import org.apache.bookkeeper.bookie.LogMark;
import org.apache.bookkeeper.bookie.MockUncleanShutdownDetection;
import org.apache.bookkeeper.bookie.SortedLedgerStorage;
import org.apache.bookkeeper.bookie.SyncThread;
import org.apache.bookkeeper.bookie.TestBookieImpl;
import org.apache.bookkeeper.bookie.UncleanShutdownDetection;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.common.testing.executors.MockExecutorController;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.ThreadRegistry;
import org.apache.bookkeeper.test.ZooKeeperUtil;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.util.PortManager;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={SyncThread.class})
@PowerMockIgnore(value={"java.*", "javax.*", "org.slf4j.*"})
public class LedgerStorageCheckpointTest {
    private static final Logger LOG = LoggerFactory.getLogger(LedgerStorageCheckpointTest.class);
    @Rule
    public final TestName runtime = new TestName();
    protected final ZooKeeperUtil zkUtil = new ZooKeeperUtil();
    protected final List<File> tmpDirs = new LinkedList<File>();
    MockExecutorController executorController;

    @Before
    public void setUp() throws Exception {
        ThreadRegistry.clear();
        LOG.info("Setting up test {}", this.getClass());
        PowerMockito.mockStatic(Executors.class, (Class[])new Class[0]);
        try {
            this.startZKCluster();
        }
        catch (Exception e) {
            LOG.error("Error setting up", (Throwable)e);
            throw e;
        }
        ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)PowerMockito.mock(ScheduledExecutorService.class);
        this.executorController = new MockExecutorController().controlSubmit(scheduledExecutorService).controlScheduleAtFixedRate(scheduledExecutorService, 10);
        PowerMockito.when((Object)scheduledExecutorService.awaitTermination(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenReturn((Object)true);
        PowerMockito.when((Object)Executors.newSingleThreadScheduledExecutor((ThreadFactory)ArgumentMatchers.any())).thenReturn((Object)scheduledExecutorService);
    }

    @After
    public void tearDown() throws Exception {
        ThreadRegistry.clear();
        LOG.info("TearDown");
        Exception tearDownException = null;
        try {
            this.stopZKCluster();
        }
        catch (Exception e) {
            LOG.error("Got Exception while trying to stop ZKCluster", (Throwable)e);
            tearDownException = e;
        }
        try {
            this.cleanupTempDirs();
        }
        catch (Exception e) {
            LOG.error("Got Exception while trying to cleanupTempDirs", (Throwable)e);
            tearDownException = e;
        }
        if (tearDownException != null) {
            throw tearDownException;
        }
    }

    protected void startZKCluster() throws Exception {
        this.zkUtil.startCluster();
    }

    protected void stopZKCluster() throws Exception {
        this.zkUtil.killCluster();
    }

    protected void cleanupTempDirs() throws Exception {
        for (File f : this.tmpDirs) {
            FileUtils.deleteDirectory((File)f);
        }
    }

    protected File createTempDir(String prefix, String suffix) throws IOException {
        File dir = IOUtils.createTempDir((String)prefix, (String)suffix);
        this.tmpDirs.add(dir);
        return dir;
    }

    private LogMark readLastMarkFile(File lastMarkFile) throws IOException {
        byte[] buff = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(buff);
        LogMark rolledLogMark = new LogMark();
        FileInputStream fis = new FileInputStream(lastMarkFile);
        int bytesRead = fis.read(buff);
        fis.close();
        if (bytesRead != 16) {
            throw new IOException("Couldn't read enough bytes from lastMark. Wanted 16, got " + bytesRead);
        }
        bb.clear();
        rolledLogMark.readLogMark(bb);
        return rolledLogMark;
    }

    @Test
    public void testPeriodicCheckpointForInterleavedLedgerStorage() throws Exception {
        this.testPeriodicCheckpointForLedgerStorage(InterleavedLedgerStorage.class.getName());
    }

    @Test
    public void testPeriodicCheckpointForSortedLedgerStorage() throws Exception {
        this.testPeriodicCheckpointForLedgerStorage(SortedLedgerStorage.class.getName());
    }

    public void testPeriodicCheckpointForLedgerStorage(String ledgerStorageClassName) throws Exception {
        File tmpDir = this.createTempDir("DiskCheck", "test");
        ServerConfiguration conf = ((ServerConfiguration)((ServerConfiguration)TestBKConfiguration.newServerConfiguration().setMetadataServiceUri(this.zkUtil.getMetadataServiceUri())).setZkTimeout(5000)).setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()}).setAutoRecoveryDaemonEnabled(false).setFlushInterval(2000).setBookiePort(PortManager.nextFreePort()).setEntryLogPerLedgerEnabled(true).setLedgerStorageClass(ledgerStorageClassName);
        Assert.assertEquals((String)"Number of JournalDirs", (long)1L, (long)conf.getJournalDirs().length);
        File ledgerDir = BookieImpl.getCurrentDirectories((File[])conf.getLedgerDirs())[0];
        BookieServer server = new BookieServer(conf, (Bookie)new TestBookieImpl(conf), (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, (UncleanShutdownDetection)new MockUncleanShutdownDetection());
        server.start();
        ClientConfiguration clientConf = new ClientConfiguration();
        clientConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper bkClient = new BookKeeper(clientConf);
        int numOfLedgers = 2;
        int numOfEntries = 5;
        byte[] dataBytes = "data".getBytes();
        for (int i = 0; i < numOfLedgers; ++i) {
            int ledgerIndex = i;
            LedgerHandle handle = bkClient.createLedgerAdv((long)i, 1, 1, 1, BookKeeper.DigestType.CRC32, "passwd".getBytes(), null);
            for (int j = 0; j < numOfEntries; ++j) {
                handle.addEntry((long)j, dataBytes);
            }
            handle.close();
        }
        Journal.LastLogMark lastLogMarkAfterFirstSetOfAdds = ((Journal)((BookieImpl)server.getBookie()).journals.get(0)).getLastLogMark();
        LogMark curMarkAfterFirstSetOfAdds = lastLogMarkAfterFirstSetOfAdds.getCurMark();
        File lastMarkFile = new File(ledgerDir, "lastMark");
        LogMark logMarkFileBeforeCheckpoint = this.readLastMarkFile(lastMarkFile);
        Assert.assertEquals((String)"lastMarkFile before checkpoint should be zero", (long)0L, (long)logMarkFileBeforeCheckpoint.compare(new LogMark()));
        this.executorController.advance(Duration.ofMillis(conf.getFlushInterval()));
        Assert.assertTrue((String)"lastMark file must be existing, because checkpoint should have happened", (boolean)lastMarkFile.exists());
        Journal.LastLogMark lastLogMarkAfterCheckpoint = ((Journal)((BookieImpl)server.getBookie()).journals.get(0)).getLastLogMark();
        LogMark curMarkAfterCheckpoint = lastLogMarkAfterCheckpoint.getCurMark();
        LogMark rolledLogMark = this.readLastMarkFile(lastMarkFile);
        Assert.assertNotEquals((String)"rolledLogMark should not be zero, since checkpoint has happenend", (long)0L, (long)rolledLogMark.compare(new LogMark()));
        Assert.assertTrue((String)"Curmark should be equal before and after checkpoint", (curMarkAfterCheckpoint.compare(curMarkAfterFirstSetOfAdds) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Curmark after first set of adds should be equal to rolled logmark", (curMarkAfterCheckpoint.compare(rolledLogMark) == 0 ? 1 : 0) != 0);
        for (int i = numOfLedgers; i < 2 * numOfLedgers; ++i) {
            int ledgerIndex = i;
            LedgerHandle handle = bkClient.createLedgerAdv((long)i, 1, 1, 1, BookKeeper.DigestType.CRC32, "passwd".getBytes(), null);
            for (int j = 0; j < numOfEntries; ++j) {
                handle.addEntry((long)j, dataBytes);
            }
            handle.close();
        }
        this.executorController.advance(Duration.ofMillis(conf.getFlushInterval()));
        Journal.LastLogMark lastLogMarkAfterSecondSetOfAdds = ((Journal)((BookieImpl)server.getBookie()).journals.get(0)).getLastLogMark();
        LogMark curMarkAfterSecondSetOfAdds = lastLogMarkAfterSecondSetOfAdds.getCurMark();
        rolledLogMark = this.readLastMarkFile(lastMarkFile);
        Assert.assertTrue((String)"Curmark after second set of adds should be equal to rolled logmark", (curMarkAfterSecondSetOfAdds.compare(rolledLogMark) == 0 ? 1 : 0) != 0);
        server.shutdown();
        bkClient.close();
    }

    @Test
    public void testCheckpointOfILSEntryLogIsRotatedWithELPLEnabled() throws Exception {
        this.testCheckpointofILSWhenEntryLogIsRotated(true);
    }

    @Test
    public void testCheckpointOfILSEntryLogIsRotatedWithELPLDisabled() throws Exception {
        this.testCheckpointofILSWhenEntryLogIsRotated(false);
    }

    public void testCheckpointofILSWhenEntryLogIsRotated(boolean entryLogPerLedgerEnabled) throws Exception {
        File tmpDir = this.createTempDir("DiskCheck", "test");
        ServerConfiguration conf = ((ServerConfiguration)((ServerConfiguration)TestBKConfiguration.newServerConfiguration().setMetadataServiceUri(this.zkUtil.getMetadataServiceUri())).setZkTimeout(5000)).setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()}).setAutoRecoveryDaemonEnabled(false).setFlushInterval(30000).setBookiePort(PortManager.nextFreePort()).setEntryLogPerLedgerEnabled(entryLogPerLedgerEnabled).setLedgerStorageClass(InterleavedLedgerStorage.class.getName());
        Assert.assertEquals((String)"Number of JournalDirs", (long)1L, (long)conf.getJournalDirs().length);
        File ledgerDir = BookieImpl.getCurrentDirectories((File[])conf.getLedgerDirs())[0];
        BookieServer server = new BookieServer(conf, (Bookie)new TestBookieImpl(conf), (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, (UncleanShutdownDetection)new MockUncleanShutdownDetection());
        server.start();
        ClientConfiguration clientConf = new ClientConfiguration();
        clientConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper bkClient = new BookKeeper(clientConf);
        InterleavedLedgerStorage ledgerStorage = (InterleavedLedgerStorage)server.getBookie().getLedgerStorage();
        int numOfEntries = 5;
        byte[] dataBytes = "data".getBytes();
        long ledgerId = 10L;
        LedgerHandle handle = bkClient.createLedgerAdv(ledgerId, 1, 1, 1, BookKeeper.DigestType.CRC32, "passwd".getBytes(), null);
        for (int j = 0; j < numOfEntries; ++j) {
            handle.addEntry((long)j, dataBytes);
        }
        handle.close();
        ((EntryLogManagerBase)ledgerStorage.getEntryLogger().getEntryLogManager()).createNewLog(ledgerId);
        this.executorController.advance(Duration.ofMillis(500L));
        File lastMarkFile = new File(ledgerDir, "lastMark");
        LogMark rolledLogMark = this.readLastMarkFile(lastMarkFile);
        if (entryLogPerLedgerEnabled) {
            Assert.assertEquals((String)"rolledLogMark should be zero, since checkpointshouldn't have happened when entryLog is rotated", (long)0L, (long)rolledLogMark.compare(new LogMark()));
        } else {
            Assert.assertNotEquals((String)"rolledLogMark shouldn't be zero, since checkpointshould have happened when entryLog is rotated", (long)0L, (long)rolledLogMark.compare(new LogMark()));
        }
        bkClient.close();
        server.shutdown();
    }

    @Test
    public void testCheckpointOfSLSEntryLogIsRotatedWithELPLEnabled() throws Exception {
        this.testCheckpointOfSLSWhenEntryLogIsRotated(true);
    }

    @Test
    public void testCheckpointOfSLSEntryLogIsRotatedWithELPLDisabled() throws Exception {
        this.testCheckpointOfSLSWhenEntryLogIsRotated(false);
    }

    public void testCheckpointOfSLSWhenEntryLogIsRotated(boolean entryLogPerLedgerEnabled) throws Exception {
        File tmpDir = this.createTempDir("DiskCheck", "test");
        ServerConfiguration conf = ((ServerConfiguration)((ServerConfiguration)TestBKConfiguration.newServerConfiguration().setMetadataServiceUri(this.zkUtil.getMetadataServiceUri())).setZkTimeout(5000)).setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()}).setAutoRecoveryDaemonEnabled(false).setFlushInterval(30000).setBookiePort(PortManager.nextFreePort()).setEntryLogPerLedgerEnabled(entryLogPerLedgerEnabled).setLedgerStorageClass(SortedLedgerStorage.class.getName()).setSkipListSizeLimit(1000000).setEntryLogSizeLimit(2000000L);
        Assert.assertEquals((String)"Number of JournalDirs", (long)1L, (long)conf.getJournalDirs().length);
        File ledgerDir = BookieImpl.getCurrentDirectories((File[])conf.getLedgerDirs())[0];
        BookieServer server = new BookieServer(conf, (Bookie)new TestBookieImpl(conf), (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, (UncleanShutdownDetection)new MockUncleanShutdownDetection());
        server.start();
        ClientConfiguration clientConf = new ClientConfiguration();
        clientConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper bkClient = new BookKeeper(clientConf);
        Random rand = new Random();
        byte[] dataBytes = new byte[10000];
        rand.nextBytes(dataBytes);
        int numOfEntries = ((int)conf.getEntryLogSizeLimit() + 100000) / dataBytes.length;
        LedgerHandle handle = bkClient.createLedgerAdv(10L, 1, 1, 1, BookKeeper.DigestType.CRC32, "passwd".getBytes(), null);
        for (int j = 0; j < numOfEntries; ++j) {
            handle.addEntry((long)j, dataBytes);
        }
        handle.close();
        this.executorController.advance(Duration.ofMillis(500L));
        File lastMarkFile = new File(ledgerDir, "lastMark");
        LogMark rolledLogMark = this.readLastMarkFile(lastMarkFile);
        if (entryLogPerLedgerEnabled) {
            Assert.assertEquals((String)"rolledLogMark should be zero, since checkpointshouldn't have happened when entryLog is rotated", (long)0L, (long)rolledLogMark.compare(new LogMark()));
        } else {
            Assert.assertNotEquals((String)"rolledLogMark shouldn't be zero, since checkpointshould have happened when entryLog is rotated", (long)0L, (long)rolledLogMark.compare(new LogMark()));
        }
        bkClient.close();
        server.shutdown();
    }

    @Test
    public void testIfEntryLogPerLedgerEnabledCheckpointFlushesAllLogs() throws Exception {
        File tmpDir = this.createTempDir("DiskCheck", "test");
        ServerConfiguration conf = ((ServerConfiguration)((ServerConfiguration)TestBKConfiguration.newServerConfiguration().setMetadataServiceUri(this.zkUtil.getMetadataServiceUri())).setZkTimeout(5000)).setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()}).setAutoRecoveryDaemonEnabled(false).setFlushInterval(3000).setBookiePort(PortManager.nextFreePort()).setEntryLogPerLedgerEnabled(true).setLedgerStorageClass(InterleavedLedgerStorage.class.getName()).setFlushIntervalInBytes(10000000L);
        Assert.assertEquals((String)"Number of JournalDirs", (long)1L, (long)conf.getJournalDirs().length);
        File ledgerDir = BookieImpl.getCurrentDirectories((File[])conf.getLedgerDirs())[0];
        BookieServer server = new BookieServer(conf, (Bookie)new TestBookieImpl(conf), (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, (UncleanShutdownDetection)new MockUncleanShutdownDetection());
        server.start();
        ClientConfiguration clientConf = new ClientConfiguration();
        clientConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper bkClient = new BookKeeper(clientConf);
        InterleavedLedgerStorage ledgerStorage = (InterleavedLedgerStorage)server.getBookie().getLedgerStorage();
        DefaultEntryLogger entryLogger = ledgerStorage.entryLogger;
        EntryLogManagerForEntryLogPerLedger entryLogManager = (EntryLogManagerForEntryLogPerLedger)entryLogger.getEntryLogManager();
        Random rand = new Random();
        int numOfEntries = 5;
        byte[] dataBytes = "data".getBytes();
        int numOfLedgers = 3;
        long[] ledgerIds = new long[numOfLedgers];
        for (int i = 0; i < numOfLedgers; ++i) {
            ledgerIds[i] = rand.nextInt(100000) + 1;
            LedgerHandle handle = bkClient.createLedgerAdv(ledgerIds[i], 1, 1, 1, BookKeeper.DigestType.CRC32, "passwd".getBytes(), null);
            for (int j = 0; j < numOfEntries; ++j) {
                handle.addEntry((long)j, dataBytes);
            }
            entryLogManager.createNewLog(ledgerIds[i]);
        }
        Set copyOfCurrentLogsWithDirInfo = entryLogManager.getCopyOfCurrentLogs();
        for (EntryLogManagerForEntryLogPerLedger.BufferedLogChannelWithDirInfo currentLogWithDirInfo : copyOfCurrentLogsWithDirInfo) {
            Assert.assertNotEquals((String)"bytesWrittenSinceLastFlush shouldn't be zero", (long)0L, (long)currentLogWithDirInfo.getLogChannel().getUnpersistedBytes());
        }
        Assert.assertNotEquals((String)"There should be logChannelsToFlush", (long)0L, (long)entryLogManager.getRotatedLogChannels().size());
        this.executorController.advance(Duration.ofMillis(conf.getFlushInterval()));
        List copyOfRotatedLogChannels = entryLogManager.getRotatedLogChannels();
        Assert.assertTrue((String)"There shouldn't be logChannelsToFlush", (copyOfRotatedLogChannels == null || copyOfRotatedLogChannels.size() == 0 ? 1 : 0) != 0);
        copyOfCurrentLogsWithDirInfo = entryLogManager.getCopyOfCurrentLogs();
        for (EntryLogManagerForEntryLogPerLedger.BufferedLogChannelWithDirInfo currentLogWithDirInfo : copyOfCurrentLogsWithDirInfo) {
            Assert.assertEquals((String)"bytesWrittenSinceLastFlush should be zero", (long)0L, (long)currentLogWithDirInfo.getLogChannel().getUnpersistedBytes());
        }
    }

    @Test
    public void testCheckPointForEntryLoggerWithMultipleActiveEntryLogs() throws Exception {
        File[] journalDirs;
        File tmpDir = this.createTempDir("DiskCheck", "test");
        ServerConfiguration conf = ((ServerConfiguration)((ServerConfiguration)TestBKConfiguration.newServerConfiguration().setMetadataServiceUri(this.zkUtil.getMetadataServiceUri())).setZkTimeout(5000)).setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()}).setAutoRecoveryDaemonEnabled(false).setFlushInterval(3000).setBookiePort(PortManager.nextFreePort()).setEntryLogPerLedgerEnabled(true).setLedgerStorageClass(MockInterleavedLedgerStorage.class.getName());
        Assert.assertEquals((String)"Number of JournalDirs", (long)1L, (long)conf.getJournalDirs().length);
        File ledgerDir = BookieImpl.getCurrentDirectories((File[])conf.getLedgerDirs())[0];
        BookieServer server = new BookieServer(conf, (Bookie)new TestBookieImpl(conf), (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, (UncleanShutdownDetection)new MockUncleanShutdownDetection());
        server.start();
        ClientConfiguration clientConf = new ClientConfiguration();
        clientConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper bkClient = new BookKeeper(clientConf);
        int numOfLedgers = 12;
        int numOfEntries = 100;
        byte[] dataBytes = "data".getBytes();
        AtomicBoolean receivedExceptionForAdd = new AtomicBoolean(false);
        LongStream.range(0L, numOfLedgers).parallel().mapToObj(ledgerId -> {
            LedgerHandle handle = null;
            try {
                handle = bkClient.createLedgerAdv(ledgerId, 1, 1, 1, BookKeeper.DigestType.CRC32, "passwd".getBytes(), null);
            }
            catch (InterruptedException | BKException exc) {
                receivedExceptionForAdd.compareAndSet(false, true);
                LOG.error("Got Exception while trying to create LedgerHandle for ledgerId: " + ledgerId, exc);
            }
            return handle;
        }).forEach(writeHandle -> {
            IntStream.range(0, numOfEntries).forEach(entryId -> {
                try {
                    writeHandle.addEntry((long)entryId, dataBytes);
                }
                catch (InterruptedException | BKException exc) {
                    receivedExceptionForAdd.compareAndSet(false, true);
                    LOG.error("Got Exception while trying to AddEntry of ledgerId: " + writeHandle.getId() + " entryId: " + entryId, exc);
                }
            });
            try {
                writeHandle.close();
            }
            catch (InterruptedException | BKException e) {
                receivedExceptionForAdd.compareAndSet(false, true);
                LOG.error("Got Exception while trying to close writeHandle of ledgerId: " + writeHandle.getId(), e);
            }
        });
        Assert.assertFalse((String)"There shouldn't be any exceptions while creating writeHandle and adding entries to writeHandle", (boolean)receivedExceptionForAdd.get());
        this.executorController.advance(Duration.ofMillis(conf.getFlushInterval()));
        File lastMarkFile = new File(ledgerDir, "lastMark");
        Assert.assertTrue((String)"lastMark file must be existing, because checkpoint should have happened", (boolean)lastMarkFile.exists());
        LogMark rolledLogMark = this.readLastMarkFile(lastMarkFile);
        Assert.assertNotEquals((String)"rolledLogMark should not be zero, since checkpoint has happenend", (long)0L, (long)rolledLogMark.compare(new LogMark()));
        bkClient.close();
        server.shutdown();
        for (File journalDir : journalDirs = conf.getJournalDirs()) {
            File journalDirectory = BookieImpl.getCurrentDirectory((File)journalDir);
            List journalLogsId = Journal.listJournalIds((File)journalDirectory, null);
            Iterator iterator = journalLogsId.iterator();
            while (iterator.hasNext()) {
                long journalId = (Long)iterator.next();
                File journalFile = new File(journalDirectory, Long.toHexString(journalId) + ".txn");
                journalFile.delete();
            }
        }
        lastMarkFile = new File(ledgerDir, "lastMark");
        lastMarkFile.delete();
        conf.setLedgerStorageClass(InterleavedLedgerStorage.class.getName());
        server = new BookieServer(conf, (Bookie)new TestBookieImpl(conf), (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, (UncleanShutdownDetection)new MockUncleanShutdownDetection());
        server.start();
        BookKeeper newBKClient = new BookKeeper(clientConf);
        AtomicBoolean receivedExceptionForRead = new AtomicBoolean(false);
        LongStream.range(0L, numOfLedgers).parallel().forEach(ledgerId -> {
            try {
                LedgerHandle lh = newBKClient.openLedger(ledgerId, BookKeeper.DigestType.CRC32, "passwd".getBytes());
                Enumeration entries = lh.readEntries(0L, (long)(numOfEntries - 1));
                while (entries.hasMoreElements()) {
                    LedgerEntry entry = (LedgerEntry)entries.nextElement();
                    byte[] readData = entry.getEntry();
                    Assert.assertEquals((String)"Ledger Entry Data should match", (Object)new String("data".getBytes()), (Object)new String(readData));
                }
                lh.close();
            }
            catch (InterruptedException | BKException e) {
                receivedExceptionForRead.compareAndSet(false, true);
                LOG.error("Got Exception while trying to read entries of ledger, ledgerId: " + ledgerId, e);
            }
        });
        Assert.assertFalse((String)"There shouldn't be any exceptions while creating readHandle and while readingentries using readHandle", (boolean)receivedExceptionForRead.get());
        newBKClient.close();
        server.shutdown();
    }

    static class MockInterleavedLedgerStorage
    extends InterleavedLedgerStorage {
        MockInterleavedLedgerStorage() {
        }

        public void shutdown() {
        }

        public synchronized void flush() throws IOException {
        }
    }
}

