/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.BookieShell;
import org.apache.bookkeeper.bookie.Cookie;
import org.apache.bookkeeper.bookie.LegacyCookieValidation;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.server.Main;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.versioning.Version;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCookieCmdTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateCookieCmdTest.class);
    MetadataBookieDriver driver;
    RegistrationManager rm;
    ServerConfiguration conf;

    public UpdateCookieCmdTest() {
        super(0);
        this.useUUIDasBookieId = false;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        LOG.info("setUp ZKRegistrationManager");
        this.baseConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.driver = MetadataDrivers.getBookieDriver((URI)URI.create(this.baseConf.getMetadataServiceUri()));
        this.driver.initialize(this.baseConf, (StatsLogger)NullStatsLogger.INSTANCE);
        this.rm = this.driver.createRegistrationManager();
        this.conf = this.newServerConfiguration();
        LegacyCookieValidation validation = new LegacyCookieValidation(this.conf, this.rm);
        validation.checkCookies(Main.storageDirectoriesFromConf((ServerConfiguration)this.conf));
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.rm != null) {
            this.rm.close();
        }
        if (this.driver != null) {
            this.driver.close();
        }
    }

    @Test
    public void testUpdateCookieIpAddressToHostname() throws Exception {
        this.updateCookie("-bookieId", "hostname", true);
    }

    @Test
    public void testUpdateCookieIpAddressToShortHostname() throws Exception {
        this.updateCookie("-bookieId", "hostname", true, true);
    }

    @Test
    public void testUpdateCookieHostnameToIpAddress() throws Exception {
        this.updateCookie("-bookieId", "hostname", true);
        this.updateCookie("-b", "ip", false);
        this.conf.setUseHostNameAsBookieID(false);
        LegacyCookieValidation validation = new LegacyCookieValidation(this.conf, this.rm);
        validation.checkCookies(Main.storageDirectoriesFromConf((ServerConfiguration)this.conf));
    }

    @Test
    public void testUpdateCookieWithInvalidOption() throws Exception {
        String[] argv = new String[]{"updatecookie", "-b", "invalidBookieID"};
        ServerConfiguration conf = this.conf;
        this.updateCookie(argv, -1, conf);
        argv = new String[]{"updatecookie", "-b"};
        this.updateCookie(argv, -1, conf);
        argv = new String[]{"updatecookie"};
        this.updateCookie(argv, -1, conf);
        argv = new String[]{"updatecookie", "-b", "hostname"};
        conf.setUseHostNameAsBookieID(false);
        this.updateCookie(argv, -1, conf);
        argv = new String[]{"updatecookie", "-b", "ip"};
        conf.setUseHostNameAsBookieID(true);
        this.updateCookie(argv, -1, conf);
    }

    @Test
    public void testWhenBothIPaddressAndHostNameCookiesExists() throws Exception {
        this.updateCookie("-b", "hostname", true);
        ServerConfiguration conf = this.conf;
        conf.setUseHostNameAsBookieID(true);
        Cookie cookie = (Cookie)Cookie.readFromRegistrationManager((RegistrationManager)this.rm, (ServerConfiguration)conf).getValue();
        Cookie.Builder cookieBuilder = Cookie.newBuilder((Cookie)cookie);
        conf.setUseHostNameAsBookieID(false);
        String newBookieHost = BookieImpl.getBookieAddress((ServerConfiguration)conf).toString();
        cookieBuilder.setBookieId(newBookieHost);
        cookieBuilder.build().writeToRegistrationManager(this.rm, conf, Version.NEW);
        this.verifyCookieInZooKeeper(conf, 2);
        BookieShell bkShell = new BookieShell();
        conf.setUseHostNameAsBookieID(true);
        bkShell.setConf((CompositeConfiguration)conf);
        String[] argv = new String[]{"updatecookie", "-b", "hostname"};
        Assert.assertEquals((String)"Failed to return the error code!", (long)0L, (long)bkShell.run(argv));
        conf.setUseHostNameAsBookieID(true);
        cookie = (Cookie)Cookie.readFromRegistrationManager((RegistrationManager)this.rm, (ServerConfiguration)conf).getValue();
        Assert.assertFalse((String)"Cookie has created with IP!", (boolean)cookie.isBookieHostCreatedFromIp());
        this.verifyCookieInZooKeeper(conf, 1);
    }

    @Test
    public void testDuplicateUpdateCookieIpAddress() throws Exception {
        String[] argv = new String[]{"updatecookie", "-b", "ip"};
        ServerConfiguration conf = this.conf;
        conf.setUseHostNameAsBookieID(true);
        this.updateCookie(argv, -1, conf);
    }

    @Test
    public void testWhenNoCookieExists() throws Exception {
        String zkCookiePath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.conf) + "/" + "cookies" + "/" + BookieImpl.getBookieAddress((ServerConfiguration)this.conf);
        Assert.assertNotNull((String)"Cookie path doesn't still exists!", (Object)this.zkc.exists(zkCookiePath, false));
        this.zkc.delete(zkCookiePath, -1);
        Assert.assertNull((String)"Cookie path still exists!", (Object)this.zkc.exists(zkCookiePath, false));
        BookieShell bkShell = new BookieShell();
        this.conf.setUseHostNameAsBookieID(true);
        bkShell.setConf((CompositeConfiguration)this.conf);
        String[] argv = new String[]{"updatecookie", "-b", "hostname"};
        Assert.assertEquals((String)"Failed to return the error code!", (long)-1L, (long)bkShell.run(argv));
    }

    private void verifyCookieInZooKeeper(ServerConfiguration conf, int expectedCount) throws KeeperException, InterruptedException {
        String bookieCookiePath1 = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)conf) + "/" + "cookies";
        List cookies = this.zkc.getChildren(bookieCookiePath1, false);
        Assert.assertEquals((String)"Wrongly updated the cookie!", (long)expectedCount, (long)cookies.size());
    }

    private void updateCookie(String option, String optionVal, boolean useHostNameAsBookieID) throws Exception {
        this.updateCookie(option, optionVal, useHostNameAsBookieID, false);
    }

    private void updateCookie(String option, String optionVal, boolean useHostNameAsBookieID, boolean useShortHostName) throws Exception {
        File[] ledgerDir;
        this.conf.setUseHostNameAsBookieID(!useHostNameAsBookieID);
        Cookie cookie = (Cookie)Cookie.readFromRegistrationManager((RegistrationManager)this.rm, (ServerConfiguration)this.conf).getValue();
        boolean previousBookieID = cookie.isBookieHostCreatedFromIp();
        Assert.assertEquals((String)"Wrong cookie!", (Object)useHostNameAsBookieID, (Object)previousBookieID);
        LOG.info("Perform updatecookie command");
        ServerConfiguration newconf = new ServerConfiguration((AbstractConfiguration)this.conf);
        newconf.setUseHostNameAsBookieID(useHostNameAsBookieID);
        newconf.setUseShortHostName(useShortHostName);
        BookieShell bkShell = new BookieShell();
        bkShell.setConf((CompositeConfiguration)newconf);
        String[] argv = new String[]{"updatecookie", option, optionVal};
        Assert.assertEquals((String)"Failed to return exit code!", (long)0L, (long)bkShell.run(argv));
        newconf.setUseHostNameAsBookieID(useHostNameAsBookieID);
        newconf.setUseShortHostName(useShortHostName);
        cookie = (Cookie)Cookie.readFromRegistrationManager((RegistrationManager)this.rm, (ServerConfiguration)newconf).getValue();
        Assert.assertEquals((String)"Wrongly updated cookie!", (Object)previousBookieID, (Object)(!cookie.isBookieHostCreatedFromIp() ? 1 : 0));
        Assert.assertEquals((String)"Wrongly updated cookie!", (Object)useHostNameAsBookieID, (Object)(!cookie.isBookieHostCreatedFromIp() ? 1 : 0));
        this.verifyCookieInZooKeeper(newconf, 1);
        for (File journalDir : this.conf.getJournalDirs()) {
            journalDir = BookieImpl.getCurrentDirectory((File)journalDir);
            Cookie jCookie = Cookie.readFromDirectory((File)journalDir);
            jCookie.verify(cookie);
        }
        for (File dir : ledgerDir = BookieImpl.getCurrentDirectories((File[])this.conf.getLedgerDirs())) {
            Cookie lCookie = Cookie.readFromDirectory((File)dir);
            lCookie.verify(cookie);
        }
    }

    private void updateCookie(String[] argv, int exitCode, ServerConfiguration conf) throws KeeperException, InterruptedException, IOException, UnknownHostException, Exception {
        LOG.info("Perform updatecookie command");
        BookieShell bkShell = new BookieShell();
        bkShell.setConf((CompositeConfiguration)conf);
        Assert.assertEquals((String)"Failed to return exit code!", (long)exitCode, (long)bkShell.run(argv));
    }
}

