/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.datainteg;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.bookie.datainteg.DataIntegrityCheck;
import org.apache.bookkeeper.bookie.datainteg.DataIntegrityService;
import org.apache.bookkeeper.bookie.datainteg.MockDataIntegrityCheck;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.Assert;
import org.junit.Test;

public class DataIntegrityServiceTest {
    private static DataIntegrityService newLowIntervalService(DataIntegrityCheck check) {
        return new DataIntegrityService(new BookieConfiguration(new ServerConfiguration()), (StatsLogger)NullStatsLogger.INSTANCE, check){

            public int interval() {
                return 1;
            }

            public TimeUnit intervalUnit() {
                return TimeUnit.MICROSECONDS;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFullCheckRunsIfRequested() throws Exception {
        final CompletableFuture promise = new CompletableFuture();
        MockDataIntegrityCheck check = new MockDataIntegrityCheck(){

            @Override
            public boolean needsFullCheck() {
                return true;
            }

            @Override
            public CompletableFuture<Void> runFullCheck() {
                promise.complete(null);
                return super.runFullCheck();
            }
        };
        DataIntegrityService service = DataIntegrityServiceTest.newLowIntervalService(check);
        try {
            service.start();
            promise.get(5L, TimeUnit.SECONDS);
        }
        finally {
            service.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFullCheckDoesntRunIfNotRequested() throws Exception {
        final CompletableFuture promise = new CompletableFuture();
        MockDataIntegrityCheck check = new MockDataIntegrityCheck(){

            @Override
            public boolean needsFullCheck() {
                return false;
            }

            @Override
            public CompletableFuture<Void> runFullCheck() {
                promise.complete(null);
                return super.runFullCheck();
            }
        };
        DataIntegrityService service = DataIntegrityServiceTest.newLowIntervalService(check);
        try {
            service.start();
            try {
                promise.get(100L, TimeUnit.MILLISECONDS);
                Assert.fail((String)"Shouldn't have run");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
        finally {
            service.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFullCheckRunsMultipleTimes() throws Exception {
        final AtomicInteger count = new AtomicInteger(0);
        final CompletableFuture promise = new CompletableFuture();
        MockDataIntegrityCheck check = new MockDataIntegrityCheck(){

            @Override
            public boolean needsFullCheck() {
                return true;
            }

            @Override
            public CompletableFuture<Void> runFullCheck() {
                if (count.incrementAndGet() == 10) {
                    promise.complete(null);
                }
                return super.runFullCheck();
            }
        };
        DataIntegrityService service = DataIntegrityServiceTest.newLowIntervalService(check);
        try {
            service.start();
            promise.get(10L, TimeUnit.SECONDS);
        }
        finally {
            service.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRunDontRunThenRunAgain() throws Exception {
        final AtomicBoolean needsFullCheck = new AtomicBoolean(true);
        final Semaphore semaphore = new Semaphore(1);
        semaphore.acquire();
        MockDataIntegrityCheck check = new MockDataIntegrityCheck(){

            @Override
            public boolean needsFullCheck() {
                return needsFullCheck.getAndSet(false);
            }

            @Override
            public CompletableFuture<Void> runFullCheck() {
                semaphore.release();
                return super.runFullCheck();
            }
        };
        DataIntegrityService service = DataIntegrityServiceTest.newLowIntervalService(check);
        try {
            service.start();
            Assert.assertTrue((String)"Check should have run", (boolean)semaphore.tryAcquire(10L, TimeUnit.SECONDS));
            Assert.assertFalse((String)"Check shouldn't run again", (boolean)semaphore.tryAcquire(100L, TimeUnit.MILLISECONDS));
            needsFullCheck.set(true);
            Assert.assertTrue((String)"Check should run again", (boolean)semaphore.tryAcquire(10L, TimeUnit.SECONDS));
        }
        finally {
            service.stop();
        }
    }
}

