/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.directentrylogger;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import org.apache.bookkeeper.bookie.storage.directentrylogger.Buffer;
import org.apache.bookkeeper.common.util.nativeio.NativeIO;
import org.apache.bookkeeper.common.util.nativeio.NativeIOImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestBuffer {
    @Test
    public void testIsAligned() throws Exception {
        Assert.assertFalse((boolean)Buffer.isAligned((long)1234L));
        Assert.assertTrue((boolean)Buffer.isAligned((long)4096L));
        Assert.assertTrue((boolean)Buffer.isAligned((long)40960L));
        Assert.assertTrue((boolean)Buffer.isAligned((long)0x100000L));
        Assert.assertFalse((boolean)Buffer.isAligned((long)-1L));
        Assert.assertFalse((boolean)Buffer.isAligned((long)Integer.MAX_VALUE));
        Assert.assertFalse((boolean)Buffer.isAligned((long)Integer.MIN_VALUE));
    }

    @Test
    public void testNextAlignment() throws Exception {
        Assert.assertEquals((long)0L, (long)Buffer.nextAlignment((int)0));
        Assert.assertEquals((long)4096L, (long)Buffer.nextAlignment((int)1));
        Assert.assertEquals((long)4096L, (long)Buffer.nextAlignment((int)4096));
        Assert.assertEquals((long)8192L, (long)Buffer.nextAlignment((int)4097));
        Assert.assertEquals((long)0x7FFFF000L, (long)Buffer.nextAlignment((int)0x7FFFF000));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativePosition() throws Exception {
        Buffer.nextAlignment((int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMaxAlignment() throws Exception {
        Buffer.nextAlignment((int)Integer.MAX_VALUE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateUnaligned() throws Exception {
        new Buffer((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 1234);
    }

    @Test
    public void testWriteInt() throws Exception {
        int i;
        int bufferSize = 0x100000;
        Buffer b = new Buffer((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, bufferSize);
        Assert.assertTrue((boolean)b.hasSpace(bufferSize));
        Assert.assertEquals((long)0L, (long)b.position());
        b.writeInt(-559038737);
        Assert.assertEquals((long)-34L, (long)PlatformDependent.getByte((long)(b.pointer() + 0L)));
        Assert.assertEquals((long)-83L, (long)PlatformDependent.getByte((long)(b.pointer() + 1L)));
        Assert.assertEquals((long)-66L, (long)PlatformDependent.getByte((long)(b.pointer() + 2L)));
        Assert.assertEquals((long)-17L, (long)PlatformDependent.getByte((long)(b.pointer() + 3L)));
        Assert.assertFalse((boolean)b.hasSpace(bufferSize));
        Assert.assertEquals((long)4L, (long)b.position());
        for (i = 0; i < 10000; ++i) {
            b.writeInt(i);
        }
        Assert.assertEquals((long)40004L, (long)b.position());
        Assert.assertTrue((boolean)b.hasSpace(bufferSize - 40004));
        Assert.assertFalse((boolean)b.hasSpace(bufferSize - 40000));
        Assert.assertEquals((long)-559038737L, (long)b.readInt(0));
        for (i = 0; i < 10000; ++i) {
            Assert.assertEquals((long)i, (long)b.readInt((i + 1) * 4));
        }
        b.reset();
        Assert.assertTrue((boolean)b.hasSpace(bufferSize));
        Assert.assertEquals((long)0L, (long)b.position());
    }

    @Test
    public void testWriteBuffer() throws Exception {
        int i;
        ByteBuf bb = Unpooled.buffer((int)1021);
        TestBuffer.fillByteBuf(bb, -559038737);
        int bufferSize = 0x100000;
        Buffer b = new Buffer((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, bufferSize);
        Assert.assertEquals((long)0L, (long)b.position());
        b.writeByteBuf(bb);
        Assert.assertEquals((long)1021L, (long)b.position());
        Assert.assertEquals((long)0L, (long)bb.readableBytes());
        bb.clear();
        TestBuffer.fillByteBuf(bb, -889271554);
        b.writeByteBuf(bb);
        Assert.assertEquals((long)0L, (long)bb.readableBytes());
        Assert.assertEquals((long)2042L, (long)b.position());
        bb = Unpooled.buffer((int)2042);
        int ret = b.readByteBuf(bb, 0, 2042);
        Assert.assertEquals((long)2042L, (long)ret);
        for (i = 0; i < 255; ++i) {
            Assert.assertEquals((long)-559038737L, (long)bb.readInt());
        }
        Assert.assertEquals((long)-34L, (long)bb.readByte());
        for (i = 0; i < 255; ++i) {
            Assert.assertEquals((long)-889271554L, (long)bb.readInt());
        }
    }

    @Test
    public void testPartialRead() throws Exception {
        ByteBuf bb = Unpooled.buffer((int)5000);
        Buffer b = new Buffer((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 4096);
        for (int i = 0; i < 1024; ++i) {
            b.writeInt(-559038737);
        }
        int ret = b.readByteBuf(bb, 0, 5000);
        Assert.assertEquals((long)4096L, (long)ret);
    }

    @Test(expected=IOException.class)
    public void testReadIntAtBoundary() throws Exception {
        Buffer b = new Buffer((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 4096);
        for (int i = 0; i < 1024; ++i) {
            b.writeInt(-559038737);
        }
        Assert.assertTrue((boolean)b.hasData(4092, 4));
        Assert.assertFalse((boolean)b.hasData(4093, 4));
        Assert.assertFalse((boolean)b.hasData(4096, 4));
        b.readInt(4094);
    }

    @Test(expected=IOException.class)
    public void testReadLongAtBoundary() throws Exception {
        Buffer b = new Buffer((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 4096);
        for (int i = 0; i < 1024; ++i) {
            b.writeInt(-559038737);
        }
        Assert.assertTrue((boolean)b.hasData(4088, 8));
        Assert.assertFalse((boolean)b.hasData(4089, 8));
        Assert.assertFalse((boolean)b.hasData(4096, 8));
        b.readInt(4094);
    }

    @Test
    public void testPadToAlignment() throws Exception {
        Buffer b = new Buffer((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 0x800000);
        for (int i = 0; i < 1025; ++i) {
            b.writeInt(-555819298);
        }
        int writtenLength = b.padToAlignment();
        Assert.assertEquals((long)8192L, (long)writtenLength);
        Assert.assertEquals((long)-555819298L, (long)b.readInt(4096));
        for (int i = 4100; i < writtenLength; i += 4) {
            Assert.assertEquals((long)-252645136L, (long)b.readInt(i));
        }
        Assert.assertEquals((long)0L, (long)b.readInt(writtenLength));
    }

    @Test
    public void testFree() throws Exception {
        Buffer b = new Buffer((NativeIO)new NativeIOImpl(), ByteBufAllocator.DEFAULT, 0x800000);
        b.free();
        b.free();
    }

    static void fillByteBuf(ByteBuf bb, int value) {
        while (bb.writableBytes() >= 4) {
            bb.writeInt(value);
        }
        for (int i = 0; i < 4 && bb.writableBytes() > 0; ++i) {
            byte b = (byte)(value >> (4 - i - 1) * 8);
            bb.writeByte((int)b);
        }
    }
}

