/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.util.List;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.DefaultEntryLogger;
import org.apache.bookkeeper.bookie.TestBookieImpl;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorageStats;
import org.apache.bookkeeper.bookie.storage.ldb.SingleDirectoryDbLedgerStorage;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbLedgerStorageReadCacheTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbLedgerStorageReadCacheTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void chargeReadAheadCacheRegressionTest() {
        TestDB testDB = new TestDB();
        try {
            long readAheadCacheMaxSizeMb = 16L;
            int readAheadCacheBatchSize = 1024;
            long readAheadCacheBatchBytesSize = -1L;
            this.setup(testDB, readAheadCacheMaxSizeMb, readAheadCacheBatchSize, readAheadCacheBatchBytesSize);
            SingleDirectoryDbLedgerStorage sdb = (SingleDirectoryDbLedgerStorage)testDB.getStorage().getLedgerStorageList().get(0);
            int currentReadAheadCount = 1;
            long currentReadAheadBytes = 1L;
            Assert.assertTrue((boolean)sdb.chargeReadAheadCache(currentReadAheadCount, currentReadAheadBytes));
            currentReadAheadCount = readAheadCacheBatchSize + 1;
            currentReadAheadBytes = 1L;
            Assert.assertFalse((boolean)sdb.chargeReadAheadCache(currentReadAheadCount, currentReadAheadBytes));
            currentReadAheadCount = 1;
            currentReadAheadBytes = readAheadCacheMaxSizeMb / 2L * 1024L * 1024L + 1L;
            Assert.assertFalse((boolean)sdb.chargeReadAheadCache(currentReadAheadCount, currentReadAheadBytes));
        }
        catch (Throwable e) {
            LOGGER.error("readAheadCacheBatchSizeUnitTest run error", e);
        }
        finally {
            this.teardown(testDB.getStorage(), testDB.getTmpDir());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void chargeReadAheadCacheUnitTest() {
        TestDB testDB = new TestDB();
        try {
            long readAheadCacheMaxSizeMb = 16L;
            int readAheadCacheBatchSize = 1024;
            long readAheadCacheBatchBytesSize = 0x200000L;
            this.setup(testDB, readAheadCacheMaxSizeMb, readAheadCacheBatchSize, readAheadCacheBatchBytesSize);
            SingleDirectoryDbLedgerStorage sdb = (SingleDirectoryDbLedgerStorage)testDB.getStorage().getLedgerStorageList().get(0);
            int currentReadAheadCount = 1;
            long currentReadAheadBytes = 1L;
            Assert.assertTrue((boolean)sdb.chargeReadAheadCache(currentReadAheadCount, currentReadAheadBytes));
            currentReadAheadCount = readAheadCacheBatchSize + 1;
            currentReadAheadBytes = 1L;
            Assert.assertFalse((boolean)sdb.chargeReadAheadCache(currentReadAheadCount, currentReadAheadBytes));
            currentReadAheadCount = 1;
            currentReadAheadBytes = readAheadCacheBatchBytesSize + 1L;
            Assert.assertFalse((boolean)sdb.chargeReadAheadCache(currentReadAheadCount, currentReadAheadBytes));
        }
        catch (Throwable e) {
            LOGGER.error("readAheadCacheBatchSizeUnitTest run error", e);
        }
        finally {
            this.teardown(testDB.getStorage(), testDB.getTmpDir());
        }
    }

    @Test
    public void compareDiffReadAheadPerfTest() {
        CacheResult cacheBatchBytesSizeResult = this.readAheadCacheBatchBytesSize();
        CacheResult cacheBatchSizeResult = this.readAheadCacheBatchSize();
        Assert.assertEquals((long)8L, (long)cacheBatchBytesSizeResult.getCacheMissCount());
        Assert.assertEquals((long)132L, (long)cacheBatchSizeResult.getCacheMissCount());
        Assert.assertTrue((cacheBatchBytesSizeResult.getCacheMissCount() < cacheBatchSizeResult.getCacheMissCount() ? 1 : 0) != 0);
        Assert.assertEquals((long)(cacheBatchBytesSizeResult.getCacheMissCount() + cacheBatchBytesSizeResult.getCacheHitCount()), (long)(cacheBatchSizeResult.getCacheMissCount() + cacheBatchSizeResult.getCacheHitCount()));
    }

    public void setup(TestDB testDB, long readAheadCacheMaxSizeMb, int readAheadCacheBatchSize, long readAheadCacheBatchBytesSize) throws Exception {
        File tmpDir = File.createTempFile("bkTest", ".dir");
        tmpDir.delete();
        tmpDir.mkdir();
        File curDir = BookieImpl.getCurrentDirectory((File)tmpDir);
        BookieImpl.checkDirectoryStructure((File)curDir);
        int gcWaitTime = 1000;
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setGcWaitTime((long)gcWaitTime);
        conf.setLedgerStorageClass(DbLedgerStorage.class.getName());
        conf.setLedgerDirNames(new String[]{tmpDir.toString()});
        if (readAheadCacheMaxSizeMb > 0L) {
            conf.setProperty("dbStorage_readAheadCacheMaxSizeMb", (Object)readAheadCacheMaxSizeMb);
        }
        if (readAheadCacheBatchSize > 0) {
            conf.setProperty("dbStorage_readAheadCacheBatchSize", (Object)readAheadCacheBatchSize);
        }
        if (readAheadCacheBatchBytesSize > 0L) {
            conf.setProperty("dbStorage_readAheadCacheBatchBytesSize", (Object)readAheadCacheBatchBytesSize);
        }
        TestStatsProvider.TestStatsLogger statsLogger = new TestStatsProvider().getStatsLogger("test");
        TestBookieImpl bookie = new TestBookieImpl(new TestBookieImpl.ResourceBuilder(conf).build((StatsLogger)statsLogger), (StatsLogger)statsLogger);
        DbLedgerStorage storage = (DbLedgerStorage)bookie.getLedgerStorage();
        storage.getLedgerStorageList().forEach(singleDirectoryDbLedgerStorage -> Assert.assertTrue((boolean)(singleDirectoryDbLedgerStorage.getEntryLogger() instanceof DefaultEntryLogger)));
        testDB.setStorage(storage);
        testDB.setTmpDir(tmpDir);
    }

    public void teardown(DbLedgerStorage storage, File tmpDir) {
        if (storage != null) {
            try {
                storage.shutdown();
            }
            catch (InterruptedException e) {
                LOGGER.error("storage.shutdown has error", (Throwable)e);
            }
        }
        if (tmpDir != null) {
            tmpDir.delete();
        }
    }

    private void addEntries(DbLedgerStorage storage, long minLedgerId, long maxLedgerId, long minEntryId, long maxEntryId) throws Exception {
        for (long lid = minLedgerId; lid < maxLedgerId; ++lid) {
            long lac = 0L;
            for (long eid = minEntryId; eid < maxEntryId; ++eid) {
                ByteBuf entry = Unpooled.buffer((int)1024);
                entry.writeLong(lid);
                entry.writeLong(eid);
                entry.writeLong(lac);
                entry.writeBytes(this.get4KbMsg().getBytes());
                Assert.assertEquals((long)eid, (long)storage.addEntry(entry));
                ++lac;
            }
        }
    }

    private String get4KbMsg() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 1024; ++i) {
            buffer.append("1234");
        }
        Assert.assertEquals((long)4096L, (long)buffer.toString().length());
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheResult readAheadCacheBatchBytesSize() {
        TestDB testDB = new TestDB();
        try {
            long readAheadCacheMaxSizeMb = 16L;
            int readAheadCacheBatchSize = 1024;
            long readAheadCacheBatchBytesSize = 0x200000L;
            long minEntryId = 0L;
            long maxEntryId = 1024L;
            this.setup(testDB, readAheadCacheMaxSizeMb, readAheadCacheBatchSize, readAheadCacheBatchBytesSize);
            this.addEntries(testDB.getStorage(), 0L, 4L, minEntryId, maxEntryId);
            testDB.getStorage().flush();
            Assert.assertEquals((Object)false, (Object)testDB.getStorage().isFlushRequired());
            for (long eid = minEntryId; eid < maxEntryId / 2L; ++eid) {
                testDB.getStorage().getEntry(0L, eid);
                testDB.getStorage().getEntry(1L, eid);
                testDB.getStorage().getEntry(2L, eid);
                testDB.getStorage().getEntry(3L, eid);
            }
            List ledgerStorageList = testDB.getStorage().getLedgerStorageList();
            DbLedgerStorageStats ledgerStats = ((SingleDirectoryDbLedgerStorage)ledgerStorageList.get(0)).getDbLedgerStorageStats();
            Long cacheMissCount = ledgerStats.getReadCacheMissCounter().get();
            Long cacheHitCount = ledgerStats.getReadCacheHitCounter().get();
            LOGGER.info("simple1.cacheMissCount={},cacheHitCount={}", (Object)cacheMissCount, (Object)cacheHitCount);
            CacheResult cacheResult = new CacheResult(cacheMissCount, cacheHitCount);
            return cacheResult;
        }
        catch (Throwable e) {
            LOGGER.error("test case run error", e);
            CacheResult cacheResult = new CacheResult(0L, 0L);
            return cacheResult;
        }
        finally {
            this.teardown(testDB.getStorage(), testDB.getTmpDir());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheResult readAheadCacheBatchSize() {
        TestDB testDB = new TestDB();
        try {
            long readAheadCacheMaxSizeMb = 16L;
            int readAheadCacheBatchSize = 1024;
            long readAheadCacheBatchBytesSize = -1L;
            long minEntryId = 0L;
            long maxEntryId = 1024L;
            this.setup(testDB, readAheadCacheMaxSizeMb, readAheadCacheBatchSize, readAheadCacheBatchBytesSize);
            this.addEntries(testDB.getStorage(), 0L, 4L, minEntryId, maxEntryId);
            testDB.getStorage().flush();
            Assert.assertEquals((Object)false, (Object)testDB.getStorage().isFlushRequired());
            for (long eid = minEntryId; eid < maxEntryId / 2L; ++eid) {
                testDB.getStorage().getEntry(0L, eid);
                testDB.getStorage().getEntry(1L, eid);
                testDB.getStorage().getEntry(2L, eid);
                testDB.getStorage().getEntry(3L, eid);
            }
            List ledgerStorageList = testDB.getStorage().getLedgerStorageList();
            DbLedgerStorageStats ledgerStats = ((SingleDirectoryDbLedgerStorage)ledgerStorageList.get(0)).getDbLedgerStorageStats();
            Long cacheMissCount = ledgerStats.getReadCacheMissCounter().get();
            Long cacheHitCount = ledgerStats.getReadCacheHitCounter().get();
            LOGGER.info("simple2.cacheMissCount={},cacheHitCount={}", (Object)cacheMissCount, (Object)cacheHitCount);
            CacheResult cacheResult = new CacheResult(cacheMissCount, cacheHitCount);
            return cacheResult;
        }
        catch (Throwable e) {
            LOGGER.error("test case run error", e);
            CacheResult cacheResult = new CacheResult(0L, 0L);
            return cacheResult;
        }
        finally {
            this.teardown(testDB.getStorage(), testDB.getTmpDir());
        }
    }

    private class CacheResult {
        private long cacheMissCount;
        private long cacheHitCount;

        private CacheResult(long cacheMissCount, long cacheHitCount) {
            this.cacheMissCount = cacheMissCount;
            this.cacheHitCount = cacheHitCount;
        }

        public long getCacheMissCount() {
            return this.cacheMissCount;
        }

        public void setCacheMissCount(long cacheMissCount) {
            this.cacheMissCount = cacheMissCount;
        }

        public long getCacheHitCount() {
            return this.cacheHitCount;
        }

        public void setCacheHitCount(long cacheHitCount) {
            this.cacheHitCount = cacheHitCount;
        }
    }

    private class TestDB {
        private DbLedgerStorage storage;
        private File tmpDir;

        private TestDB() {
        }

        public DbLedgerStorage getStorage() {
            return this.storage;
        }

        public void setStorage(DbLedgerStorage storage) {
            this.storage = storage;
        }

        public File getTmpDir() {
            return this.tmpDir;
        }

        public void setTmpDir(File tmpDir) {
            this.tmpDir = tmpDir;
        }
    }
}

