/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.bookkeeper.bookie.storage.ldb.ArrayUtil;
import org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorage;
import org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageFactory;
import org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageRocksDB;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class KeyValueStorageTest {
    private final KeyValueStorageFactory storageFactory;
    private final ServerConfiguration configuration;

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        return Arrays.asList(new Object[][]{{KeyValueStorageRocksDB.factory}});
    }

    public KeyValueStorageTest(KeyValueStorageFactory storageFactory) {
        this.storageFactory = storageFactory;
        this.configuration = new ServerConfiguration();
    }

    private static long fromArray(byte[] array) {
        return ArrayUtil.getLong((byte[])array, (int)0);
    }

    private static byte[] toArray(long n) {
        byte[] b = new byte[8];
        ArrayUtil.setLong((byte[])b, (int)0, (long)n);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void simple() throws Exception {
        File tmpDir = Files.createTempDirectory("junitTemporaryFolder", new FileAttribute[0]).toFile();
        Files.createDirectory(Paths.get(tmpDir.toString(), "subDir"), new FileAttribute[0]);
        KeyValueStorage db = this.storageFactory.newKeyValueStorage(tmpDir.toString(), "subDir", KeyValueStorageFactory.DbConfigType.Default, this.configuration);
        Assert.assertEquals(null, (Object)db.getFloor(KeyValueStorageTest.toArray(3L)));
        Assert.assertEquals((long)0L, (long)db.count());
        db.put(KeyValueStorageTest.toArray(5L), KeyValueStorageTest.toArray(5L));
        Assert.assertEquals(null, (Object)db.getFloor(KeyValueStorageTest.toArray(3L)));
        Assert.assertEquals((long)1L, (long)db.count());
        Assert.assertEquals(null, (Object)db.getFloor(KeyValueStorageTest.toArray(5L)));
        Assert.assertEquals((long)5L, (long)KeyValueStorageTest.fromArray((byte[])db.getFloor(KeyValueStorageTest.toArray(6L)).getKey()));
        db.put(KeyValueStorageTest.toArray(3L), KeyValueStorageTest.toArray(3L));
        Assert.assertEquals(null, (Object)db.getFloor(KeyValueStorageTest.toArray(3L)));
        Assert.assertEquals((long)2L, (long)db.count());
        db.put(KeyValueStorageTest.toArray(5L), KeyValueStorageTest.toArray(5L));
        Assert.assertTrue((db.count() > 0L ? 1 : 0) != 0);
        Assert.assertEquals(null, (Object)db.getFloor(KeyValueStorageTest.toArray(1L)));
        Assert.assertEquals(null, (Object)db.getFloor(KeyValueStorageTest.toArray(3L)));
        Assert.assertEquals((long)3L, (long)KeyValueStorageTest.fromArray((byte[])db.getFloor(KeyValueStorageTest.toArray(5L)).getKey()));
        Assert.assertEquals((long)5L, (long)KeyValueStorageTest.fromArray((byte[])db.getFloor(KeyValueStorageTest.toArray(6L)).getKey()));
        Assert.assertEquals((long)5L, (long)KeyValueStorageTest.fromArray((byte[])db.getFloor(KeyValueStorageTest.toArray(10L)).getKey()));
        ArrayList foundKeys = Lists.newArrayList();
        try (KeyValueStorage.CloseableIterator iter = db.iterator();){
            while (iter.hasNext()) {
                foundKeys.add(KeyValueStorageTest.fromArray((byte[])((Map.Entry)iter.next()).getKey()));
            }
        }
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Long[]{3L, 5L}), (Object)foundKeys);
        foundKeys = Lists.newArrayList();
        try (KeyValueStorage.CloseableIterator iter2 = db.keys();){
            while (iter2.hasNext()) {
                foundKeys.add(KeyValueStorageTest.fromArray((byte[])iter2.next()));
            }
        }
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Long[]{3L, 5L}), (Object)foundKeys);
        foundKeys = Lists.newArrayList();
        iter2 = db.keys(KeyValueStorageTest.toArray(1L), KeyValueStorageTest.toArray(4L));
        try {
            while (iter2.hasNext()) {
                foundKeys.add(KeyValueStorageTest.fromArray((byte[])iter2.next()));
            }
        }
        finally {
            iter2.close();
        }
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Long[]{3L}), (Object)foundKeys);
        db.put(KeyValueStorageTest.toArray(10L), KeyValueStorageTest.toArray(10L));
        db.put(KeyValueStorageTest.toArray(11L), KeyValueStorageTest.toArray(11L));
        db.put(KeyValueStorageTest.toArray(12L), KeyValueStorageTest.toArray(12L));
        db.put(KeyValueStorageTest.toArray(14L), KeyValueStorageTest.toArray(14L));
        Assert.assertTrue((db.count() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)10L, (long)KeyValueStorageTest.fromArray(db.get(KeyValueStorageTest.toArray(10L))));
        db.delete(KeyValueStorageTest.toArray(10L));
        Assert.assertEquals(null, (Object)db.get(KeyValueStorageTest.toArray(10L)));
        Assert.assertTrue((db.count() > 0L ? 1 : 0) != 0);
        KeyValueStorage.Batch batch = db.newBatch();
        batch.remove(KeyValueStorageTest.toArray(11L));
        batch.remove(KeyValueStorageTest.toArray(12L));
        batch.remove(KeyValueStorageTest.toArray(13L));
        batch.flush();
        Assert.assertEquals(null, (Object)db.get(KeyValueStorageTest.toArray(11L)));
        Assert.assertEquals(null, (Object)db.get(KeyValueStorageTest.toArray(12L)));
        Assert.assertEquals(null, (Object)db.get(KeyValueStorageTest.toArray(13L)));
        Assert.assertEquals((long)14L, (long)KeyValueStorageTest.fromArray(db.get(KeyValueStorageTest.toArray(14L))));
        batch.close();
        db.close();
        FileUtils.deleteDirectory((File)tmpDir);
    }

    @Test
    public void testBatch() throws Exception {
        this.configuration.setOperationMaxNumbersInSingleRocksDBWriteBatch(5);
        File tmpDir = Files.createTempDirectory("junitTemporaryFolder", new FileAttribute[0]).toFile();
        Files.createDirectory(Paths.get(tmpDir.toString(), "subDir"), new FileAttribute[0]);
        KeyValueStorage db = this.storageFactory.newKeyValueStorage(tmpDir.toString(), "subDir", KeyValueStorageFactory.DbConfigType.Default, this.configuration);
        Assert.assertEquals(null, (Object)db.getFloor(KeyValueStorageTest.toArray(3L)));
        Assert.assertEquals((long)0L, (long)db.count());
        KeyValueStorage.Batch batch = db.newBatch();
        Assert.assertEquals((long)0L, (long)batch.batchCount());
        batch.put(KeyValueStorageTest.toArray(1L), KeyValueStorageTest.toArray(1L));
        batch.put(KeyValueStorageTest.toArray(2L), KeyValueStorageTest.toArray(2L));
        Assert.assertEquals((long)2L, (long)batch.batchCount());
        batch.put(KeyValueStorageTest.toArray(3L), KeyValueStorageTest.toArray(3L));
        batch.put(KeyValueStorageTest.toArray(4L), KeyValueStorageTest.toArray(4L));
        batch.put(KeyValueStorageTest.toArray(5L), KeyValueStorageTest.toArray(5L));
        Assert.assertEquals((long)0L, (long)batch.batchCount());
        batch.put(KeyValueStorageTest.toArray(6L), KeyValueStorageTest.toArray(6L));
        Assert.assertEquals((long)1L, (long)batch.batchCount());
        batch.flush();
        Assert.assertEquals((long)1L, (long)batch.batchCount());
        batch.close();
        Assert.assertEquals((long)0L, (long)batch.batchCount());
        db.close();
        FileUtils.deleteDirectory((File)tmpDir);
    }
}

