/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.collect.Lists;
import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.TestBookieImpl;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperTestClient;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerHandleAdv;
import org.apache.bookkeeper.client.PendingAddOp;
import org.apache.bookkeeper.client.SyncCallbackUtils;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.api.WriteAdvHandle;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.LongHierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.replication.ReplicationTestUtil;
import org.apache.bookkeeper.replication.ReplicationWorker;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.commons.lang3.tuple.Pair;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.powermock.reflect.Whitebox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class BookieWriteLedgerTest
extends BookKeeperClusterTestCase
implements AsyncCallback.AddCallback {
    private static final Logger LOG = LoggerFactory.getLogger(BookieWriteLedgerTest.class);
    @Parameterized.Parameter(value=0)
    public boolean useV2;
    @Parameterized.Parameter(value=1)
    public boolean writeJournal;
    byte[] ledgerPassword = "aaa".getBytes();
    LedgerHandle lh;
    LedgerHandle lh2;
    Enumeration<LedgerEntry> ls;
    int numEntriesToWrite = 100;
    int maxInt = Integer.MAX_VALUE;
    Random rng;
    ArrayList<byte[]> entries1;
    ArrayList<byte[]> entries2;
    private final BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({true, true}, {true, false}, {false, true}, {false, false});
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rng = new Random(0L);
        this.entries1 = new ArrayList();
        this.entries2 = new ArrayList();
    }

    public BookieWriteLedgerTest() {
        super(5, 180);
        String ledgerManagerFactory = "org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory";
        this.baseConf.setLedgerManagerFactoryClassName(ledgerManagerFactory);
        this.baseConf.setJournalWriteData(this.writeJournal);
        this.baseConf.setSkipListSizeLimit(0x400000);
        this.baseClientConf.setLedgerManagerFactoryClassName(ledgerManagerFactory);
        this.baseClientConf.setUseV2WireProtocol(this.useV2);
    }

    @Test
    public void testWithMultipleBookieFailuresInLastEnsemble() throws Exception {
        this.lh = this.bkc.createLedger(5, 4, this.digestType, this.ledgerPassword);
        LOG.info("Ledger ID: " + this.lh.getId());
        for (int i = 0; i < this.numEntriesToWrite; ++i) {
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.entries1.add(entry.array());
            this.lh.addEntry(entry.array());
        }
        this.startNewBookie();
        this.startNewBookie();
        this.startNewBookie();
        List ensemble = (List)this.lh.getLedgerMetadata().getAllEnsembles().entrySet().iterator().next().getValue();
        this.killBookie((BookieId)ensemble.get(0));
        this.killBookie((BookieId)ensemble.get(1));
        this.killBookie((BookieId)ensemble.get(2));
        this.numEntriesToWrite += 50;
        for (int i = this.numEntriesToWrite; i < this.numEntriesToWrite; ++i) {
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.entries1.add(entry.array());
            this.lh.addEntry(entry.array());
        }
        this.readEntries(this.lh, this.entries1);
        this.lh.close();
    }

    @Test
    public void testWriteAndReadStats() throws Exception {
        ByteBuffer entry;
        int i;
        this.lh = this.bkc.createLedger(3, 3, 2, this.digestType, this.ledgerPassword);
        for (int i2 = 0; i2 < this.numEntriesToWrite; ++i2) {
            ByteBuffer entry2 = ByteBuffer.allocate(4);
            entry2.putInt(this.rng.nextInt(this.maxInt));
            entry2.position(0);
            this.entries1.add(entry2.array());
            this.lh.addEntry(entry2.array());
        }
        Assert.assertTrue((String)"Stats should have captured a new writes", (this.bkc.getTestStatsProvider().getOpStatsLogger("bookkeeper_client.ADD_ENTRY").getSuccessCount() > 0L ? 1 : 0) != 0);
        CountDownLatch sleepLatch1 = new CountDownLatch(1);
        CountDownLatch sleepLatch2 = new CountDownLatch(1);
        List ensemble = (List)this.lh.getLedgerMetadata().getAllEnsembles().entrySet().iterator().next().getValue();
        this.sleepBookie((BookieId)ensemble.get(0), sleepLatch1);
        this.numEntriesToWrite += 50;
        for (i = this.numEntriesToWrite; i < this.numEntriesToWrite; ++i) {
            entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.entries1.add(entry.array());
            this.lh.addEntry(entry.array());
        }
        this.sleepBookie((BookieId)ensemble.get(1), sleepLatch2);
        this.numEntriesToWrite += 50;
        for (i = this.numEntriesToWrite; i < this.numEntriesToWrite; ++i) {
            entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.entries1.add(entry.array());
            this.lh.addEntry(entry.array());
        }
        Assert.assertTrue((String)"Stats should have captured a new UnderReplication during write", (this.bkc.getTestStatsProvider().getCounter("bookkeeper_client.ADD_ENTRY_UR").get() > 0L ? 1 : 0) != 0);
        sleepLatch1.countDown();
        sleepLatch2.countDown();
        ServerConfiguration conf = this.killBookie((BookieId)ensemble.get(0));
        CorruptReadBookie corruptBookie = new CorruptReadBookie(conf);
        this.startAndAddBookie(conf, (Bookie)corruptBookie);
        this.numEntriesToWrite += 50;
        for (i = this.numEntriesToWrite; i < this.numEntriesToWrite; ++i) {
            ByteBuffer entry3 = ByteBuffer.allocate(4);
            entry3.putInt(this.rng.nextInt(this.maxInt));
            entry3.position(0);
            this.entries1.add(entry3.array());
            this.lh.addEntry(entry3.array());
        }
        this.readEntries(this.lh, this.entries1);
        Assert.assertTrue((String)"Stats should have captured DigestMismatch on Read", (this.bkc.getTestStatsProvider().getCounter("bookkeeper_client.READ_ENTRY_DM").get() > 0L ? 1 : 0) != 0);
        this.lh.close();
    }

    @Test
    public void testDelayedWriteEnsembleChange() throws Exception {
        ByteBuffer entry;
        this.lh = this.bkc.createLedger(3, 3, 2, this.digestType, this.ledgerPassword);
        this.baseClientConf.setAddEntryTimeout(1);
        int numEntriesToWrite = 10;
        for (int i = 0; i < numEntriesToWrite; ++i) {
            ByteBuffer entry2 = ByteBuffer.allocate(4);
            entry2.putInt(this.rng.nextInt(this.maxInt));
            entry2.position(0);
            this.entries1.add(entry2.array());
            this.lh.addEntry(entry2.array());
        }
        CountDownLatch sleepLatch1 = new CountDownLatch(1);
        BookieId bookie1 = (BookieId)this.lh.getCurrentEnsemble().get(0);
        this.sleepBookie(bookie1, sleepLatch1);
        int i = numEntriesToWrite;
        numEntriesToWrite += 10;
        while (i < numEntriesToWrite) {
            entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.entries1.add(entry.array());
            this.lh.addEntry(entry.array());
            ++i;
        }
        Thread.sleep(this.baseClientConf.getAddEntryTimeout() * 1000 * 2);
        Assert.assertTrue((String)"Stats should have captured a new UnderReplication during write", (this.bkc.getTestStatsProvider().getCounter("bookkeeper_client.ADD_ENTRY_UR").get() > 0L ? 1 : 0) != 0);
        i = numEntriesToWrite;
        numEntriesToWrite += 10;
        while (i < numEntriesToWrite) {
            entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.entries1.add(entry.array());
            this.lh.addEntry(entry.array());
            ++i;
        }
        sleepLatch1.countDown();
        BookieId bookie2 = (BookieId)this.lh.getCurrentEnsemble().get(0);
        Assert.assertFalse((String)"Delayed write error must have forced ensemble change", (boolean)bookie1.equals((Object)bookie2));
        this.lh.close();
    }

    @Test
    public void testLedgerDigestTest() throws Exception {
        for (BookKeeper.DigestType type : BookKeeper.DigestType.values()) {
            this.lh = this.bkc.createLedger(5, 3, 2, type, this.ledgerPassword);
            for (int i = 0; i < this.numEntriesToWrite; ++i) {
                ByteBuffer entry = ByteBuffer.allocate(4);
                entry.putInt(this.rng.nextInt(this.maxInt));
                entry.position(0);
                this.entries1.add(entry.array());
                this.lh.addEntry(entry.array());
            }
            this.readEntries(this.lh, this.entries1);
            long lid = this.lh.getId();
            this.lh.close();
            this.bkc.deleteLedger(lid);
            this.entries1.clear();
        }
    }

    @Test
    public void testLedgerCreateAdv() throws Exception {
        this.lh = this.bkc.createLedgerAdv(5, 3, 2, this.digestType, this.ledgerPassword);
        for (int i = 0; i < this.numEntriesToWrite; ++i) {
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.entries1.add(entry.array());
            this.lh.addEntry((long)i, entry.array());
        }
        this.startNewBookie();
        List ensemble = (List)this.lh.getLedgerMetadata().getAllEnsembles().entrySet().iterator().next().getValue();
        this.killBookie((BookieId)ensemble.get(0));
        this.numEntriesToWrite += 50;
        for (int i = this.numEntriesToWrite; i < this.numEntriesToWrite; ++i) {
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.entries1.add(entry.array());
            this.lh.addEntry((long)i, entry.array());
        }
        this.readEntries(this.lh, this.entries1);
        this.lh.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLedgerCreateAdvAndWriteNonAdv() throws Exception {
        long ledgerId = 11259375L;
        this.lh = this.bkc.createLedgerAdv(ledgerId, 3, 3, 2, this.digestType, this.ledgerPassword, null);
        ByteBuffer entry = ByteBuffer.allocate(4);
        entry.putInt(this.rng.nextInt(this.maxInt));
        entry.position(0);
        try {
            this.lh.addEntry(entry.array());
            Assert.fail((String)"expected IllegalOpException");
        }
        catch (BKException.BKIllegalOpException bKIllegalOpException) {
        }
        finally {
            this.lh.close();
            this.bkc.deleteLedger(ledgerId);
        }
    }

    @Test
    public void testNoAddEntryLedgerCreateAdv() throws Exception {
        BKException e;
        CompletableFuture done;
        ByteBuffer entry = ByteBuffer.allocate(4);
        entry.putInt(this.rng.nextInt(this.maxInt));
        entry.position(0);
        this.lh = this.bkc.createLedgerAdv(5, 3, 2, this.digestType, this.ledgerPassword);
        Assert.assertTrue((boolean)(this.lh instanceof LedgerHandleAdv));
        try {
            this.lh.addEntry(entry.array());
            Assert.fail((String)"using LedgerHandleAdv addEntry without entryId is forbidden");
        }
        catch (BKException e2) {
            Assert.assertEquals((long)e2.getCode(), (long)-100L);
        }
        try {
            this.lh.addEntry(entry.array(), 0, 4);
            Assert.fail((String)"using LedgerHandleAdv addEntry without entryId is forbidden");
        }
        catch (BKException e3) {
            Assert.assertEquals((long)e3.getCode(), (long)-100L);
        }
        try {
            done = new CompletableFuture();
            this.lh.asyncAddEntry(Unpooled.wrappedBuffer((byte[])entry.array()), (rc, lh1, entryId, ctx) -> SyncCallbackUtils.finish((int)rc, null, (CompletableFuture)done), null);
            done.get();
        }
        catch (ExecutionException ee) {
            Assert.assertTrue((boolean)(ee.getCause() instanceof BKException));
            e = (BKException)ee.getCause();
            Assert.assertEquals((long)e.getCode(), (long)-100L);
        }
        try {
            done = new CompletableFuture();
            this.lh.asyncAddEntry(entry.array(), (rc, lh1, entryId, ctx) -> SyncCallbackUtils.finish((int)rc, null, (CompletableFuture)done), null);
            done.get();
        }
        catch (ExecutionException ee) {
            Assert.assertTrue((boolean)(ee.getCause() instanceof BKException));
            e = (BKException)ee.getCause();
            Assert.assertEquals((long)e.getCode(), (long)-100L);
        }
        try {
            done = new CompletableFuture();
            this.lh.asyncAddEntry(entry.array(), 0, 4, (rc, lh1, entryId, ctx) -> SyncCallbackUtils.finish((int)rc, null, (CompletableFuture)done), null);
            done.get();
        }
        catch (ExecutionException ee) {
            Assert.assertTrue((boolean)(ee.getCause() instanceof BKException));
            e = (BKException)ee.getCause();
            Assert.assertEquals((long)e.getCode(), (long)-100L);
        }
        this.lh.close();
    }

    @Test
    public void testLedgerCreateAdvWithLedgerId() throws Exception {
        long ledgerId = 11259375L;
        this.lh = this.bkc.createLedgerAdv(ledgerId, 5, 3, 2, this.digestType, this.ledgerPassword, null);
        for (int i = 0; i < this.numEntriesToWrite; ++i) {
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.entries1.add(entry.array());
            this.lh.addEntry((long)i, entry.array());
        }
        this.startNewBookie();
        List ensemble = (List)this.lh.getLedgerMetadata().getAllEnsembles().entrySet().iterator().next().getValue();
        this.killBookie((BookieId)ensemble.get(0));
        this.numEntriesToWrite += 50;
        for (int i = this.numEntriesToWrite; i < this.numEntriesToWrite; ++i) {
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.entries1.add(entry.array());
            this.lh.addEntry((long)i, entry.array());
        }
        this.readEntries(this.lh, this.entries1);
        this.lh.close();
        this.bkc.deleteLedger(ledgerId);
    }

    @Test
    public void testLedgerCreateWithCustomMetadata() throws Exception {
        int maxLedgers = 10;
        for (int i = 0; i < maxLedgers; ++i) {
            long ledgerId;
            HashMap<String, byte[]> inputCustomMetadataMap = new HashMap<String, byte[]>();
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            for (int j = 0; j < i; ++j) {
                inputCustomMetadataMap.put("key" + j, UUID.randomUUID().toString().getBytes());
            }
            if (i < maxLedgers / 2) {
                this.lh = this.bkc.createLedger(5, 3, 2, this.digestType, this.ledgerPassword, inputCustomMetadataMap);
                ledgerId = this.lh.getId();
                this.lh.addEntry(entry.array());
            } else {
                this.lh = this.bkc.createLedgerAdv(5, 3, 2, this.digestType, this.ledgerPassword, inputCustomMetadataMap);
                ledgerId = this.lh.getId();
                this.lh.addEntry(0L, entry.array());
            }
            this.lh.close();
            this.lh = this.bkc.openLedger(ledgerId, this.digestType, this.ledgerPassword);
            Map outputCustomMetadataMap = this.lh.getCustomMetadata();
            Assert.assertTrue((String)"Can't retrieve proper Custom Data", (boolean)BookieWriteLedgerTest.areByteArrayValMapsEqual(inputCustomMetadataMap, outputCustomMetadataMap));
            this.lh.close();
            this.bkc.deleteLedger(ledgerId);
        }
    }

    public static boolean areByteArrayValMapsEqual(Map<String, byte[]> first, Map<String, byte[]> second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.size() != second.size()) {
            return false;
        }
        for (Map.Entry<String, byte[]> entry : first.entrySet()) {
            if (Arrays.equals(entry.getValue(), second.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testLedgerHandleAdvFunctionality() throws Exception {
        long ledgerId = 11259375L;
        this.lh = this.bkc.createLedgerAdv(ledgerId, 5, 3, 2, this.digestType, this.ledgerPassword, null);
        this.numEntriesToWrite = 3;
        ByteBuffer entry = ByteBuffer.allocate(4);
        entry.putInt(this.rng.nextInt(this.maxInt));
        entry.position(0);
        this.entries1.add(entry.array());
        this.lh.addEntry(0L, entry.array());
        entry = ByteBuffer.allocate(4);
        entry.putInt(this.rng.nextInt(this.maxInt));
        entry.position(0);
        this.entries1.add(entry.array());
        CountDownLatch latch = new CountDownLatch(1);
        final int[] returnedRC = new int[1];
        this.lh.asyncAddEntry(1L, entry.array(), new AsyncCallback.AddCallback(){

            public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
                CountDownLatch latch = (CountDownLatch)ctx;
                returnedRC[0] = rc;
                latch.countDown();
            }
        }, (Object)latch);
        latch.await();
        Assert.assertTrue((String)"Returned code is expected to be OK", (returnedRC[0] == 0 ? 1 : 0) != 0);
        entry = ByteBuffer.allocate(4);
        entry.putInt(this.rng.nextInt(this.maxInt));
        entry.position(0);
        try {
            this.lh.addEntry(2L, entry.array(), -3, 9);
            Assert.fail((String)"AddEntry is called with negative offset and incorrect length,so it is expected to throw RuntimeException/IndexOutOfBoundsException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        entry = ByteBuffer.allocate(4);
        entry.putInt(this.rng.nextInt(this.maxInt));
        entry.position(0);
        this.entries1.add(entry.array());
        this.lh.addEntry(2L, entry.array());
        this.lh.close();
        entry = ByteBuffer.allocate(4);
        entry.putInt(this.rng.nextInt(this.maxInt));
        entry.position(0);
        this.entries1.add(entry.array());
        try {
            this.lh.addEntry(3L, entry.array());
            Assert.fail((String)"AddEntry is called after the close of LedgerHandle,so it is expected to throw BKLedgerClosedException");
        }
        catch (BKException.BKLedgerClosedException bKLedgerClosedException) {
            // empty catch block
        }
        this.readEntries(this.lh, this.entries1);
        this.bkc.deleteLedger(ledgerId);
    }

    @Test
    public void testLedgerCreateAdvWithLedgerIdInLoop() throws Exception {
        int ledgerCount = 40;
        long maxId = 9999999999L;
        if (this.baseConf.getLedgerManagerFactoryClass().equals(LongHierarchicalLedgerManagerFactory.class)) {
            maxId = Long.MAX_VALUE;
        }
        ((Stream)this.rng.longs(ledgerCount, 0L, maxId).mapToObj(ledgerId -> {
            LOG.info("Creating adv ledger with id {}", (Object)ledgerId);
            return this.bkc.newCreateLedgerOp().withEnsembleSize(1).withWriteQuorumSize(1).withAckQuorumSize(1).withDigestType(DigestType.CRC32).withPassword(this.ledgerPassword).makeAdv().withLedgerId(ledgerId).execute().thenCompose(writer -> {
                LOG.info("Writing stream of {} entries to {}", (Object)this.numEntriesToWrite, (Object)ledgerId);
                List entries = this.rng.ints(this.numEntriesToWrite, 0, this.maxInt).mapToObj(i -> {
                    ByteBuf entry = Unpooled.buffer((int)4);
                    entry.retain();
                    entry.writeInt(i);
                    return entry;
                }).collect(Collectors.toList());
                CompletableFuture lastRequest = null;
                int i2 = 0;
                for (ByteBuf entry : entries) {
                    long entryId = i2++;
                    LOG.info("Writing {}:{} as {}", new Object[]{ledgerId, entryId, entry.slice().readInt()});
                    lastRequest = writer.writeAsync(entryId, entry);
                }
                return lastRequest.thenApply(___ -> Pair.of((Object)writer, (Object)entries));
            });
        }).parallel()).map(CompletableFuture::join).forEach(e -> {
            try {
                WriteAdvHandle handle = (WriteAdvHandle)e.getLeft();
                List entries = (List)e.getRight();
                LOG.info("Read entries for ledger: {}", (Object)handle.getId());
                this.readEntries((ReadHandle)handle, entries);
                entries.forEach(ReferenceCounted::release);
                handle.close();
                this.bkc.deleteLedger(handle.getId());
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                Assert.fail((String)"Test interrupted");
            }
            catch (Exception ex) {
                LOG.info("Readback failed with exception", (Throwable)ex);
                Assert.fail((String)("Readback failed " + ex.getMessage()));
            }
        });
    }

    @Test
    public void testLedgerCreateAdvWithLedgerIdInLoop2() throws Exception {
        int lc;
        Assert.assertTrue((String)"Here we are expecting Bookies are configured to use SortedLedgerStorage", (boolean)this.baseConf.getSortedLedgerStorageEnabled());
        int ledgerCount = 10;
        ArrayList entryList = new ArrayList();
        LedgerHandle[] lhArray = new LedgerHandle[ledgerCount];
        long skipListSizeLimit = this.baseConf.getSkipListSizeLimit();
        int skipListArenaMaxAllocSize = this.baseConf.getSkipListArenaMaxAllocSize();
        for (lc = 0; lc < ledgerCount; ++lc) {
            ArrayList<byte[]> tmpEntry = new ArrayList<byte[]>();
            long ledgerId = this.rng.nextLong();
            ledgerId &= Long.MAX_VALUE;
            if (!this.baseConf.getLedgerManagerFactoryClass().equals(LongHierarchicalLedgerManagerFactory.class)) {
                ledgerId %= 9999999999L;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Iteration: {}  LedgerId: {}", (Object)lc, (Object)ledgerId);
            }
            lhArray[lc] = this.lh = this.bkc.createLedgerAdv(ledgerId, 5, 3, 2, this.digestType, this.ledgerPassword, null);
            long ledgerLength = 0L;
            int i = 0;
            while (ledgerLength < 4L * skipListSizeLimit / (long)ledgerCount) {
                int length = this.rng.nextBoolean() ? Math.abs(this.rng.nextInt()) % skipListArenaMaxAllocSize : Math.abs(this.rng.nextInt()) % (skipListArenaMaxAllocSize * 3) + skipListArenaMaxAllocSize;
                byte[] data = new byte[length];
                this.rng.nextBytes(data);
                tmpEntry.add(data);
                this.lh.addEntry((long)i, data);
                ledgerLength += (long)length;
                ++i;
            }
            entryList.add(tmpEntry);
        }
        for (lc = 0; lc < ledgerCount; ++lc) {
            long lid = lhArray[lc].getId();
            if (LOG.isDebugEnabled()) {
                LOG.debug("readEntries for lc: {} ledgerId: {} ", (Object)lc, (Object)lhArray[lc].getId());
            }
            this.readEntriesAndValidateDataArray(lhArray[lc], (List)entryList.get(lc));
            lhArray[lc].close();
            this.bkc.deleteLedger(lid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncWritesWithMultipleFailuresInLastEnsemble() throws Exception {
        ByteBuffer entry;
        this.lh = this.bkc.createLedger(5, 4, this.digestType, this.ledgerPassword);
        this.lh2 = this.bkc.createLedger(5, 4, this.digestType, this.ledgerPassword);
        LOG.info("Ledger ID-1: " + this.lh.getId());
        LOG.info("Ledger ID-2: " + this.lh2.getId());
        for (int i = 0; i < this.numEntriesToWrite; ++i) {
            entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.entries1.add(entry.array());
            this.entries2.add(entry.array());
            this.lh.addEntry(entry.array());
            this.lh2.addEntry(entry.array());
        }
        this.startNewBookie();
        this.startNewBookie();
        this.startNewBookie();
        List ensemble = (List)this.lh.getLedgerMetadata().getAllEnsembles().entrySet().iterator().next().getValue();
        this.killBookie((BookieId)ensemble.get(0));
        this.killBookie((BookieId)ensemble.get(1));
        this.killBookie((BookieId)ensemble.get(2));
        ++this.numEntriesToWrite;
        entry = ByteBuffer.allocate(4);
        entry.putInt(this.rng.nextInt(this.maxInt));
        entry.position(0);
        this.entries1.add(entry.array());
        this.entries2.add(entry.array());
        SyncObj syncObj1 = new SyncObj();
        SyncObj syncObj2 = new SyncObj();
        this.lh.asyncAddEntry(entry.array(), (AsyncCallback.AddCallback)this, (Object)syncObj1);
        this.lh2.asyncAddEntry(entry.array(), (AsyncCallback.AddCallback)this, (Object)syncObj2);
        SyncObj syncObj = syncObj1;
        synchronized (syncObj) {
            while (syncObj1.counter < 1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Entries counter = " + syncObj1.counter);
                }
                syncObj1.wait();
            }
            Assert.assertEquals((long)0L, (long)syncObj1.rc);
        }
        syncObj = syncObj2;
        synchronized (syncObj) {
            while (syncObj2.counter < 1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Entries counter = " + syncObj2.counter);
                }
                syncObj2.wait();
            }
            Assert.assertEquals((long)0L, (long)syncObj2.rc);
        }
        this.readEntries(this.lh, this.entries1);
        this.readEntries(this.lh2, this.entries2);
        this.lh.close();
        this.lh2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLedgerCreateAdvWithAsyncWritesWithBookieFailures() throws Exception {
        this.lh = this.bkc.createLedgerAdv(5, 3, 2, this.digestType, this.ledgerPassword);
        this.lh2 = this.bkc.createLedgerAdv(5, 3, 2, this.digestType, this.ledgerPassword);
        LOG.info("Ledger ID-1: " + this.lh.getId());
        LOG.info("Ledger ID-2: " + this.lh2.getId());
        SyncObj syncObj1 = new SyncObj();
        SyncObj syncObj2 = new SyncObj();
        for (int i = this.numEntriesToWrite - 1; i >= 0; --i) {
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            try {
                this.entries1.add(0, entry.array());
                this.entries2.add(0, entry.array());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.lh.asyncAddEntry((long)i, entry.array(), 0, entry.capacity(), (AsyncCallback.AddCallback)this, (Object)syncObj1);
            this.lh2.asyncAddEntry((long)i, entry.array(), 0, entry.capacity(), (AsyncCallback.AddCallback)this, (Object)syncObj2);
        }
        this.startNewBookie();
        List ensemble = (List)this.lh.getLedgerMetadata().getAllEnsembles().entrySet().iterator().next().getValue();
        this.killBookie((BookieId)ensemble.get(0));
        SyncObj syncObj = syncObj1;
        synchronized (syncObj) {
            while (syncObj1.counter < this.numEntriesToWrite) {
                syncObj1.wait();
            }
            Assert.assertEquals((long)0L, (long)syncObj1.rc);
        }
        syncObj = syncObj2;
        synchronized (syncObj) {
            while (syncObj2.counter < this.numEntriesToWrite) {
                syncObj2.wait();
            }
            Assert.assertEquals((long)0L, (long)syncObj2.rc);
        }
        this.readEntries(this.lh, this.entries1);
        this.readEntries(this.lh2, this.entries2);
        this.lh.close();
        this.lh2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLedgerHandleAdvOutOfOrderWriteAndFrocedEnsembleChange() throws Exception {
        long ledgerId = 11259375L;
        SyncObj syncObj1 = new SyncObj();
        this.lh = this.bkc.createLedgerAdv(ledgerId, 3, 3, 3, this.digestType, this.ledgerPassword, null);
        ByteBuffer entry = ByteBuffer.allocate(4);
        for (int i = 0; i < 5; ++i) {
            entry.rewind();
            entry.putInt(this.rng.nextInt(this.maxInt));
            this.lh.addEntry((long)i, entry.array());
        }
        ByteBuffer entry1 = ByteBuffer.allocate(4);
        entry1.putInt(this.rng.nextInt(this.maxInt));
        this.lh.asyncAddEntry(10L, entry1.array(), 0, entry1.capacity(), (AsyncCallback.AddCallback)this, (Object)syncObj1);
        Queue myPendingAddOps = (Queue)Whitebox.getInternalState((Object)this.lh, (String)"pendingAddOps");
        PendingAddOp addOp = null;
        boolean pendingAddOpReceived = false;
        while (!pendingAddOpReceived) {
            addOp = (PendingAddOp)myPendingAddOps.peek();
            if (addOp.entryId == 10L && addOp.completed) {
                pendingAddOpReceived = true;
                continue;
            }
            Thread.sleep(1000L);
        }
        CountDownLatch sleepLatch1 = new CountDownLatch(1);
        List ensemble = (List)this.lh.getLedgerMetadata().getAllEnsembles().entrySet().iterator().next().getValue();
        this.sleepBookie((BookieId)ensemble.get(0), sleepLatch1);
        this.sleepBookie((BookieId)ensemble.get(1), sleepLatch1);
        this.sleepBookie((BookieId)ensemble.get(2), sleepLatch1);
        this.startNewBookie();
        this.startNewBookie();
        this.startNewBookie();
        for (int i = 5; i < 10; ++i) {
            entry.rewind();
            entry.putInt(this.rng.nextInt(this.maxInt));
            this.lh.addEntry((long)i, entry.array());
        }
        sleepLatch1.countDown();
        SyncObj i = syncObj1;
        synchronized (i) {
            while (syncObj1.counter < 1) {
                syncObj1.wait();
            }
            Assert.assertEquals((long)0L, (long)syncObj1.rc);
        }
        this.lh.close();
        this.lh = this.bkc.openLedger(ledgerId, this.digestType, this.ledgerPassword);
        for (int i2 = 0; i2 < 11; ++i2) {
            this.lh.readEntries((long)i2, (long)i2);
        }
        this.lh.close();
        this.bkc.deleteLedger(ledgerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLedgerCreateAdvWithRandomAsyncWritesWithBookieFailuresBetweenWrites() throws Exception {
        int i;
        this.lh = this.bkc.createLedgerAdv(5, 3, 2, this.digestType, this.ledgerPassword);
        this.lh2 = this.bkc.createLedgerAdv(5, 3, 2, this.digestType, this.ledgerPassword);
        LOG.info("Ledger ID-1: " + this.lh.getId());
        LOG.info("Ledger ID-2: " + this.lh2.getId());
        SyncObj syncObj1 = new SyncObj();
        SyncObj syncObj2 = new SyncObj();
        int batchSize = 5;
        for (i = 0; i < this.numEntriesToWrite; ++i) {
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            try {
                this.entries1.add(0, entry.array());
                this.entries2.add(0, entry.array());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < batchSize; ++i) {
            for (int j = i; j < this.numEntriesToWrite; j += batchSize) {
                byte[] entry1 = this.entries1.get(j);
                byte[] entry2 = this.entries2.get(j);
                this.lh.asyncAddEntry((long)j, entry1, 0, entry1.length, (AsyncCallback.AddCallback)this, (Object)syncObj1);
                this.lh2.asyncAddEntry((long)j, entry2, 0, entry2.length, (AsyncCallback.AddCallback)this, (Object)syncObj2);
                if (j != this.numEntriesToWrite / 2) continue;
                this.startNewBookie();
                List ensemble = (List)this.lh.getLedgerMetadata().getAllEnsembles().entrySet().iterator().next().getValue();
                this.killBookie((BookieId)ensemble.get(0));
            }
        }
        SyncObj syncObj = syncObj1;
        synchronized (syncObj) {
            while (syncObj1.counter < this.numEntriesToWrite) {
                syncObj1.wait();
            }
            Assert.assertEquals((long)0L, (long)syncObj1.rc);
        }
        syncObj = syncObj2;
        synchronized (syncObj) {
            while (syncObj2.counter < this.numEntriesToWrite) {
                syncObj2.wait();
            }
            Assert.assertEquals((long)0L, (long)syncObj2.rc);
        }
        this.readEntries(this.lh, this.entries1);
        this.readEntries(this.lh2, this.entries2);
        this.lh.close();
        this.lh2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLedgerCreateAdvWithRandomAsyncWritesWithBookieFailures() throws Exception {
        int i;
        this.lh = this.bkc.createLedgerAdv(5, 3, 2, this.digestType, this.ledgerPassword);
        this.lh2 = this.bkc.createLedgerAdv(5, 3, 2, this.digestType, this.ledgerPassword);
        LOG.info("Ledger ID-1: " + this.lh.getId());
        LOG.info("Ledger ID-2: " + this.lh2.getId());
        SyncObj syncObj1 = new SyncObj();
        SyncObj syncObj2 = new SyncObj();
        int batchSize = 5;
        for (i = 0; i < this.numEntriesToWrite; ++i) {
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            try {
                this.entries1.add(0, entry.array());
                this.entries2.add(0, entry.array());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < batchSize; ++i) {
            for (int j = i; j < this.numEntriesToWrite; j += batchSize) {
                byte[] entry1 = this.entries1.get(j);
                byte[] entry2 = this.entries2.get(j);
                this.lh.asyncAddEntry((long)j, entry1, 0, entry1.length, (AsyncCallback.AddCallback)this, (Object)syncObj1);
                this.lh2.asyncAddEntry((long)j, entry2, 0, entry2.length, (AsyncCallback.AddCallback)this, (Object)syncObj2);
            }
        }
        this.startNewBookie();
        List ensemble = (List)this.lh.getLedgerMetadata().getAllEnsembles().entrySet().iterator().next().getValue();
        this.killBookie((BookieId)ensemble.get(0));
        SyncObj syncObj = syncObj1;
        synchronized (syncObj) {
            while (syncObj1.counter < this.numEntriesToWrite) {
                syncObj1.wait();
            }
            Assert.assertEquals((long)0L, (long)syncObj1.rc);
        }
        syncObj = syncObj2;
        synchronized (syncObj) {
            while (syncObj2.counter < this.numEntriesToWrite) {
                syncObj2.wait();
            }
            Assert.assertEquals((long)0L, (long)syncObj2.rc);
        }
        this.readEntries(this.lh, this.entries1);
        this.readEntries(this.lh2, this.entries2);
        this.lh.close();
        this.lh2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLedgerCreateAdvWithSkipEntries() throws Exception {
        SyncObj syncObj1 = new SyncObj();
        this.lh = this.bkc.createLedgerAdv(5, 3, 2, this.digestType, this.ledgerPassword);
        long ledgerId = this.lh.getId();
        LOG.info("Ledger ID: " + ledgerId);
        int skipEntryId = this.rng.nextInt(this.numEntriesToWrite - 1);
        for (int i = this.numEntriesToWrite - 1; i >= 0; --i) {
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            try {
                this.entries1.add(0, entry.array());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (i == skipEntryId) {
                LOG.info("Skipping entry:{}", (Object)skipEntryId);
                continue;
            }
            this.lh.asyncAddEntry((long)i, entry.array(), 0, entry.capacity(), (AsyncCallback.AddCallback)this, (Object)syncObj1);
        }
        SyncObj syncObj = syncObj1;
        synchronized (syncObj) {
            while (syncObj1.counter < skipEntryId) {
                syncObj1.wait();
            }
            Assert.assertEquals((long)0L, (long)syncObj1.rc);
        }
        this.lh.close();
        this.lh = this.bkc.openLedger(ledgerId, this.digestType, this.ledgerPassword);
        Assert.assertEquals((long)this.lh.lastAddConfirmed, (long)(skipEntryId - 1));
        this.lh.close();
    }

    @Test
    public void testLedgerCreateAdvSyncAddDuplicateEntryIds() throws Exception {
        ByteBuffer entry;
        this.lh = this.bkc.createLedgerAdv(5, 3, 2, this.digestType, this.ledgerPassword);
        LOG.info("Ledger ID: " + this.lh.getId());
        for (int i = 0; i < this.numEntriesToWrite; ++i) {
            entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.entries1.add(entry.array());
            this.lh.addEntry((long)i, entry.array());
            entry.position(0);
        }
        this.readEntries(this.lh, this.entries1);
        int dupEntryId = this.rng.nextInt(this.numEntriesToWrite - 1);
        try {
            entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.lh.addEntry((long)dupEntryId, entry.array());
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (BKException e) {
            Assert.assertEquals((long)e.getCode(), (long)-22L);
        }
        this.lh.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLedgerCreateAdvSyncAsyncAddDuplicateEntryIds() throws Exception {
        SyncObj syncObj1 = new SyncObj();
        SyncObj syncObj2 = new SyncObj();
        this.lh = this.bkc.createLedgerAdv(5, 3, 2, this.digestType, this.ledgerPassword);
        long ledgerId = this.lh.getId();
        LOG.info("Ledger ID: " + ledgerId);
        for (int i = this.numEntriesToWrite - 1; i >= 0; --i) {
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            try {
                this.entries1.add(0, entry.array());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.lh.asyncAddEntry((long)i, entry.array(), 0, entry.capacity(), (AsyncCallback.AddCallback)this, (Object)syncObj1);
            if (!this.rng.nextBoolean()) continue;
            this.lh.asyncAddEntry((long)i, entry.array(), 0, entry.capacity(), (AsyncCallback.AddCallback)this, (Object)syncObj2);
            SyncObj syncObj = syncObj2;
            synchronized (syncObj) {
                while (syncObj2.counter < 1) {
                    syncObj2.wait();
                }
                Assert.assertEquals((long)-22L, (long)syncObj2.rc);
                continue;
            }
        }
        SyncObj syncObj = syncObj1;
        synchronized (syncObj) {
            while (syncObj1.counter < this.numEntriesToWrite) {
                syncObj1.wait();
            }
            Assert.assertEquals((long)0L, (long)syncObj1.rc);
        }
        this.lh.close();
    }

    @Test
    public void testLedgerCreateAdvByteBufRefCnt() throws Exception {
        long ledgerId = this.rng.nextLong();
        ledgerId &= Long.MAX_VALUE;
        if (!this.baseConf.getLedgerManagerFactoryClass().equals(LongHierarchicalLedgerManagerFactory.class)) {
            ledgerId %= 9999999999L;
        }
        LedgerHandle lh = this.bkc.createLedgerAdv(ledgerId, 5, 3, 2, this.digestType, this.ledgerPassword, null);
        ArrayList allocs = Lists.newArrayList((Object[])new AbstractByteBufAllocator[]{new PooledByteBufAllocator(true), new PooledByteBufAllocator(false), new UnpooledByteBufAllocator(true), new UnpooledByteBufAllocator(false)});
        long entryId = 0L;
        for (AbstractByteBufAllocator alloc : allocs) {
            ByteBuf data = alloc.buffer(10);
            data.writeBytes(("fragment0" + entryId).getBytes());
            Assert.assertEquals((String)"ref count on ByteBuf should be 1", (long)1L, (long)data.refCnt());
            CompletableFuture cf = new CompletableFuture();
            lh.asyncAddEntry(entryId, data, (rc, handle, eId, qwcLatency, ctx) -> {
                CompletableFuture future = (CompletableFuture)ctx;
                future.complete(rc);
            }, cf);
            int rc2 = (Integer)cf.get();
            Assert.assertEquals((String)"rc code is OK", (long)0L, (long)rc2);
            for (int i = 0; i < 10 && data.refCnt() != 0; ++i) {
                TimeUnit.MILLISECONDS.sleep(250L);
            }
            Assert.assertEquals((String)("writing entry with id " + entryId + ", ref count on ByteBuf should be 0 "), (long)0L, (long)data.refCnt());
            org.apache.bookkeeper.client.api.LedgerEntry e = lh.read(entryId, entryId).getEntry(entryId);
            Assert.assertEquals((String)"entry data is correct", (Object)("fragment0" + entryId), (Object)new String(e.getEntryBytes()));
            ++entryId;
        }
        this.bkc.deleteLedger(lh.ledgerId);
    }

    @Test
    public void testLedgerCreateByteBufRefCnt() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(5, 3, 2, this.digestType, this.ledgerPassword, null);
        ArrayList allocs = Lists.newArrayList((Object[])new AbstractByteBufAllocator[]{new PooledByteBufAllocator(true), new PooledByteBufAllocator(false), new UnpooledByteBufAllocator(true), new UnpooledByteBufAllocator(false)});
        int entryId = 0;
        for (AbstractByteBufAllocator alloc : allocs) {
            ByteBuf data = alloc.buffer(10);
            data.writeBytes(("fragment0" + entryId).getBytes());
            Assert.assertEquals((String)"ref count on ByteBuf should be 1", (long)1L, (long)data.refCnt());
            CompletableFuture cf = new CompletableFuture();
            lh.asyncAddEntry(data, (rc, handle, eId, ctx) -> {
                CompletableFuture future = (CompletableFuture)ctx;
                future.complete(rc);
            }, cf);
            int rc2 = (Integer)cf.get();
            Assert.assertEquals((String)"rc code is OK", (long)0L, (long)rc2);
            for (int i = 0; i < 10 && data.refCnt() != 0; ++i) {
                TimeUnit.MILLISECONDS.sleep(250L);
            }
            Assert.assertEquals((String)("writing entry with id " + entryId + ", ref count on ByteBuf should be 0 "), (long)0L, (long)data.refCnt());
            org.apache.bookkeeper.client.api.LedgerEntry e = lh.read((long)entryId, (long)entryId).getEntry((long)entryId);
            Assert.assertEquals((String)"entry data is correct", (Object)("fragment0" + entryId), (Object)new String(e.getEntryBytes()));
            ++entryId;
        }
        this.bkc.deleteLedger(lh.ledgerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadLacNotSameWithMetadataLedgerReplication() throws Exception {
        this.lh = this.bkc.createLedger(3, 3, 2, this.digestType, this.ledgerPassword);
        for (int i = 0; i < 10; ++i) {
            ByteBuffer entry = ByteBuffer.allocate(4);
            entry.putInt(this.rng.nextInt(this.maxInt));
            entry.position(0);
            this.lh.addEntry(entry.array());
        }
        List ensemble = (List)this.lh.getLedgerMetadata().getAllEnsembles().entrySet().iterator().next().getValue();
        Assert.assertEquals((long)1L, (long)this.lh.getLedgerMetadata().getAllEnsembles().size());
        this.killBookie((BookieId)ensemble.get(1));
        try {
            this.lh.ensembleChangeLoop(ensemble, Collections.singletonMap(1, ensemble.get(1)));
        }
        catch (Exception e) {
            Assert.fail();
        }
        LedgerHandle lh1 = this.bkc.openLedgerNoRecovery(this.lh.ledgerId, this.digestType, this.ledgerPassword);
        Assert.assertEquals((long)2L, (long)lh1.getLedgerMetadata().getAllEnsembles().size());
        List firstEnsemble = (List)lh1.getLedgerMetadata().getAllEnsembles().firstEntry().getValue();
        long entryId = (Long)lh1.getLedgerMetadata().getAllEnsembles().lastEntry().getKey() - 1L;
        try {
            lh1.readAsync(entryId, entryId).get();
            Assert.fail();
        }
        catch (Exception e) {
            LOG.info("Failed to read entry: {} ", (Object)entryId, (Object)e);
        }
        MetadataBookieDriver driver = MetadataDrivers.getBookieDriver((URI)URI.create(this.baseConf.getMetadataServiceUri()));
        driver.initialize(this.baseConf, (StatsLogger)NullStatsLogger.INSTANCE);
        LedgerManagerFactory mFactory = driver.getLedgerManagerFactory();
        LedgerUnderreplicationManager underReplicationManager = mFactory.newLedgerUnderreplicationManager();
        this.baseConf.setOpenLedgerRereplicationGracePeriod(String.valueOf(30));
        ReplicationWorker replicationWorker = new ReplicationWorker(this.baseConf);
        replicationWorker.start();
        String basePath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.baseClientConf) + '/' + "underreplication" + "/ledgers";
        try {
            underReplicationManager.markLedgerUnderreplicated(lh1.getId(), ((BookieId)ensemble.get(1)).toString());
            Awaitility.waitAtMost((long)30L, (TimeUnit)TimeUnit.SECONDS).untilAsserted(() -> Assert.assertFalse((boolean)ReplicationTestUtil.isLedgerInUnderReplication(this.zkc, lh1.getId(), basePath)));
            Assert.assertNotEquals((Object)firstEnsemble, lh1.getLedgerMetadata().getAllEnsembles().firstEntry().getValue());
        }
        finally {
            replicationWorker.shutdown();
        }
    }

    @Test
    public void testLedgerMetadataTest() throws Exception {
        this.baseClientConf.setLedgerMetadataFormatVersion(2);
        BookKeeperTestClient bkc = new BookKeeperTestClient(this.baseClientConf, new TestStatsProvider());
        this.lh = bkc.createLedger(3, 3, 2, this.digestType, this.ledgerPassword);
        Assert.assertEquals((long)this.lh.getLedgerMetadata().getMetadataFormatVersion(), (long)2L);
        this.lh.close();
    }

    private void readEntries(LedgerHandle lh, List<byte[]> entries) throws InterruptedException, BKException {
        this.ls = lh.readEntries(0L, (long)(this.numEntriesToWrite - 1));
        int index = 0;
        while (this.ls.hasMoreElements()) {
            ByteBuffer origbb = ByteBuffer.wrap(entries.get(index++));
            Integer origEntry = origbb.getInt();
            ByteBuffer result = ByteBuffer.wrap(this.ls.nextElement().getEntry());
            Integer retrEntry = result.getInt();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Length of result: " + result.capacity());
                LOG.debug("Original entry: " + origEntry);
                LOG.debug("Retrieved entry: " + retrEntry);
            }
            Assert.assertTrue((String)("Checking entry " + index + " for equality"), (boolean)origEntry.equals(retrEntry));
        }
    }

    private void readEntries(ReadHandle reader, List<ByteBuf> entries) throws Exception {
        Assert.assertEquals((String)("Not enough entries in ledger " + reader.getId()), (long)reader.getLastAddConfirmed(), (long)(entries.size() - 1));
        try (LedgerEntries readEntries = reader.read(0L, reader.getLastAddConfirmed());){
            int i = 0;
            for (org.apache.bookkeeper.client.api.LedgerEntry e : readEntries) {
                int entryId = i++;
                ByteBuf origEntry = entries.get(entryId);
                ByteBuf readEntry = e.getEntryBuffer();
                Assert.assertEquals((String)("Unexpected contents in " + reader.getId() + ":" + entryId), (Object)origEntry, (Object)readEntry);
            }
        }
    }

    private void readEntriesAndValidateDataArray(LedgerHandle lh, List<byte[]> entries) throws InterruptedException, BKException {
        this.ls = lh.readEntries(0L, (long)(entries.size() - 1));
        int index = 0;
        while (this.ls.hasMoreElements()) {
            byte[] originalData = entries.get(index++);
            byte[] receivedData = this.ls.nextElement().getEntry();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Length of originalData: {}", (Object)originalData.length);
                LOG.debug("Length of receivedData: {}", (Object)receivedData.length);
            }
            Assert.assertEquals((String)String.format("LedgerID: %d EntryID: %d OriginalDataLength: %d ReceivedDataLength: %d", lh.getId(), index - 1, originalData.length, receivedData.length), (long)originalData.length, (long)receivedData.length);
            Assert.assertArrayEquals((String)String.format("Checking LedgerID: %d EntryID: %d  for equality", lh.getId(), index - 1), (byte[])originalData, (byte[])receivedData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
        SyncObj x;
        SyncObj syncObj = x = (SyncObj)ctx;
        synchronized (syncObj) {
            x.rc = rc;
            ++x.counter;
            x.notify();
        }
    }

    static class CorruptReadBookie
    extends TestBookieImpl {
        static final Logger LOG = LoggerFactory.getLogger(CorruptReadBookie.class);
        ByteBuf localBuf;

        public CorruptReadBookie(ServerConfiguration conf) throws Exception {
            super(conf);
        }

        public ByteBuf readEntry(long ledgerId, long entryId) throws IOException, Bookie.NoLedgerException, BookieException {
            this.localBuf = super.readEntry(ledgerId, entryId);
            for (int capacity = 0; capacity < this.localBuf.capacity(); ++capacity) {
                this.localBuf.setByte(capacity, 0);
            }
            return this.localBuf;
        }
    }

    private static class SyncObj {
        volatile int counter = 0;
        volatile int rc;
    }
}

