/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.util.concurrent.RateLimiter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.feature.SettableFeature;
import org.apache.bookkeeper.feature.SettableFeatureProvider;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDisableEnsembleChange
extends BookKeeperClusterTestCase {
    private static final Logger logger = LoggerFactory.getLogger(TestDisableEnsembleChange.class);

    public TestDisableEnsembleChange() {
        super(4);
    }

    @Test
    public void testDisableEnsembleChange() throws Exception {
        this.disableEnsembleChangeTest(true);
    }

    @Test
    public void testDisableEnsembleChangeNotEnoughBookies() throws Exception {
        this.disableEnsembleChangeTest(false);
    }

    void disableEnsembleChangeTest(boolean startNewBookie) throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        ((ClientConfiguration)conf.setMetadataServiceUri(this.metadataServiceUri)).setDelayEnsembleChange(false).setDisableEnsembleChangeFeatureName("disable_ensemble_change");
        SettableFeatureProvider featureProvider = new SettableFeatureProvider("test", 0);
        BookKeeper bkc = BookKeeper.forConfig((ClientConfiguration)conf).featureProvider((FeatureProvider)featureProvider).build();
        SettableFeature disableEnsembleChangeFeature = (SettableFeature)featureProvider.getFeature("disable_ensemble_change");
        disableEnsembleChangeFeature.set(true);
        byte[] password = new byte[]{};
        final LedgerHandle lh = bkc.createLedger(4, 3, 2, BookKeeper.DigestType.CRC32, password);
        final AtomicBoolean finished = new AtomicBoolean(false);
        final AtomicBoolean failTest = new AtomicBoolean(false);
        final byte[] entry = "test-disable-ensemble-change".getBytes(StandardCharsets.UTF_8);
        Assert.assertEquals((long)1L, (long)lh.getLedgerMetadata().getAllEnsembles().size());
        ArrayList ensembleBeforeFailure = new ArrayList((Collection)lh.getLedgerMetadata().getAllEnsembles().entrySet().iterator().next().getValue());
        final RateLimiter rateLimiter = RateLimiter.create((double)10.0);
        Thread addThread = new Thread(){

            @Override
            public void run() {
                try {
                    while (!finished.get()) {
                        rateLimiter.acquire();
                        lh.addEntry(entry);
                    }
                }
                catch (Exception e) {
                    logger.error("Exception on adding entry : ", (Throwable)e);
                    failTest.set(true);
                }
            }
        };
        addThread.start();
        Thread.sleep(2000L);
        this.killBookie(0);
        Thread.sleep(2000L);
        finished.set(true);
        addThread.join();
        Assert.assertFalse((String)"Should not fail adding entries facing one bookie failure when disable ensemble change", (boolean)failTest.get());
        Assert.assertEquals((String)"No new ensemble should be added when disable ensemble change.", (long)1L, (long)lh.getLedgerMetadata().getAllEnsembles().size());
        ArrayList ensembleAfterFailure = new ArrayList((Collection)lh.getLedgerMetadata().getAllEnsembles().entrySet().iterator().next().getValue());
        Assert.assertArrayEquals((Object[])ensembleBeforeFailure.toArray(new BookieId[ensembleBeforeFailure.size()]), (Object[])ensembleAfterFailure.toArray(new BookieId[ensembleAfterFailure.size()]));
        disableEnsembleChangeFeature.set(false);
        if (startNewBookie) {
            this.startNewBookie();
        }
        finished.set(false);
        final CountDownLatch failLatch = new CountDownLatch(1);
        addThread = new Thread(){

            @Override
            public void run() {
                try {
                    while (!finished.get()) {
                        lh.addEntry(entry);
                    }
                }
                catch (Exception e) {
                    logger.error("Exception on adding entry : ", (Throwable)e);
                    failLatch.countDown();
                    failTest.set(true);
                }
            }
        };
        addThread.start();
        failLatch.await(4000L, TimeUnit.MILLISECONDS);
        finished.set(true);
        addThread.join();
        if (startNewBookie) {
            Assert.assertFalse((String)"Should not fail adding entries when enable ensemble change again.", (boolean)failTest.get());
            Assert.assertFalse((String)"Ledger should be closed when enable ensemble change again.", (boolean)lh.getLedgerMetadata().isClosed());
            Assert.assertEquals((String)"New ensemble should be added when enable ensemble change again.", (long)2L, (long)lh.getLedgerMetadata().getAllEnsembles().size());
        } else {
            Assert.assertTrue((String)"Should fail adding entries when enable ensemble change again.", (boolean)failTest.get());
            TestUtils.assertEventuallyTrue("Ledger should be closed when enable ensemble change again.", () -> lh.getLedgerMetadata().isClosed());
        }
    }

    @Test
    public void testRetryFailureBookie() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        ((ClientConfiguration)conf.setMetadataServiceUri(this.metadataServiceUri)).setDelayEnsembleChange(false).setDisableEnsembleChangeFeatureName("disable_ensemble_change");
        SettableFeatureProvider featureProvider = new SettableFeatureProvider("test", 0);
        BookKeeper bkc = BookKeeper.forConfig((ClientConfiguration)conf).featureProvider((FeatureProvider)featureProvider).build();
        SettableFeature disableEnsembleChangeFeature = (SettableFeature)featureProvider.getFeature("disable_ensemble_change");
        disableEnsembleChangeFeature.set(true);
        LedgerHandle lh = bkc.createLedger(4, 4, 4, BookKeeper.DigestType.CRC32, new byte[0]);
        byte[] entry = "testRetryFailureBookie".getBytes();
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(entry);
        }
        ServerConfiguration killedConf = this.killBookie(0);
        final AtomicInteger res = new AtomicInteger(-559038737);
        final CountDownLatch addLatch = new CountDownLatch(1);
        AsyncCallback.AddCallback cb = new AsyncCallback.AddCallback(){

            public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
                logger.info("Add entry {} completed : rc {}.", (Object)entryId, (Object)rc);
                res.set(rc);
                addLatch.countDown();
            }
        };
        lh.asyncAddEntry(entry, cb, null);
        Assert.assertFalse((String)"Add entry operation should not complete.", (boolean)addLatch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)res.get(), (long)-559038737L);
        this.startAndAddBookie(killedConf);
        Assert.assertTrue((String)"Add entry operation should complete at this point.", (boolean)addLatch.await(10000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)res.get(), (long)0L);
    }

    @Test
    public void testRetrySlowBookie() throws Exception {
        int readTimeout = 2;
        ClientConfiguration conf = new ClientConfiguration();
        conf.setReadEntryTimeout(2).setAddEntryTimeout(2).setDelayEnsembleChange(false).setDisableEnsembleChangeFeatureName("disable_ensemble_change").setMetadataServiceUri(this.metadataServiceUri);
        SettableFeatureProvider featureProvider = new SettableFeatureProvider("test", 0);
        BookKeeper bkc = BookKeeper.forConfig((ClientConfiguration)conf).featureProvider((FeatureProvider)featureProvider).build();
        SettableFeature disableEnsembleChangeFeature = (SettableFeature)featureProvider.getFeature("disable_ensemble_change");
        disableEnsembleChangeFeature.set(true);
        LedgerHandle lh = bkc.createLedger(4, 4, 4, BookKeeper.DigestType.CRC32, new byte[0]);
        byte[] entry = "testRetryFailureBookie".getBytes();
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(entry);
        }
        List curEns = lh.getCurrentEnsemble();
        CountDownLatch wakeupLatch = new CountDownLatch(1);
        CountDownLatch suspendLatch = new CountDownLatch(1);
        this.sleepBookie((BookieId)curEns.get(2), wakeupLatch, suspendLatch);
        suspendLatch.await();
        final AtomicInteger res = new AtomicInteger(-559038737);
        final CountDownLatch addLatch = new CountDownLatch(1);
        AsyncCallback.AddCallback cb = new AsyncCallback.AddCallback(){

            public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
                logger.info("Add entry {} completed : rc {}.", (Object)entryId, (Object)rc);
                res.set(rc);
                addLatch.countDown();
            }
        };
        lh.asyncAddEntry(entry, cb, null);
        Assert.assertFalse((String)"Add entry operation should not complete.", (boolean)addLatch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)res.get(), (long)-559038737L);
        Assert.assertFalse((String)"Add entry operation should not complete even timeout.", (boolean)addLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertEquals((long)res.get(), (long)-559038737L);
        Assert.assertFalse((String)"Add entry operation should not complete even timeout.", (boolean)addLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertEquals((long)res.get(), (long)-559038737L);
        wakeupLatch.countDown();
        Assert.assertTrue((String)"Add entry operation should complete at this point.", (boolean)addLatch.await(10000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)res.get(), (long)0L);
    }
}

