/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.ClientUtil;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSequenceRead
extends BookKeeperClusterTestCase {
    private static final Logger logger = LoggerFactory.getLogger(TestSequenceRead.class);

    public TestSequenceRead() {
        super(5);
    }

    private long createLedgerWithDuplicatedBookies() throws Exception {
        long ledgerId = 12345L;
        LedgerMetadataBuilder builder = LedgerMetadataBuilder.create().withId(ledgerId).withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieId[]{this.getBookie(0), this.getBookie(0), this.getBookie(0)}));
        ClientUtil.setupLedger(this.bkc.getLedgerManager(), ledgerId, builder);
        logger.info("Update ledger metadata with duplicated bookies for ledger {}.", (Object)ledgerId);
        return ledgerId;
    }

    @Test
    public void testSequenceReadOnDuplicatedBookies() throws Exception {
        long ledgerId = this.createLedgerWithDuplicatedBookies();
        LedgerHandle readLh = this.bkc.openLedger(ledgerId, BookKeeper.DigestType.fromApiDigestType((DigestType)ClientUtil.DIGEST_TYPE), ClientUtil.PASSWD);
        Assert.assertEquals((long)-1L, (long)readLh.getLastAddConfirmed());
    }
}

