/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client.api;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.api.BookKeeper;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.client.api.ListLedgersResult;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;

public class LedgerMetadataTest
extends BookKeeperClusterTestCase {
    public LedgerMetadataTest() {
        super(3);
    }

    @Test
    public void testGetLedgerMetadata() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        try (BookKeeper bkc = BookKeeper.newBuilder((ClientConfiguration)conf).build();){
            long ledgerId;
            try (WriteHandle l = (WriteHandle)bkc.newCreateLedgerOp().withDigestType(DigestType.CRC32).withPassword("testPasswd".getBytes()).execute().get();){
                ledgerId = l.getId();
            }
            LedgerMetadata metadata = (LedgerMetadata)FutureUtils.result((CompletableFuture)bkc.getLedgerMetadata(ledgerId));
            Assert.assertEquals((long)ledgerId, (long)metadata.getLedgerId());
            Assert.assertEquals((long)3L, (long)metadata.getEnsembleSize());
            Assert.assertEquals((long)2L, (long)metadata.getAckQuorumSize());
            Assert.assertEquals((long)2L, (long)metadata.getWriteQuorumSize());
            Assert.assertArrayEquals((byte[])"testPasswd".getBytes(), (byte[])metadata.getPassword());
        }
    }

    @Test
    public void testListLedgers() throws Exception {
        int numOfLedgers = 10;
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        try (BookKeeper bkc = BookKeeper.newBuilder((ClientConfiguration)conf).build();){
            long[] ledgerIds = new long[numOfLedgers];
            for (int i = 0; i < numOfLedgers; ++i) {
                try (WriteHandle l = (WriteHandle)bkc.newCreateLedgerOp().withDigestType(DigestType.CRC32).withPassword("testPasswd".getBytes()).execute().get();){
                    ledgerIds[i] = l.getId();
                    continue;
                }
            }
            try (ListLedgersResult result = (ListLedgersResult)FutureUtils.result((CompletableFuture)bkc.newListLedgersOp().execute());){
                int count = 0;
                Iterator iterator = result.toIterable().iterator();
                while (iterator.hasNext()) {
                    long ledgerId = (Long)iterator.next();
                    Assert.assertEquals((long)ledgerIds[count++], (long)ledgerId);
                }
                Assert.assertEquals((String)"Unexpected ledgers count", (long)numOfLedgers, (long)count);
                try {
                    result.iterator();
                    Assert.fail((String)"Should thrown error");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    result.toIterable();
                    Assert.fail((String)"Should thrown error");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            result = (ListLedgersResult)FutureUtils.result((CompletableFuture)bkc.newListLedgersOp().execute());
            var7_16 = null;
            try {
                int count = 0;
                for (long ledgerId : result) {
                    Assert.assertEquals((long)ledgerIds[count++], (long)ledgerId);
                }
                Assert.assertEquals((String)"Unexpected ledgers count", (long)numOfLedgers, (long)count);
                try {
                    result.iterator();
                    Assert.fail((String)"Should thrown error");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    result.toIterable();
                    Assert.fail((String)"Should thrown error");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                var7_16 = throwable;
                throw throwable;
            }
            finally {
                if (result != null) {
                    if (var7_16 != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable) {
                            var7_16.addSuppressed(throwable);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        ListLedgersResult result = (ListLedgersResult)FutureUtils.result((CompletableFuture)this.bkc.newListLedgersOp().execute());
        result.close();
        try {
            result.toIterable();
            Assert.fail((String)"Should thrown error");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            result.iterator();
            Assert.fail((String)"Should thrown error");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        result = (ListLedgersResult)FutureUtils.result((CompletableFuture)this.bkc.newListLedgersOp().execute());
        Object it = result.iterator();
        result.close();
        try {
            it.hasNext();
            Assert.fail((String)"Should thrown error");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            it.next();
            Assert.fail((String)"Should thrown error");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        result = (ListLedgersResult)FutureUtils.result((CompletableFuture)this.bkc.newListLedgersOp().execute());
        it = result.toIterable().iterator();
        result.close();
        try {
            it.hasNext();
            Assert.fail((String)"Should thrown error");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            it.next();
            Assert.fail((String)"Should thrown error");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

