/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.conf;

import org.apache.bookkeeper.common.allocator.LeakDetectionPolicy;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.meta.AbstractZkLedgerManagerFactory;
import org.apache.bookkeeper.meta.FlatLedgerManagerFactory;
import org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LongHierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.MSLedgerManagerFactory;
import org.apache.commons.configuration.ConfigurationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class AbstractConfigurationTest {
    private static final String DEFAULT_METADATA_SERVICE_URI = "zk+null://127.0.0.1/path/to/ledgers";
    private static final String HIERARCHICAL_METADATA_SERVICE_URI = "zk+hierarchical://127.0.0.1/path/to/ledgers";
    private static final String FLAT_METADATA_SERVICE_URI = "zk+flat://127.0.0.1/path/to/ledgers";
    private static final String LONGHIERARCHICAL_METADATA_SERVICE_URI = "zk+longhierarchical://127.0.0.1/path/to/ledgers";
    private static final String MS_METADATA_SERVICE_URI = "zk+ms://127.0.0.1/path/to/ledgers";
    private AbstractConfiguration conf;

    @Before
    public void setup() {
        this.conf = new ClientConfiguration();
        this.conf.setZkServers("127.0.0.1");
        this.conf.setZkLedgersRootPath("/path/to/ledgers");
    }

    @Test
    public void testDefaultServiceUri() throws Exception {
        Assert.assertEquals((Object)DEFAULT_METADATA_SERVICE_URI, (Object)this.conf.getMetadataServiceUri());
    }

    @Test
    public void testSetMetadataServiceUri() throws Exception {
        Assert.assertEquals((Object)DEFAULT_METADATA_SERVICE_URI, (Object)this.conf.getMetadataServiceUri());
        String serviceUri = "etcd://128.0.0.1/key/prefix";
        this.conf.setMetadataServiceUri(serviceUri);
        Assert.assertEquals((String)("Service URI should be changed to " + serviceUri), (Object)serviceUri, (Object)this.conf.getMetadataServiceUri());
    }

    @Test(expected=ConfigurationException.class)
    public void testUnsupportedLedgerManagerFactory() throws Exception {
        LedgerManagerFactory mockFactory = (LedgerManagerFactory)Mockito.mock(LedgerManagerFactory.class, (Answer)Mockito.CALLS_REAL_METHODS);
        this.conf.setLedgerManagerFactoryClass(mockFactory.getClass());
        this.conf.getMetadataServiceUri();
    }

    @Test
    public void testFlatLedgerManagerUri() throws Exception {
        this.conf.setLedgerManagerFactoryClass(FlatLedgerManagerFactory.class);
        Assert.assertEquals((Object)FLAT_METADATA_SERVICE_URI, (Object)this.conf.getMetadataServiceUri());
    }

    @Test
    public void testHierarchicalLedgerManagerUri() throws Exception {
        this.conf.setLedgerManagerFactoryClass(HierarchicalLedgerManagerFactory.class);
        Assert.assertEquals((Object)HIERARCHICAL_METADATA_SERVICE_URI, (Object)this.conf.getMetadataServiceUri());
    }

    @Test
    public void testLongHierarchicalLedgerManagerUri() throws Exception {
        this.conf.setLedgerManagerFactoryClass(LongHierarchicalLedgerManagerFactory.class);
        Assert.assertEquals((Object)LONGHIERARCHICAL_METADATA_SERVICE_URI, (Object)this.conf.getMetadataServiceUri());
    }

    @Test
    public void testMsLedgerManagerUri() throws Exception {
        this.conf.setLedgerManagerFactoryClass(MSLedgerManagerFactory.class);
        Assert.assertEquals((Object)MS_METADATA_SERVICE_URI, (Object)this.conf.getMetadataServiceUri());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnknownZkLedgerManagerFactory() throws Exception {
        AbstractZkLedgerManagerFactory mockZkFactory = (AbstractZkLedgerManagerFactory)Mockito.mock(AbstractZkLedgerManagerFactory.class, (Answer)Mockito.CALLS_REAL_METHODS);
        this.conf.setLedgerManagerFactoryClass(mockZkFactory.getClass());
        this.conf.getMetadataServiceUri();
    }

    @Test
    public void testAllocatorLeakDetectionPolicy() {
        String nettyOldLevelKey = "io.netty.leakDetectionLevel";
        String nettyLevelKey = "io.netty.leakDetection.level";
        String nettyOldLevelStr = System.getProperty(nettyOldLevelKey);
        String nettyLevelStr = System.getProperty(nettyLevelKey);
        System.getProperties().remove(nettyOldLevelKey);
        System.getProperties().remove(nettyLevelKey);
        Assert.assertEquals((Object)LeakDetectionPolicy.Disabled, (Object)this.conf.getAllocatorLeakDetectionPolicy());
        System.getProperties().put(nettyOldLevelKey, "zazaza");
        Assert.assertEquals((Object)LeakDetectionPolicy.Disabled, (Object)this.conf.getAllocatorLeakDetectionPolicy());
        this.conf.setProperty("allocatorLeakDetectionPolicy", (Object)"zazaza");
        Assert.assertEquals((Object)LeakDetectionPolicy.Disabled, (Object)this.conf.getAllocatorLeakDetectionPolicy());
        System.getProperties().put(nettyOldLevelKey, "simple");
        Assert.assertEquals((Object)LeakDetectionPolicy.Simple, (Object)this.conf.getAllocatorLeakDetectionPolicy());
        System.getProperties().put(nettyLevelKey, "disabled");
        Assert.assertEquals((Object)LeakDetectionPolicy.Disabled, (Object)this.conf.getAllocatorLeakDetectionPolicy());
        System.getProperties().put(nettyLevelKey, "advanCed");
        Assert.assertEquals((Object)LeakDetectionPolicy.Advanced, (Object)this.conf.getAllocatorLeakDetectionPolicy());
        this.conf.setProperty("allocatorLeakDetectionPolicy", (Object)"simPle");
        Assert.assertEquals((Object)LeakDetectionPolicy.Advanced, (Object)this.conf.getAllocatorLeakDetectionPolicy());
        this.conf.setProperty("allocatorLeakDetectionPolicy", (Object)"advanCed");
        Assert.assertEquals((Object)LeakDetectionPolicy.Advanced, (Object)this.conf.getAllocatorLeakDetectionPolicy());
        this.conf.setProperty("allocatorLeakDetectionPolicy", (Object)"paranoiD");
        Assert.assertEquals((Object)LeakDetectionPolicy.Paranoid, (Object)this.conf.getAllocatorLeakDetectionPolicy());
        System.getProperties().remove(nettyOldLevelKey);
        System.getProperties().remove(nettyLevelKey);
        if (nettyOldLevelStr != null) {
            System.getProperties().put(nettyOldLevelKey, nettyOldLevelStr);
        }
        if (nettyLevelStr != null) {
            System.getProperties().put(nettyLevelKey, nettyLevelStr);
        }
    }

    @Test
    public void testExitOnOutOfMemory() {
        Assert.assertFalse((boolean)this.conf.exitOnOutOfMemory());
        this.conf.setExitOnOutOfMemory(true);
        Assert.assertTrue((boolean)this.conf.exitOnOutOfMemory());
    }
}

