/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.MetadataClientDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class MetadataDriversTest {
    private Map<String, MetadataDrivers.MetadataClientDriverInfo> savedClientDrivers;
    private Map<String, MetadataDrivers.MetadataBookieDriverInfo> savedBookieDrivers;

    @Before
    public void setup() {
        this.savedClientDrivers = Maps.newHashMap((Map)MetadataDrivers.getClientDrivers());
        this.savedBookieDrivers = Maps.newHashMap((Map)MetadataDrivers.getBookieDrivers());
    }

    @After
    public void teardown() {
        MetadataDrivers.getClientDrivers().clear();
        MetadataDrivers.getClientDrivers().putAll(this.savedClientDrivers);
        MetadataDrivers.getBookieDrivers().clear();
        MetadataDrivers.getBookieDrivers().putAll(this.savedBookieDrivers);
    }

    @Test
    public void testDefaultDrivers() {
        MetadataClientDriver clientDriver = MetadataDrivers.getClientDriver((String)"zk");
        Assert.assertEquals((Object)"org.apache.bookkeeper.meta.zk.ZKMetadataClientDriver", (Object)clientDriver.getClass().getName());
        clientDriver = MetadataDrivers.getClientDriver((URI)URI.create("zk+hierarchical://127.0.0.1/ledgers"));
        Assert.assertEquals((Object)"org.apache.bookkeeper.meta.zk.ZKMetadataClientDriver", (Object)clientDriver.getClass().getName());
        MetadataBookieDriver bookieDriver = MetadataDrivers.getBookieDriver((String)"zk");
        Assert.assertEquals((Object)"org.apache.bookkeeper.meta.zk.ZKMetadataBookieDriver", (Object)bookieDriver.getClass().getName());
        bookieDriver = MetadataDrivers.getBookieDriver((URI)URI.create("zk+hierarchical://127.0.0.1/ledgers"));
        Assert.assertEquals((Object)"org.apache.bookkeeper.meta.zk.ZKMetadataBookieDriver", (Object)bookieDriver.getClass().getName());
    }

    @Test(expected=NullPointerException.class)
    public void testClientDriverNullScheme() {
        MetadataDrivers.getClientDriver((String)null);
    }

    @Test(expected=NullPointerException.class)
    public void testBookieDriverNullScheme() {
        MetadataDrivers.getBookieDriver((String)null);
    }

    @Test(expected=NullPointerException.class)
    public void testClientDriverNullURI() {
        MetadataDrivers.getClientDriver((URI)null);
    }

    @Test(expected=NullPointerException.class)
    public void testBookieDriverNullURI() {
        MetadataDrivers.getBookieDriver((URI)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testClientDriverUnknownScheme() {
        MetadataDrivers.getClientDriver((String)"unknown");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBookieDriverUnknownScheme() {
        MetadataDrivers.getBookieDriver((String)"unknown");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testClientDriverUnknownSchemeURI() {
        MetadataDrivers.getClientDriver((URI)URI.create("unknown://"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBookieDriverUnknownSchemeURI() {
        MetadataDrivers.getBookieDriver((URI)URI.create("unknown://"));
    }

    @Test(expected=NullPointerException.class)
    public void testClientDriverNullSchemeURI() {
        MetadataDrivers.getClientDriver((URI)URI.create("//127.0.0.1/ledgers"));
    }

    @Test(expected=NullPointerException.class)
    public void testBookieDriverNullSchemeURI() {
        MetadataDrivers.getBookieDriver((URI)URI.create("//127.0.0.1/ledgers"));
    }

    @Test
    public void testClientDriverLowerUpperCasedSchemes() {
        String[] schemes;
        for (String scheme : schemes = new String[]{"zk", "Zk", "zK", "ZK"}) {
            MetadataClientDriver clientDriver = MetadataDrivers.getClientDriver((String)scheme);
            Assert.assertEquals((Object)"org.apache.bookkeeper.meta.zk.ZKMetadataClientDriver", (Object)clientDriver.getClass().getName());
        }
    }

    @Test
    public void testBookieDriverLowerUpperCasedSchemes() {
        String[] schemes;
        for (String scheme : schemes = new String[]{"zk", "Zk", "zK", "ZK"}) {
            MetadataBookieDriver bookieDriver = MetadataDrivers.getBookieDriver((String)scheme);
            Assert.assertEquals((Object)"org.apache.bookkeeper.meta.zk.ZKMetadataBookieDriver", (Object)bookieDriver.getClass().getName());
        }
    }

    @Test
    public void testRegisterClientDriver() throws Exception {
        MetadataClientDriver clientDriver = (MetadataClientDriver)Mockito.mock(MetadataClientDriver.class);
        Mockito.when((Object)clientDriver.getScheme()).thenReturn((Object)"testdriver");
        try {
            MetadataDrivers.getClientDriver((String)clientDriver.getScheme());
            Assert.fail((String)"Should fail to get client driver if it is not registered");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        MetadataDrivers.registerClientDriver((String)clientDriver.getScheme(), clientDriver.getClass());
        MetadataClientDriver driver = MetadataDrivers.getClientDriver((String)clientDriver.getScheme());
        Assert.assertEquals(clientDriver.getClass(), driver.getClass());
    }

    @Test
    public void testRegisterBookieDriver() throws Exception {
        MetadataBookieDriver bookieDriver = (MetadataBookieDriver)Mockito.mock(MetadataBookieDriver.class);
        Mockito.when((Object)bookieDriver.getScheme()).thenReturn((Object)"testdriver");
        try {
            MetadataDrivers.getBookieDriver((String)bookieDriver.getScheme());
            Assert.fail((String)"Should fail to get bookie driver if it is not registered");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        MetadataDrivers.registerBookieDriver((String)bookieDriver.getScheme(), bookieDriver.getClass());
        MetadataBookieDriver driver = MetadataDrivers.getBookieDriver((String)bookieDriver.getScheme());
        Assert.assertEquals(bookieDriver.getClass(), driver.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadClientDriverFromSystemProperty() throws Exception {
        String saveDriversStr = System.getProperty("bookkeeper.metadata.client.drivers");
        try {
            System.setProperty("bookkeeper.metadata.client.drivers", StringUtils.join((Object[])new String[]{ClientDriver1.class.getName(), ClientDriver2.class.getName()}, (char)':'));
            MetadataDrivers.loadInitialDrivers();
            MetadataClientDriver loadedDriver1 = MetadataDrivers.getClientDriver((String)"driver1");
            Assert.assertEquals(ClientDriver1.class, loadedDriver1.getClass());
            MetadataClientDriver loadedDriver2 = MetadataDrivers.getClientDriver((String)"driver2");
            Assert.assertEquals(ClientDriver2.class, loadedDriver2.getClass());
        }
        finally {
            if (null != saveDriversStr) {
                System.setProperty("bookkeeper.metadata.client.drivers", saveDriversStr);
            } else {
                System.clearProperty("bookkeeper.metadata.client.drivers");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadBookieDriverFromSystemProperty() throws Exception {
        String saveDriversStr = System.getProperty("bookkeeper.metadata.bookie.drivers");
        try {
            System.setProperty("bookkeeper.metadata.bookie.drivers", StringUtils.join((Object[])new String[]{BookieDriver1.class.getName(), BookieDriver2.class.getName()}, (char)':'));
            MetadataDrivers.loadInitialDrivers();
            MetadataBookieDriver loadedDriver1 = MetadataDrivers.getBookieDriver((String)"driver1");
            Assert.assertEquals(BookieDriver1.class, loadedDriver1.getClass());
            MetadataBookieDriver loadedDriver2 = MetadataDrivers.getBookieDriver((String)"driver2");
            Assert.assertEquals(BookieDriver2.class, loadedDriver2.getClass());
        }
        finally {
            if (null != saveDriversStr) {
                System.setProperty("bookkeeper.metadata.bookie.drivers", saveDriversStr);
            } else {
                System.clearProperty("bookkeeper.metadata.bookie.drivers");
            }
        }
    }

    static class BookieDriver2
    extends TestBookieDriver {
        BookieDriver2() {
        }

        public String getScheme() {
            return "driver2";
        }
    }

    static class BookieDriver1
    extends TestBookieDriver {
        BookieDriver1() {
        }

        public String getScheme() {
            return "driver1";
        }
    }

    static abstract class TestBookieDriver
    implements MetadataBookieDriver {
        TestBookieDriver() {
        }

        public MetadataBookieDriver initialize(ServerConfiguration conf, StatsLogger statsLogger) throws MetadataException {
            return this;
        }

        public RegistrationManager createRegistrationManager() {
            return (RegistrationManager)Mockito.mock(RegistrationManager.class);
        }

        public LedgerManagerFactory getLedgerManagerFactory() throws MetadataException {
            return (LedgerManagerFactory)Mockito.mock(LedgerManagerFactory.class);
        }

        public LayoutManager getLayoutManager() {
            return (LayoutManager)Mockito.mock(LayoutManager.class);
        }

        public void close() {
        }
    }

    static class ClientDriver2
    extends TestClientDriver {
        ClientDriver2() {
        }

        public String getScheme() {
            return "driver2";
        }
    }

    static class ClientDriver1
    extends TestClientDriver {
        ClientDriver1() {
        }

        public String getScheme() {
            return "driver1";
        }
    }

    static abstract class TestClientDriver
    implements MetadataClientDriver {
        TestClientDriver() {
        }

        public MetadataClientDriver initialize(ClientConfiguration conf, ScheduledExecutorService scheduler, StatsLogger statsLogger, Optional<Object> ctx) throws MetadataException {
            return this;
        }

        public RegistrationClient getRegistrationClient() {
            return (RegistrationClient)Mockito.mock(RegistrationClient.class);
        }

        public LedgerManagerFactory getLedgerManagerFactory() throws MetadataException {
            return (LedgerManagerFactory)Mockito.mock(LedgerManagerFactory.class);
        }

        public LayoutManager getLayoutManager() {
            return (LayoutManager)Mockito.mock(LayoutManager.class);
        }

        public void close() {
        }

        public void setSessionStateListener(MetadataClientDriver.SessionStateListener sessionStateListener) {
        }
    }
}

