/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerMetadataSerDe;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.zookeeper.AsyncCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockLedgerManager
implements LedgerManager {
    static final Logger LOG = LoggerFactory.getLogger(MockLedgerManager.class);
    final Map<Long, Pair<LongVersion, byte[]>> metadataMap;
    final ExecutorService executor;
    final boolean ownsExecutor;
    final LedgerMetadataSerDe serDe;
    private Hook preWriteHook = (ledgerId, metadata) -> FutureUtils.value(null);

    public MockLedgerManager() {
        this(new ConcurrentHashMap<Long, Pair<LongVersion, byte[]>>(), Executors.newSingleThreadExecutor(r -> new Thread(r, "MockLedgerManager")), true);
    }

    private MockLedgerManager(Map<Long, Pair<LongVersion, byte[]>> metadataMap, ExecutorService executor, boolean ownsExecutor) {
        this.metadataMap = metadataMap;
        this.executor = executor;
        this.ownsExecutor = ownsExecutor;
        this.serDe = new LedgerMetadataSerDe();
    }

    public MockLedgerManager newClient() {
        return new MockLedgerManager(this.metadataMap, this.executor, false);
    }

    private Versioned<LedgerMetadata> readMetadata(long ledgerId) throws Exception {
        Pair<LongVersion, byte[]> pair = this.metadataMap.get(ledgerId);
        if (pair == null) {
            return null;
        }
        return new Versioned((Object)this.serDe.parseConfig((byte[])pair.getRight(), ledgerId, Optional.empty()), (Version)pair.getLeft());
    }

    public void setPreWriteHook(Hook hook) {
        this.preWriteHook = hook;
    }

    public void executeCallback(Runnable r) {
        r.run();
    }

    public CompletableFuture<Versioned<LedgerMetadata>> createLedgerMetadata(long ledgerId, LedgerMetadata metadata) {
        CompletableFuture<Versioned<LedgerMetadata>> promise = new CompletableFuture<Versioned<LedgerMetadata>>();
        this.executor.submit(() -> {
            if (this.metadataMap.containsKey(ledgerId)) {
                this.executeCallback(() -> promise.completeExceptionally((Throwable)new BKException.BKLedgerExistException()));
            } else {
                try {
                    this.metadataMap.put(ledgerId, (Pair<LongVersion, byte[]>)Pair.of((Object)new LongVersion(0L), (Object)this.serDe.serialize(metadata)));
                    Versioned<LedgerMetadata> readBack = this.readMetadata(ledgerId);
                    this.executeCallback(() -> promise.complete(readBack));
                }
                catch (Exception e) {
                    LOG.error("Error reading back written metadata", (Throwable)e);
                    this.executeCallback(() -> promise.completeExceptionally((Throwable)new BKException.MetaStoreException()));
                }
            }
        });
        return promise;
    }

    public CompletableFuture<Void> removeLedgerMetadata(long ledgerId, Version version) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Versioned<LedgerMetadata>> readLedgerMetadata(long ledgerId) {
        CompletableFuture<Versioned<LedgerMetadata>> promise = new CompletableFuture<Versioned<LedgerMetadata>>();
        this.executor.submit(() -> {
            try {
                Versioned<LedgerMetadata> metadata = this.readMetadata(ledgerId);
                if (metadata == null) {
                    this.executeCallback(() -> promise.completeExceptionally((Throwable)new BKException.BKNoSuchLedgerExistsOnMetadataServerException()));
                } else {
                    this.executeCallback(() -> promise.complete(metadata));
                }
            }
            catch (Exception e) {
                LOG.error("Error reading metadata", (Throwable)e);
                this.executeCallback(() -> promise.completeExceptionally((Throwable)new BKException.MetaStoreException()));
            }
        });
        return promise;
    }

    public CompletableFuture<Versioned<LedgerMetadata>> writeLedgerMetadata(long ledgerId, LedgerMetadata metadata, Version currentVersion) {
        CompletableFuture<Versioned<LedgerMetadata>> promise = new CompletableFuture<Versioned<LedgerMetadata>>();
        ((CompletableFuture)this.preWriteHook.runHook(ledgerId, metadata).thenComposeAsync(ignore -> {
            try {
                Versioned<LedgerMetadata> oldMetadata = this.readMetadata(ledgerId);
                if (oldMetadata == null) {
                    return FutureUtils.exception((Throwable)new BKException.BKNoSuchLedgerExistsOnMetadataServerException());
                }
                if (!oldMetadata.getVersion().equals(currentVersion)) {
                    return FutureUtils.exception((Throwable)new BKException.BKMetadataVersionException());
                }
                LongVersion oldVersion = (LongVersion)oldMetadata.getVersion();
                this.metadataMap.put(ledgerId, (Pair<LongVersion, byte[]>)Pair.of((Object)new LongVersion(oldVersion.getLongVersion() + 1L), (Object)this.serDe.serialize(metadata)));
                Versioned<LedgerMetadata> readBack = this.readMetadata(ledgerId);
                return FutureUtils.value(readBack);
            }
            catch (Exception e) {
                LOG.error("Error writing metadata", (Throwable)e);
                return FutureUtils.exception((Throwable)e);
            }
        }, (Executor)this.executor)).whenComplete((res, ex) -> {
            if (ex != null) {
                Throwable cause = ex instanceof CompletionException ? ex.getCause() : ex;
                this.executeCallback(() -> promise.completeExceptionally(cause));
            } else {
                this.executeCallback(() -> promise.complete((Versioned<LedgerMetadata>)res));
            }
        });
        return promise;
    }

    public void registerLedgerMetadataListener(long ledgerId, BookkeeperInternalCallbacks.LedgerMetadataListener listener) {
    }

    public void unregisterLedgerMetadataListener(long ledgerId, BookkeeperInternalCallbacks.LedgerMetadataListener listener) {
    }

    public void asyncProcessLedgers(BookkeeperInternalCallbacks.Processor<Long> processor, AsyncCallback.VoidCallback finalCb, Object context, int successRc, int failureRc) {
    }

    public LedgerManager.LedgerRangeIterator getLedgerRanges(long zkOpTimeoutMs) {
        ArrayList<Long> ledgerIds = new ArrayList<Long>(this.metadataMap.keySet());
        ledgerIds.sort(Comparator.naturalOrder());
        final List partitions = Lists.partition(ledgerIds, (int)100);
        return new LedgerManager.LedgerRangeIterator(){
            int i = 0;

            public boolean hasNext() {
                return this.i < partitions.size();
            }

            public LedgerManager.LedgerRange next() {
                return new LedgerManager.LedgerRange(new HashSet((Collection)partitions.get(this.i++)));
            }
        };
    }

    public void close() {
        if (this.ownsExecutor) {
            this.executor.shutdownNow();
        }
    }

    public static interface Hook {
        public CompletableFuture<Void> runHook(long var1, LedgerMetadata var3);
    }
}

