/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import org.apache.bookkeeper.auth.AuthCallbacks;
import org.apache.bookkeeper.auth.AuthToken;
import org.apache.bookkeeper.auth.ClientAuthProvider;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.ClientConnectionPeer;
import org.apache.bookkeeper.replication.AutoRecoveryMain;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthAutoRecoveryTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AuthAutoRecoveryTest.class);
    public static final String TEST_AUTH_PROVIDER_PLUGIN_NAME = "TestAuthProviderPlugin";
    private static String clientSideRole;

    @Override
    protected ServerConfiguration newServerConfiguration() throws Exception {
        ServerConfiguration conf = super.newServerConfiguration();
        conf.setClientAuthProviderFactoryClass(AuditorClientAuthInterceptorFactory.class.getName());
        return conf;
    }

    public AuthAutoRecoveryTest() {
        super(6);
    }

    @Test
    public void testAuthClientRole() throws Exception {
        ServerConfiguration config = this.confByIndex(0);
        Assert.assertEquals((Object)AuditorClientAuthInterceptorFactory.class.getName(), (Object)config.getClientAuthProviderFactoryClass());
        AutoRecoveryMain main = new AutoRecoveryMain(config);
        try {
            main.start();
            Thread.sleep(500L);
            Assert.assertTrue((String)"AuditorElector should be running", (boolean)main.auditorElector.isRunning());
            Assert.assertTrue((String)"Replication worker should be running", (boolean)main.replicationWorker.isRunning());
        }
        finally {
            main.shutdown();
        }
        Assert.assertEquals((Object)"system", (Object)clientSideRole);
    }

    private static class AuditorClientAuthInterceptorFactory
    implements ClientAuthProvider.Factory {
        private AuditorClientAuthInterceptorFactory() {
        }

        public String getPluginName() {
            return AuthAutoRecoveryTest.TEST_AUTH_PROVIDER_PLUGIN_NAME;
        }

        public void init(ClientConfiguration conf) {
            clientSideRole = conf.getClientRole();
        }

        public ClientAuthProvider newProvider(ClientConnectionPeer addr, final AuthCallbacks.GenericCallback<Void> completeCb) {
            return new ClientAuthProvider(){

                public void init(AuthCallbacks.GenericCallback<AuthToken> cb) {
                    completeCb.operationComplete(0, null);
                }

                public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
                }
            };
        }
    }
}

