/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.server.http.service.TriggerGCService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerGCServiceTest {
    private static final Logger log = LoggerFactory.getLogger(TriggerGCServiceTest.class);
    private TriggerGCService service;
    private BookieServer mockBookieServer;
    private LedgerStorage mockLedgerStorage;

    @Before
    public void setup() {
        this.mockBookieServer = (BookieServer)Mockito.mock(BookieServer.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.mockLedgerStorage = (LedgerStorage)Mockito.mock(DbLedgerStorage.class);
        Mockito.when((Object)this.mockBookieServer.getBookie().getLedgerStorage()).thenReturn((Object)this.mockLedgerStorage);
        Mockito.when((Object)this.mockLedgerStorage.isInForceGC()).thenReturn((Object)false);
        Mockito.when((Object)this.mockLedgerStorage.isMajorGcSuspended()).thenReturn((Object)false);
        Mockito.when((Object)this.mockLedgerStorage.isMinorGcSuspended()).thenReturn((Object)false);
        this.service = new TriggerGCService(new ServerConfiguration(), this.mockBookieServer);
    }

    @Test
    public void testHandleRequest() throws Exception {
        HttpServiceRequest request = new HttpServiceRequest();
        request.setMethod(HttpServer.Method.PUT);
        HttpServiceResponse resp = this.service.handle(request);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)resp.getStatusCode());
        Assert.assertEquals((Object)("\"Triggered GC on BookieServer: " + this.mockBookieServer.getBookieId() + "\""), (Object)resp.getBody());
        request = new HttpServiceRequest();
        request.setMethod(HttpServer.Method.PUT);
        request.setBody("test");
        resp = this.service.handle(request);
        Assert.assertEquals((long)HttpServer.StatusCode.BAD_REQUEST.getValue(), (long)resp.getStatusCode());
        Assert.assertEquals((Object)"Failed to handle the request, exception: Failed to deserialize Object from Json string", (Object)resp.getBody());
        request = new HttpServiceRequest();
        request.setMethod(HttpServer.Method.PUT);
        request.setBody("{\"test\":1}");
        resp = this.service.handle(request);
        ((LedgerStorage)Mockito.verify((Object)this.mockLedgerStorage, (VerificationMode)Mockito.times((int)1))).forceGC(ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)true));
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)resp.getStatusCode());
        Assert.assertEquals((Object)("\"Triggered GC on BookieServer: " + this.mockBookieServer.getBookieId() + "\""), (Object)resp.getBody());
        request = new HttpServiceRequest();
        request.setMethod(HttpServer.Method.PUT);
        request.setBody("{\"test\":1,\"forceMajor\":true}");
        resp = this.service.handle(request);
        ((LedgerStorage)Mockito.verify((Object)this.mockLedgerStorage, (VerificationMode)Mockito.times((int)2))).forceGC(ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)true));
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)resp.getStatusCode());
        Assert.assertEquals((Object)("\"Triggered GC on BookieServer: " + this.mockBookieServer.getBookieId() + "\""), (Object)resp.getBody());
        request = new HttpServiceRequest();
        request.setMethod(HttpServer.Method.PUT);
        request.setBody("{\"test\":1,\"forceMajor\":\"true\"}");
        resp = this.service.handle(request);
        ((LedgerStorage)Mockito.verify((Object)this.mockLedgerStorage, (VerificationMode)Mockito.times((int)3))).forceGC(ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)true));
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)resp.getStatusCode());
        Assert.assertEquals((Object)("\"Triggered GC on BookieServer: " + this.mockBookieServer.getBookieId() + "\""), (Object)resp.getBody());
        request = new HttpServiceRequest();
        request.setMethod(HttpServer.Method.PUT);
        request.setBody("{\"test\":1,\"forceMajor\":false}");
        resp = this.service.handle(request);
        ((LedgerStorage)Mockito.verify((Object)this.mockLedgerStorage, (VerificationMode)Mockito.times((int)1))).forceGC(ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)true));
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)resp.getStatusCode());
        Assert.assertEquals((Object)("\"Triggered GC on BookieServer: " + this.mockBookieServer.getBookieId() + "\""), (Object)resp.getBody());
        request = new HttpServiceRequest();
        request.setMethod(HttpServer.Method.PUT);
        request.setBody("{\"test\":1,\"forceMinor\":true}");
        resp = this.service.handle(request);
        ((LedgerStorage)Mockito.verify((Object)this.mockLedgerStorage, (VerificationMode)Mockito.times((int)4))).forceGC(ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)true));
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)resp.getStatusCode());
        Assert.assertEquals((Object)("\"Triggered GC on BookieServer: " + this.mockBookieServer.getBookieId() + "\""), (Object)resp.getBody());
        request = new HttpServiceRequest();
        request.setMethod(HttpServer.Method.GET);
        resp = this.service.handle(request);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)resp.getStatusCode());
        Assert.assertEquals((Object)"{\n  \"is_in_force_gc\" : \"false\"\n}", (Object)resp.getBody());
        request = new HttpServiceRequest();
        request.setMethod(HttpServer.Method.POST);
        resp = this.service.handle(request);
        Assert.assertEquals((long)HttpServer.StatusCode.METHOD_NOT_ALLOWED.getValue(), (long)resp.getStatusCode());
        Assert.assertEquals((Object)"Not allowed method. Should be PUT to trigger GC, Or GET to get Force GC state.", (Object)resp.getBody());
    }
}

