/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperTestClient;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieFailureTest
extends BookKeeperClusterTestCase
implements AsyncCallback.AddCallback,
AsyncCallback.ReadCallback {
    private static final Logger LOG = LoggerFactory.getLogger(BookieFailureTest.class);
    byte[] ledgerPassword = "aaa".getBytes();
    LedgerHandle lh;
    LedgerHandle lh2;
    long ledgerId;
    int numEntriesToWrite = 200;
    int maxInt = Integer.MAX_VALUE;
    Random rng;
    ArrayList<byte[]> entries;
    ArrayList<Integer> entriesSize;
    private final BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;

    public BookieFailureTest() {
        super(4);
        String ledgerManagerFactory = "org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory";
        this.baseConf.setLedgerManagerFactoryClassName(ledgerManagerFactory);
        this.baseClientConf.setLedgerManagerFactoryClassName(ledgerManagerFactory);
    }

    @Test
    public void testAsyncBK1() throws Exception {
        LOG.info("#### BK1 ####");
        this.auxTestReadWriteAsyncSingleClient(this.serverByIndex(0));
    }

    @Test
    public void testAsyncBK2() throws Exception {
        LOG.info("#### BK2 ####");
        this.auxTestReadWriteAsyncSingleClient(this.serverByIndex(1));
    }

    @Test
    public void testAsyncBK3() throws Exception {
        LOG.info("#### BK3 ####");
        this.auxTestReadWriteAsyncSingleClient(this.serverByIndex(2));
    }

    @Test
    public void testAsyncBK4() throws Exception {
        LOG.info("#### BK4 ####");
        this.auxTestReadWriteAsyncSingleClient(this.serverByIndex(3));
    }

    @Test
    public void testBookieRecovery() throws Exception {
        Assert.assertEquals((long)4L, (long)this.bookieCount());
        this.killBookie(0);
        this.killBookie(0);
        this.killBookie(0);
        byte[] passwd = "blah".getBytes();
        LedgerHandle lh = this.bkc.createLedger(1, 1, this.digestType, passwd);
        int numEntries = 100;
        for (int i = 0; i < numEntries; ++i) {
            byte[] data = ("" + i).getBytes();
            lh.addEntry(data);
        }
        Assert.assertEquals((long)1L, (long)this.bookieCount());
        this.restartBookies();
        Assert.assertEquals((long)(numEntries - 1), (long)lh.getLastAddConfirmed());
        Enumeration entries = lh.readEntries(0L, lh.getLastAddConfirmed());
        int numScanned = 0;
        while (entries.hasMoreElements()) {
            Assert.assertEquals((Object)("" + numScanned), (Object)new String(((LedgerEntry)entries.nextElement()).getEntry()));
            ++numScanned;
        }
        Assert.assertEquals((long)numEntries, (long)numScanned);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void auxTestReadWriteAsyncSingleClient(BookieServer bs) throws IOException {
        SyncObj sync = new SyncObj();
        try {
            this.lh = this.bkc.createLedger(3, 2, this.digestType, this.ledgerPassword);
            this.ledgerId = this.lh.getId();
            LOG.info("Ledger ID: " + this.lh.getId());
            for (int i = 0; i < this.numEntriesToWrite; ++i) {
                ByteBuffer entry = ByteBuffer.allocate(4);
                entry.putInt(this.rng.nextInt(this.maxInt));
                entry.position(0);
                this.entries.add(entry.array());
                this.entriesSize.add(entry.array().length);
                this.lh.asyncAddEntry(entry.array(), (AsyncCallback.AddCallback)this, (Object)sync);
            }
            LOG.info("Wrote " + this.numEntriesToWrite + " and now going to fail bookie.");
            bs.shutdown();
            SyncObj i = sync;
            synchronized (i) {
                while (sync.counter < this.numEntriesToWrite) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Entries counter = " + sync.counter);
                    }
                    sync.wait(10000L);
                    Assert.assertFalse((String)"Failure occurred during write", (boolean)sync.failureOccurred);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("*** WRITE COMPLETE ***");
            }
            this.lh.close();
            this.bkc.close();
            this.bkc = new BookKeeperTestClient(this.baseClientConf);
            this.lh = this.bkc.openLedger(this.ledgerId, this.digestType, this.ledgerPassword);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Number of entries written: " + (this.lh.getLastAddConfirmed() + 1L));
            }
            Assert.assertTrue((String)"Verifying number of entries written", (this.lh.getLastAddConfirmed() == (long)(this.numEntriesToWrite - 1) ? 1 : 0) != 0);
            this.lh.asyncReadEntries(0L, (long)(this.numEntriesToWrite - 1), (AsyncCallback.ReadCallback)this, (Object)sync);
            i = sync;
            synchronized (i) {
                boolean i2 = false;
                sync.wait(10000L);
                Assert.assertFalse((String)"Failure occurred during read", (boolean)sync.failureOccurred);
                Assert.assertTrue((String)"Haven't received entries", (boolean)sync.value);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("*** READ COMPLETE ***");
            }
            int i2 = 0;
            while (sync.ls.hasMoreElements()) {
                ByteBuffer origbb = ByteBuffer.wrap(this.entries.get(i2));
                Integer origEntry = origbb.getInt();
                byte[] entry = sync.ls.nextElement().getEntry();
                ByteBuffer result = ByteBuffer.wrap(entry);
                Integer retrEntry = result.getInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Retrieved entry: " + i2);
                }
                Assert.assertTrue((String)("Checking entry " + i2 + " for equality"), (boolean)origEntry.equals(retrEntry));
                Assert.assertTrue((String)("Checking entry " + i2 + " for size"), (entry.length == this.entriesSize.get(i2) ? 1 : 0) != 0);
                ++i2;
            }
            Assert.assertTrue((String)"Checking number of read entries", (i2 == this.numEntriesToWrite ? 1 : 0) != 0);
            LOG.info("Verified that entries are ok, and now closing ledger");
            this.lh.close();
        }
        catch (BKException e) {
            LOG.error("Caught BKException", (Throwable)e);
            Assert.fail((String)e.toString());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Caught InterruptedException", (Throwable)e);
            Assert.fail((String)e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
        SyncObj x = (SyncObj)ctx;
        if (rc != 0) {
            LOG.error("Failure during add {} {}", (Object)entryId, (Object)rc);
            x.failureOccurred = true;
        }
        SyncObj syncObj = x;
        synchronized (syncObj) {
            ++x.counter;
            x.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readComplete(int rc, LedgerHandle lh, Enumeration<LedgerEntry> seq, Object ctx) {
        SyncObj x = (SyncObj)ctx;
        if (rc != 0) {
            LOG.error("Failure during add {}", (Object)rc);
            x.failureOccurred = true;
        }
        SyncObj syncObj = x;
        synchronized (syncObj) {
            x.value = true;
            x.ls = seq;
            x.notify();
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rng = new Random(System.currentTimeMillis());
        this.entries = new ArrayList();
        this.entriesSize = new ArrayList();
        this.zkc.close();
    }

    @Test
    public void testLedgerNoRecoveryOpenAfterBKCrashed() throws Exception {
        LedgerHandle beforelh = this.bkc.createLedger(this.numBookies, this.numBookies, this.digestType, "".getBytes());
        int numEntries = 10;
        String tmp = "BookKeeper is cool!";
        for (int i = 0; i < numEntries; ++i) {
            beforelh.addEntry(tmp.getBytes());
        }
        this.killBookie(0);
        LedgerHandle afterlh = this.bkc.openLedgerNoRecovery(beforelh.getId(), this.digestType, "".getBytes());
        Assert.assertEquals((long)(numEntries - 2), (long)afterlh.getLastAddConfirmed());
    }

    @Test
    public void testLedgerOpenAfterBKCrashed() throws Exception {
        LedgerHandle beforelh = this.bkc.createLedger(this.numBookies, this.numBookies, this.digestType, "".getBytes());
        int numEntries = 10;
        String tmp = "BookKeeper is cool!";
        for (int i = 0; i < numEntries; ++i) {
            beforelh.addEntry(tmp.getBytes());
        }
        this.killBookie(0);
        this.startNewBookie();
        LedgerHandle afterlh = this.bkc.openLedger(beforelh.getId(), this.digestType, "".getBytes());
        Assert.assertEquals((long)beforelh.getLastAddPushed(), (long)afterlh.getLastAddConfirmed());
        LedgerHandle beforelhWithNoRecovery = this.bkc.createLedger(this.numBookies - 1, 2, this.digestType, "".getBytes());
        for (int i = 0; i < numEntries; ++i) {
            beforelhWithNoRecovery.addEntry(tmp.getBytes());
        }
        this.killBookie(0);
        this.bkc.openLedger(beforelhWithNoRecovery.getId(), this.digestType, "".getBytes());
    }

    @Test
    public void testReadLastConfirmedOp() throws Exception {
        this.startNewBookie();
        this.startNewBookie();
        LedgerHandle beforelh = this.bkc.createLedger(this.numBookies + 2, this.numBookies + 2, this.digestType, "".getBytes());
        int numEntries = 10;
        String tmp = "BookKeeper is cool!";
        for (int i = 0; i < numEntries; ++i) {
            beforelh.addEntry(tmp.getBytes());
        }
        this.killBookie(0);
        this.startNewBookie();
        BookKeeperTestClient bkc1 = new BookKeeperTestClient(this.baseClientConf);
        LedgerHandle afterlh = bkc1.openLedger(beforelh.getId(), this.digestType, "".getBytes());
        Assert.assertEquals((String)"Entries got missed", (long)beforelh.getLastAddPushed(), (long)afterlh.getLastAddConfirmed());
        bkc1.close();
    }

    class SyncObj {
        int counter = 0;
        boolean value = false;
        boolean failureOccurred = false;
        Enumeration<LedgerEntry> ls = null;
    }
}

