/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.io.File;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.test.BookieJournalRollingTest;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieJournalRollingWithReuseJournalTest
extends BookieJournalRollingTest {
    private static final Logger log = LoggerFactory.getLogger(BookieJournalRollingWithReuseJournalTest.class);

    @Override
    @Before
    public void setUp() throws Exception {
        this.baseConf.setJournalReuseFiles(true);
        super.setUp();
    }

    @Override
    @Test
    public void testJournalRolling() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Testing Journal Rolling");
        }
        LedgerHandle[] lhs = this.writeLedgerEntries(10, 1024, 1024);
        long[] ledgerIds = new long[lhs.length];
        for (int i = 0; i < lhs.length; ++i) {
            ledgerIds[i] = lhs[i].getId();
            lhs[i].close();
        }
        Awaitility.await().untilAsserted(() -> {
            for (File journalDir : this.bookieJournalDirs()) {
                File[] journals = journalDir.listFiles();
                int numJournals = 0;
                for (File f : journals) {
                    if (!f.getName().endsWith(".txn")) continue;
                    ++numJournals;
                }
                Assert.assertTrue((numJournals <= 2 ? 1 : 0) != 0);
            }
        });
        this.restartBookies();
        this.validLedgerEntries(ledgerIds, 1024, 1024);
    }
}

