/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.io.File;
import java.util.Enumeration;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForceReadOnlyBookieTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ForceReadOnlyBookieTest.class);

    public ForceReadOnlyBookieTest() {
        super(2);
        this.baseConf.setLedgerStorageClass(InterleavedLedgerStorage.class.getName());
        this.baseConf.setEntryLogFilePreAllocationEnabled(false);
    }

    @Test
    public void testBookieForceStartAsReadOnly() throws Exception {
        LedgerHandle ledger = this.bkc.createLedger(2, 2, BookKeeper.DigestType.MAC, "".getBytes());
        for (int i = 0; i < 10; ++i) {
            ledger.addEntry("data".getBytes());
        }
        ledger.close();
        LOG.info("successed prepare");
        this.confByIndex(1).setReadOnlyModeEnabled(true);
        this.confByIndex(1).setForceReadOnlyBookie(true);
        this.restartBookies();
        Bookie bookie = this.serverByIndex(1).getBookie();
        Assert.assertTrue((String)"Bookie should be running and in readonly mode", (bookie.isRunning() && bookie.isReadOnly() ? 1 : 0) != 0);
        LOG.info("successed force start ReadOnlyBookie");
        File[] ledgerDirs = this.confByIndex(1).getLedgerDirs();
        Assert.assertEquals((String)"Only one ledger dir should be present", (long)1L, (long)ledgerDirs.length);
        this.killBookie(0);
        Enumeration readEntries = ledger.readEntries(0L, 9L);
        while (readEntries.hasMoreElements()) {
            LedgerEntry entry = (LedgerEntry)readEntries.nextElement();
            Assert.assertEquals((String)"Entry should contain correct data", (Object)"data", (Object)new String(entry.getEntry()));
        }
        LOG.info("successed read entry from ReadOnlyBookie");
        LedgerDirsManager ledgerDirsManager = ((BookieImpl)bookie).getLedgerDirsManager();
        ledgerDirsManager.addToWritableDirs(new File(ledgerDirs[0], "current"), true);
        Assert.assertTrue((String)"Bookie should be running and in readonly mode", (bookie.isRunning() && bookie.isReadOnly() ? 1 : 0) != 0);
        LOG.info("successed: bookie still readonly");
    }
}

