/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.test.ZooKeeperCluster;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperUtil
implements ZooKeeperCluster {
    static final Logger LOG;
    protected Integer zooKeeperPort = 0;
    private InetSocketAddress zkaddr;
    protected ZooKeeperServer zks;
    protected ZooKeeper zkc;
    protected NIOServerCnxnFactory serverFactory;
    protected File zkTmpDir;
    private String connectString;

    public ZooKeeperUtil() {
        String loopbackIPAddr = InetAddress.getLoopbackAddress().getHostAddress();
        this.zkaddr = new InetSocketAddress(loopbackIPAddr, 0);
        this.connectString = loopbackIPAddr + ":" + this.zooKeeperPort;
    }

    @Override
    public ZooKeeper getZooKeeperClient() {
        return this.zkc;
    }

    @Override
    public String getZooKeeperConnectString() {
        return this.connectString;
    }

    @Override
    public String getMetadataServiceUri() {
        return this.getMetadataServiceUri("/ledgers");
    }

    @Override
    public String getMetadataServiceUri(String zkLedgersRootPath) {
        return "zk://" + this.connectString + zkLedgersRootPath;
    }

    @Override
    public String getMetadataServiceUri(String zkLedgersRootPath, String type) {
        return "zk+" + type + "://" + this.connectString + zkLedgersRootPath;
    }

    @Override
    public void startCluster() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running ZK server");
        }
        ClientBase.setupTestEnv();
        this.zkTmpDir = IOUtils.createTempDir((String)"zookeeper", (String)"test");
        this.restartCluster();
        this.createBKEnsemble("/ledgers");
    }

    @Override
    public void restartCluster() throws Exception {
        this.zks = new ZooKeeperServer(this.zkTmpDir, this.zkTmpDir, 3000);
        this.serverFactory = new NIOServerCnxnFactory();
        this.serverFactory.configure(this.zkaddr, 100);
        this.serverFactory.startup(this.zks);
        if (0 == this.zooKeeperPort) {
            this.zooKeeperPort = this.serverFactory.getLocalPort();
            this.zkaddr = new InetSocketAddress(this.zkaddr.getHostName(), (int)this.zooKeeperPort);
            this.connectString = this.zkaddr.getHostName() + ":" + this.zooKeeperPort;
        }
        boolean b = ClientBase.waitForServerUp((String)this.getZooKeeperConnectString(), (long)ClientBase.CONNECTION_TIMEOUT);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Server up: " + b);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Instantiate ZK Client");
        }
        this.zkc = ZooKeeperClient.newBuilder().connectString(this.getZooKeeperConnectString()).sessionTimeoutMs(10000).build();
    }

    @Override
    public void sleepCluster(final int time, final TimeUnit timeUnit, final CountDownLatch l) throws InterruptedException, IOException {
        Thread[] allthreads = new Thread[Thread.activeCount()];
        Thread.enumerate(allthreads);
        for (final Thread t : allthreads) {
            if (!t.getName().contains("SyncThread:0")) continue;
            Thread sleeper = new Thread(){

                @Override
                public void run() {
                    try {
                        t.suspend();
                        l.countDown();
                        timeUnit.sleep(time);
                        t.resume();
                    }
                    catch (Exception e) {
                        LOG.error("Error suspending thread", (Throwable)e);
                    }
                }
            };
            sleeper.start();
            return;
        }
        throw new IOException("ZooKeeper thread not found");
    }

    @Override
    public void stopCluster() throws Exception {
        if (this.zkc != null) {
            this.zkc.close();
        }
        if (this.serverFactory != null) {
            this.serverFactory.shutdown();
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown((String)this.getZooKeeperConnectString(), (long)ClientBase.CONNECTION_TIMEOUT));
        }
        if (this.zks != null) {
            this.zks.getTxnLogFactory().close();
        }
    }

    @Override
    public void killCluster() throws Exception {
        this.stopCluster();
        FileUtils.deleteDirectory((File)this.zkTmpDir);
    }

    static {
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
        LOG = LoggerFactory.getLogger(ZooKeeperUtil.class);
    }
}

