/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.zookeeper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.ZooKeeperCluster;
import org.apache.bookkeeper.test.ZooKeeperClusterUtil;
import org.apache.bookkeeper.test.ZooKeeperUtil;
import org.apache.bookkeeper.zookeeper.BoundExponentialBackoffRetryPolicy;
import org.apache.bookkeeper.zookeeper.ExponentialBackOffWithDeadlinePolicy;
import org.apache.bookkeeper.zookeeper.RetryPolicy;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.bookkeeper.zookeeper.ZooKeeperWatcherBase;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public abstract class TestZooKeeperClient
extends TestCase {
    private static final Logger logger;
    protected ZooKeeperCluster zkUtil;
    private RetryPolicy retryPolicy;

    public TestZooKeeperClient(Class<? extends ZooKeeperCluster> zooKeeperUtilClass, Class<? extends RetryPolicy> retryPolicyClass) throws IOException, KeeperException, InterruptedException {
        this.zkUtil = zooKeeperUtilClass.equals(ZooKeeperUtil.class) ? new ZooKeeperUtil() : new ZooKeeperClusterUtil(3);
        this.retryPolicy = retryPolicyClass.equals(BoundExponentialBackoffRetryPolicy.class) ? new BoundExponentialBackoffRetryPolicy(2000L, 2000L, Integer.MAX_VALUE) : new ExponentialBackOffWithDeadlinePolicy(100L, 20000L, Integer.MAX_VALUE);
    }

    @Before
    public void setUp() throws Exception {
        logger.info("Setting up test {}.", (Object)this.getName());
        this.zkUtil.startCluster();
    }

    @After
    public void tearDown() throws Exception {
        this.zkUtil.killCluster();
        logger.info("Teared down test {}.", (Object)this.getName());
    }

    private void expireZooKeeperSession(ZooKeeper zk, int timeout) throws IOException, InterruptedException, KeeperException {
        final CountDownLatch latch = new CountDownLatch(1);
        ZooKeeper newZk = new ZooKeeper(this.zkUtil.getZooKeeperConnectString(), timeout, new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getType() == Watcher.Event.EventType.None && event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    latch.countDown();
                }
            }
        }, zk.getSessionId(), zk.getSessionPasswd());
        if (!latch.await(timeout, TimeUnit.MILLISECONDS)) {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.CONNECTIONLOSS);
        }
        newZk.close();
    }

    @Test
    public void testReconnectAfterExipred() throws Exception {
        final CountDownLatch expireLatch = new CountDownLatch(1);
        Watcher testWatcher = new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getType() == Watcher.Event.EventType.None && event.getState() == Watcher.Event.KeeperState.Expired) {
                    expireLatch.countDown();
                }
            }
        };
        int timeout = 2000;
        ZooKeeperWatcherBase watcherManager = new ZooKeeperWatcherBase(2000, false).addChildWatcher(testWatcher);
        ArrayList<2> watchers = new ArrayList<2>(1);
        watchers.add(testWatcher);
        ShutdownZkServerClient client = new ShutdownZkServerClient(this.zkUtil.getZooKeeperConnectString(), 2000, watcherManager, (RetryPolicy)(this.retryPolicy instanceof BoundExponentialBackoffRetryPolicy ? new BoundExponentialBackoffRetryPolicy(2000L, 2000L, 0) : new ExponentialBackOffWithDeadlinePolicy(100L, 20000L, 0)));
        client.waitForConnection();
        Assert.assertTrue((String)"Client failed to connect an alive ZooKeeper.", (boolean)client.getState().isConnected());
        logger.info("Expire zookeeper client");
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        Assert.assertTrue((String)"Client registered watcher should receive expire event.", (boolean)expireLatch.await(4000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((String)"Client doesn't receive expire event from ZooKeeper.", (boolean)client.getState().isConnected());
        try {
            client.exists("/tmp", false);
            Assert.fail((String)"Should fail due to connection loss.");
        }
        catch (KeeperException.ConnectionLossException connectionLossException) {
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
            // empty catch block
        }
        this.zkUtil.restartCluster();
        Thread.sleep(4000L);
        Assert.assertTrue((String)"Client failed to connect zookeeper even it was back.", (boolean)client.getState().isConnected());
        try {
            client.exists("/tmp", false);
        }
        catch (KeeperException.ConnectionLossException cle) {
            Assert.fail((String)"Should not throw ConnectionLossException");
        }
        catch (KeeperException.SessionExpiredException cle) {
            Assert.fail((String)"Should not throw SessionExpiredException");
        }
    }

    @Test
    public void testRetrySyncOperations() throws Exception {
        int timeout = 2000;
        ZooKeeperClient client = ZooKeeperClient.createConnectedZooKeeperClient((String)this.zkUtil.getZooKeeperConnectString(), (int)2000, new HashSet(), (RetryPolicy)this.retryPolicy);
        Assert.assertTrue((String)"Client failed to connect an alive ZooKeeper.", (boolean)client.getState().isConnected());
        String path = "/a";
        byte[] data = "test".getBytes();
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        logger.info("Create znode " + path);
        client.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        logger.info("Created znode " + path);
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        logger.info("Exists znode " + path);
        Stat stat = client.exists(path, false);
        Assert.assertNotNull((String)"znode doesn't existed", (Object)stat);
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        logger.info("Get data from znode " + path);
        Stat newStat = new Stat();
        client.getData(path, false, newStat);
        Assert.assertEquals((Object)stat, (Object)newStat);
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        logger.info("Create children under znode " + path);
        client.create(path + "/children", data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        logger.info("Create children under znode " + path);
        client.create(path + "/children2", data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        List children = client.getChildren(path, false, newStat);
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertTrue((boolean)children.contains("children"));
        Assert.assertTrue((boolean)children.contains("children2"));
        logger.info("Get children under znode " + path);
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        client.delete(path + "/children", -1);
        logger.info("Delete children from znode " + path);
    }

    @Test
    public void testSyncAfterSessionExpiry() throws Exception {
        int timeout = 2000;
        ZooKeeperClient client = ZooKeeperClient.createConnectedZooKeeperClient((String)this.zkUtil.getZooKeeperConnectString(), (int)2000, new HashSet(), (RetryPolicy)this.retryPolicy);
        Assert.assertTrue((String)"Client failed to connect an alive ZooKeeper.", (boolean)client.getState().isConnected());
        String path = "/testSyncAfterSessionExpiry";
        byte[] data = "test".getBytes();
        logger.info("Create znode " + path);
        ArrayList setACLList = new ArrayList();
        setACLList.addAll(ZooDefs.Ids.OPEN_ACL_UNSAFE);
        client.create(path, data, setACLList, CreateMode.PERSISTENT);
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        Assert.assertTrue((String)"Client failed to connect an alive ZooKeeper.", (boolean)client.getState().isConnected());
        CountDownLatch latch = new CountDownLatch(1);
        final int[] rcArray = new int[]{-1};
        client.sync(path, new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                CountDownLatch cdLatch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                cdLatch.countDown();
            }
        }, (Object)latch);
        Assert.assertTrue((String)"client.sync operation should have completed successfully", (boolean)latch.await(6000L, TimeUnit.MILLISECONDS));
        if (rcArray[0] != KeeperException.Code.OK.intValue()) {
            Assert.fail((String)("Sync failed because of exception - " + KeeperException.Code.get((int)rcArray[0])));
        }
        client.delete(path, -1);
    }

    @Test
    public void testACLSetAndGet() throws Exception {
        int timeout = 2000;
        ZooKeeperClient client = ZooKeeperClient.createConnectedZooKeeperClient((String)this.zkUtil.getZooKeeperConnectString(), (int)2000, new HashSet(), (RetryPolicy)this.retryPolicy);
        Assert.assertTrue((String)"Client failed to connect an alive ZooKeeper.", (boolean)client.getState().isConnected());
        String path = "/testACLSetAndGet";
        byte[] data = "test".getBytes();
        logger.info("Create znode " + path);
        ArrayList setACLList = new ArrayList();
        setACLList.addAll(ZooDefs.Ids.OPEN_ACL_UNSAFE);
        client.create(path, data, setACLList, CreateMode.PERSISTENT);
        Stat status = new Stat();
        List receivedACLList = client.getACL(path, status);
        Assert.assertEquals((String)"Test1 - ACLs are expected to match", setACLList, (Object)receivedACLList);
        setACLList.clear();
        setACLList.addAll(ZooDefs.Ids.OPEN_ACL_UNSAFE);
        setACLList.addAll(ZooDefs.Ids.READ_ACL_UNSAFE);
        status = client.setACL(path, setACLList, status.getAversion());
        receivedACLList = client.getACL(path, status);
        Assert.assertEquals((String)"Test2 - ACLs are expected to match", setACLList, (Object)receivedACLList);
        setACLList.clear();
        setACLList.addAll(ZooDefs.Ids.OPEN_ACL_UNSAFE);
        CountDownLatch latch = new CountDownLatch(1);
        final Stat[] statArray = new Stat[]{null};
        final int[] rcArray = new int[]{-1};
        client.setACL(path, setACLList, status.getAversion(), new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                CountDownLatch cdLatch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                statArray[0] = stat;
                cdLatch.countDown();
            }
        }, (Object)latch);
        latch.await(3000L, TimeUnit.MILLISECONDS);
        if (rcArray[0] != KeeperException.Code.OK.intValue()) {
            Assert.fail((String)("Test3 - SetACL call failed because of exception - " + KeeperException.Code.get((int)rcArray[0])));
        }
        status = statArray[0];
        latch = new CountDownLatch(1);
        rcArray[0] = 0;
        statArray[0] = null;
        final ArrayList aclListArray = new ArrayList(1);
        client.getACL(path, status, new AsyncCallback.ACLCallback(){

            public void processResult(int rc, String path, Object ctx, List<ACL> acl, Stat stat) {
                CountDownLatch cdLatch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                statArray[0] = stat;
                aclListArray.add(acl);
                cdLatch.countDown();
            }
        }, (Object)latch);
        latch.await(3000L, TimeUnit.MILLISECONDS);
        if (rcArray[0] != KeeperException.Code.OK.intValue()) {
            Assert.fail((String)("Test4 - GetACL call failed because of exception - " + KeeperException.Code.get((int)rcArray[0])));
        }
        status = statArray[0];
        receivedACLList = (List)aclListArray.get(0);
        Assert.assertEquals((String)"Test5 - ACLs are expected to match", setACLList, (Object)receivedACLList);
        client.delete(path, status.getVersion());
    }

    @Test
    public void testACLSetAndGetAfterSessionExpiry() throws Exception {
        int timeout = 2000;
        ZooKeeperClient client = ZooKeeperClient.createConnectedZooKeeperClient((String)this.zkUtil.getZooKeeperConnectString(), (int)2000, new HashSet(), (RetryPolicy)this.retryPolicy);
        Assert.assertTrue((String)"Client failed to connect an alive ZooKeeper.", (boolean)client.getState().isConnected());
        String path = "/testACLSetAndGetAfterSessionExpiry";
        byte[] data = "test".getBytes();
        logger.info("Create znode " + path);
        ArrayList setACLList = new ArrayList();
        setACLList.addAll(ZooDefs.Ids.OPEN_ACL_UNSAFE);
        client.create(path, data, setACLList, CreateMode.PERSISTENT);
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        Stat status = new Stat();
        List receivedACLList = client.getACL(path, status);
        Assert.assertEquals((String)"Test1 - ACLs are expected to match", setACLList, (Object)receivedACLList);
        setACLList.clear();
        setACLList.addAll(ZooDefs.Ids.OPEN_ACL_UNSAFE);
        setACLList.addAll(ZooDefs.Ids.READ_ACL_UNSAFE);
        status = client.setACL(path, setACLList, status.getAversion());
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        receivedACLList = client.getACL(path, status);
        Assert.assertEquals((String)"Test2 - ACLs are expected to match", setACLList, (Object)receivedACLList);
        setACLList.clear();
        setACLList.addAll(ZooDefs.Ids.OPEN_ACL_UNSAFE);
        CountDownLatch latch = new CountDownLatch(1);
        final Stat[] statArray = new Stat[]{null};
        final int[] rcArray = new int[]{-1};
        client.setACL(path, setACLList, status.getAversion(), new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                CountDownLatch cdLatch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                statArray[0] = stat;
                cdLatch.countDown();
            }
        }, (Object)latch);
        latch.await(3000L, TimeUnit.MILLISECONDS);
        if (rcArray[0] != KeeperException.Code.OK.intValue()) {
            Assert.fail((String)("Test3 - SetACL call failed because of exception - " + KeeperException.Code.get((int)rcArray[0])));
        }
        status = statArray[0];
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        latch = new CountDownLatch(1);
        rcArray[0] = 0;
        statArray[0] = null;
        final ArrayList aclListArray = new ArrayList(1);
        client.getACL(path, status, new AsyncCallback.ACLCallback(){

            public void processResult(int rc, String path, Object ctx, List<ACL> acl, Stat stat) {
                CountDownLatch cdLatch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                statArray[0] = stat;
                aclListArray.add(acl);
                cdLatch.countDown();
            }
        }, (Object)latch);
        Assert.assertTrue((String)"getACL operation should have completed successfully", (boolean)latch.await(6000L, TimeUnit.MILLISECONDS));
        if (rcArray[0] != KeeperException.Code.OK.intValue()) {
            Assert.fail((String)("Test4 - GetACL call failed because of exception - " + KeeperException.Code.get((int)rcArray[0])));
        }
        status = statArray[0];
        receivedACLList = (List)aclListArray.get(0);
        Assert.assertEquals((String)"Test5 - ACLs are expected to match", setACLList, (Object)receivedACLList);
        client.delete(path, status.getVersion());
    }

    @Test
    public void testZnodeExists() throws Exception {
        int timeout = 2000;
        ZooKeeperClient client = ZooKeeperClient.createConnectedZooKeeperClient((String)this.zkUtil.getZooKeeperConnectString(), (int)2000, new HashSet(), (RetryPolicy)this.retryPolicy);
        Assert.assertTrue((String)"Client failed to connect an alive ZooKeeper.", (boolean)client.getState().isConnected());
        String path = "/testZnodeExists";
        byte[] data = "test".getBytes();
        logger.info("Create znode " + path);
        client.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        final AtomicBoolean isDeleted = new AtomicBoolean(false);
        final CountDownLatch latch = new CountDownLatch(1);
        Stat stat = client.exists(path, new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
                    isDeleted.set(true);
                    latch.countDown();
                }
            }
        });
        Assert.assertNotNull((String)("node with path " + path + " should exists"), (Object)stat);
        client.delete(path, stat.getVersion());
        latch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((String)"The watcher on the node should have been called", (boolean)isDeleted.get());
        CountDownLatch latch2 = new CountDownLatch(1);
        final int[] rcArray = new int[]{-1};
        final boolean[] statIsnull = new boolean[]{false};
        client.exists(path, null, new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                CountDownLatch cdlatch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                statIsnull[0] = stat == null;
                cdlatch.countDown();
            }
        }, (Object)latch2);
        latch2.await(3000L, TimeUnit.MILLISECONDS);
        if (rcArray[0] != KeeperException.Code.NONODE.intValue()) {
            Assert.fail((String)("exists call is supposed to return NONODE rcvalue, but it returned - " + KeeperException.Code.get((int)rcArray[0])));
        }
        Assert.assertTrue((String)"exists is supposed to return null for Stat, since the node is already deleted", (boolean)statIsnull[0]);
    }

    @Test
    public void testGetSetData() throws Exception {
        int timeout = 2000;
        ZooKeeperClient client = ZooKeeperClient.createConnectedZooKeeperClient((String)this.zkUtil.getZooKeeperConnectString(), (int)2000, new HashSet(), (RetryPolicy)this.retryPolicy);
        Assert.assertTrue((String)"Client failed to connect an alive ZooKeeper.", (boolean)client.getState().isConnected());
        String path = "/testGetSetData";
        byte[] data = "test".getBytes();
        logger.info("Create znode " + path);
        client.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        CountDownLatch latch = new CountDownLatch(1);
        final Stat[] statArray = new Stat[]{null};
        final int[] rcArray = new int[]{-1};
        final byte[][] dataArray = new byte[][]{new byte[0]};
        client.getData(path, true, new AsyncCallback.DataCallback(){

            public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                CountDownLatch cdLatch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                statArray[0] = stat;
                dataArray[0] = data;
                cdLatch.countDown();
            }
        }, (Object)latch);
        latch.await(3000L, TimeUnit.MILLISECONDS);
        if (rcArray[0] != KeeperException.Code.OK.intValue()) {
            Assert.fail((String)("Test1 - getData call failed because of exception - " + KeeperException.Code.get((int)rcArray[0])));
        }
        Assert.assertArrayEquals((String)"Test1 - getData output - ", (byte[])data, (byte[])dataArray[0]);
        Stat stat = statArray[0];
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        latch = new CountDownLatch(1);
        data = "newtest".getBytes();
        client.setData(path, data, stat.getVersion(), new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                CountDownLatch cdlatch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                statArray[0] = stat;
                cdlatch.countDown();
            }
        }, (Object)latch);
        Assert.assertTrue((String)"setData operation should have completed successfully", (boolean)latch.await(6000L, TimeUnit.MILLISECONDS));
        if (rcArray[0] != KeeperException.Code.OK.intValue()) {
            Assert.fail((String)("Test2 - setData call failed because of exception - " + KeeperException.Code.get((int)rcArray[0])));
        }
        stat = statArray[0];
        byte[] getDataRet = client.getData(path, null, stat);
        Assert.assertArrayEquals((String)"Test3 - getData output - ", (byte[])data, (byte[])getDataRet);
        data = "newesttest".getBytes();
        stat = client.setData(path, data, stat.getVersion());
        latch = new CountDownLatch(1);
        client.getData(path, null, new AsyncCallback.DataCallback(){

            public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                CountDownLatch cdLatch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                statArray[0] = stat;
                dataArray[0] = data;
                cdLatch.countDown();
            }
        }, (Object)latch);
        latch.await(3000L, TimeUnit.MILLISECONDS);
        if (rcArray[0] != KeeperException.Code.OK.intValue()) {
            Assert.fail((String)("Test4 - getData call failed because of exception - " + KeeperException.Code.get((int)rcArray[0])));
        }
        Assert.assertArrayEquals((String)"Test4 - getData output - ", (byte[])data, (byte[])dataArray[0]);
        stat = statArray[0];
        client.delete(path, stat.getVersion());
    }

    @Test
    public void testGetChildren() throws Exception {
        int timeout = 2000;
        ZooKeeperClient client = ZooKeeperClient.createConnectedZooKeeperClient((String)this.zkUtil.getZooKeeperConnectString(), (int)2000, new HashSet(), (RetryPolicy)this.retryPolicy);
        Assert.assertTrue((String)"Client failed to connect an alive ZooKeeper.", (boolean)client.getState().isConnected());
        String root = "/testGetChildren";
        byte[] rootData = "root".getBytes();
        logger.info("Create znode " + root);
        client.create(root, rootData, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        String child1 = root + "/child1";
        logger.info("Create znode " + child1);
        byte[] child1Data = "child1".getBytes();
        client.create(child1, child1Data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        String child2 = root + "/child2";
        logger.info("Create znode " + child2);
        byte[] child2Data = "child2".getBytes();
        client.create(child2, child2Data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Stat rootStat = new Stat();
        List children = client.getChildren(root, null, rootStat);
        Assert.assertEquals((String)"Test1 - children size", (long)2L, (long)children.size());
        String child3 = root + "/child3";
        logger.info("Create znode " + child3);
        byte[] child3Data = "child3".getBytes();
        client.create(child3, child3Data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        children = client.getChildren(root, true, rootStat);
        Assert.assertEquals((String)"Test2 - children size", (long)3L, (long)children.size());
        CountDownLatch latch = new CountDownLatch(1);
        final Stat[] statArray = new Stat[]{null};
        final int[] rcArray = new int[]{-1};
        final int[] childrenCount = new int[]{0};
        client.getChildren(root, null, new AsyncCallback.Children2Callback(){

            public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                CountDownLatch cdlatch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                childrenCount[0] = children.size();
                statArray[0] = stat;
                cdlatch.countDown();
            }
        }, (Object)latch);
        latch.await(3000L, TimeUnit.MILLISECONDS);
        if (rcArray[0] != KeeperException.Code.OK.intValue()) {
            Assert.fail((String)("Test3 - getChildren call failed because of exception - " + KeeperException.Code.get((int)rcArray[0])));
        }
        Assert.assertEquals((String)"Test3 - children size", (long)3L, (long)childrenCount[0]);
        rootStat = statArray[0];
        latch = new CountDownLatch(1);
        client.getChildren(root, true, new AsyncCallback.Children2Callback(){

            public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                CountDownLatch cdlatch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                childrenCount[0] = children.size();
                statArray[0] = stat;
                cdlatch.countDown();
            }
        }, (Object)latch);
        latch.await(3000L, TimeUnit.MILLISECONDS);
        if (rcArray[0] != KeeperException.Code.OK.intValue()) {
            Assert.fail((String)("Test4 - getChildren call failed because of exception - " + KeeperException.Code.get((int)rcArray[0])));
        }
        Assert.assertEquals((String)"Test4 - children size", (long)3L, (long)childrenCount[0]);
        rootStat = statArray[0];
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        children = client.getChildren(root, null, rootStat);
        Assert.assertEquals((String)"Test5 - children size", (long)3L, (long)children.size());
        String child4 = root + "/child4";
        logger.info("Create znode " + child4);
        byte[] child4Data = "child4".getBytes();
        client.create(child4, child4Data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        latch = new CountDownLatch(1);
        client.getChildren(root, null, new AsyncCallback.Children2Callback(){

            public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                CountDownLatch cdlatch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                childrenCount[0] = children.size();
                statArray[0] = stat;
                cdlatch.countDown();
            }
        }, (Object)latch);
        latch.await(3000L, TimeUnit.MILLISECONDS);
        if (rcArray[0] != KeeperException.Code.OK.intValue()) {
            Assert.fail((String)("Test6 - getChildren call failed because of exception - " + KeeperException.Code.get((int)rcArray[0])));
        }
        Assert.assertEquals((String)"Test6 - children size", (long)4L, (long)childrenCount[0]);
        rootStat = statArray[0];
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        children = client.getChildren(root, null);
        Assert.assertEquals((String)"Test7 - children size", (long)4L, (long)children.size());
        children = client.getChildren(root, true);
        Assert.assertEquals((String)"Test8 - children size", (long)4L, (long)children.size());
        latch = new CountDownLatch(1);
        client.getChildren(root, true, new AsyncCallback.ChildrenCallback(){

            public void processResult(int rc, String path, Object ctx, List<String> children) {
                CountDownLatch cdlatch = (CountDownLatch)ctx;
                rcArray[0] = rc;
                childrenCount[0] = children.size();
                cdlatch.countDown();
            }
        }, (Object)latch);
        latch.await(3000L, TimeUnit.MILLISECONDS);
        if (rcArray[0] != KeeperException.Code.OK.intValue()) {
            Assert.fail((String)("Test9 - getChildren call failed because of exception - " + KeeperException.Code.get((int)rcArray[0])));
        }
        Assert.assertEquals((String)"Test9 - children size", (long)4L, (long)childrenCount[0]);
    }

    @Test
    public void testRetryOnCreatingEphemeralZnode() throws Exception {
        int timeout = 2000;
        ZooKeeperClient client = ZooKeeperClient.createConnectedZooKeeperClient((String)this.zkUtil.getZooKeeperConnectString(), (int)2000, new HashSet(), (RetryPolicy)this.retryPolicy);
        Assert.assertTrue((String)"Client failed to connect an alive ZooKeeper.", (boolean)client.getState().isConnected());
        String path = "/a";
        byte[] data = "test".getBytes();
        logger.info("Create znode " + path);
        client.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        logger.info("Created znode " + path);
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        logger.info("Create znode w/ new session : " + path);
        client.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        logger.info("Created znode w/ new session : " + path);
    }

    @Test
    public void testRetryAsyncOperations() throws Exception {
        int timeout = 2000;
        ZooKeeperClient client = ZooKeeperClient.createConnectedZooKeeperClient((String)this.zkUtil.getZooKeeperConnectString(), (int)2000, new HashSet(), (RetryPolicy)this.retryPolicy);
        Assert.assertTrue((String)"Client failed to connect an alive ZooKeeper.", (boolean)client.getState().isConnected());
        String path = "/a";
        byte[] data = "test".getBytes();
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        logger.info("Create znode " + path);
        final CountDownLatch createLatch = new CountDownLatch(1);
        client.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, new AsyncCallback.StringCallback(){

            public void processResult(int rc, String path, Object ctx, String name) {
                if (KeeperException.Code.OK.intValue() == rc) {
                    createLatch.countDown();
                }
            }
        }, null);
        createLatch.await();
        logger.info("Created znode " + path);
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        logger.info("Create znode " + path);
        CountDownLatch create2Latch = new CountDownLatch(1);
        client.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, (rc, path1, ctx, name) -> {
            if (KeeperException.Code.NODEEXISTS.intValue() == rc) {
                create2Latch.countDown();
            }
        }, null);
        create2Latch.await();
        logger.info("Created znode " + path);
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        logger.info("Exists znode " + path);
        final CountDownLatch existsLatch = new CountDownLatch(1);
        client.exists(path, false, new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                if (KeeperException.Code.OK.intValue() == rc) {
                    existsLatch.countDown();
                }
            }
        }, null);
        existsLatch.await();
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        final CountDownLatch getLatch = new CountDownLatch(1);
        logger.info("Get data from znode " + path);
        client.getData(path, false, new AsyncCallback.DataCallback(){

            public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                if (KeeperException.Code.OK.intValue() == rc) {
                    getLatch.countDown();
                }
            }
        }, null);
        getLatch.await();
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        logger.info("Create children under znode " + path);
        final CountDownLatch createChildLatch = new CountDownLatch(1);
        client.create(path + "/children", data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, new AsyncCallback.StringCallback(){

            public void processResult(int rc, String path, Object ctx, String name) {
                if (KeeperException.Code.OK.intValue() == rc) {
                    createChildLatch.countDown();
                }
            }
        }, null);
        createChildLatch.await();
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        final CountDownLatch getChildLatch = new CountDownLatch(1);
        final AtomicReference children = new AtomicReference();
        client.getChildren(path, false, new AsyncCallback.Children2Callback(){

            public void processResult(int rc, String path, Object ctx, List<String> childList, Stat stat) {
                if (KeeperException.Code.OK.intValue() == rc) {
                    children.set(childList);
                    getChildLatch.countDown();
                }
            }
        }, null);
        getChildLatch.await();
        Assert.assertNotNull(children.get());
        Assert.assertEquals((long)1L, (long)((List)children.get()).size());
        Assert.assertEquals((Object)"children", ((List)children.get()).get(0));
        logger.info("Get children under znode " + path);
        this.expireZooKeeperSession((ZooKeeper)client, 2000);
        final CountDownLatch deleteChildLatch = new CountDownLatch(1);
        client.delete(path + "/children", -1, new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                if (KeeperException.Code.OK.intValue() == rc) {
                    deleteChildLatch.countDown();
                }
            }
        }, null);
        deleteChildLatch.await();
        logger.info("Delete children from znode " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllowReadOnlyMode() throws Exception {
        if (this.zkUtil instanceof ZooKeeperClusterUtil) {
            System.setProperty("readonlymode.enabled", "true");
            ((ZooKeeperClusterUtil)this.zkUtil).enableLocalSession(true);
            this.zkUtil.restartCluster();
            Thread.sleep(2000L);
            ((ZooKeeperClusterUtil)this.zkUtil).stopPeer(2);
            ((ZooKeeperClusterUtil)this.zkUtil).stopPeer(3);
        }
        try (ZooKeeperClient client = ZooKeeperClient.newBuilder().connectString(this.zkUtil.getZooKeeperConnectString()).sessionTimeoutMs(30000).watchers(new HashSet()).operationRetryPolicy(this.retryPolicy).allowReadOnlyMode(true).build();){
            Assert.assertTrue((String)"Client failed to connect a ZooKeeper in read-only mode.", (boolean)client.getState().isConnected());
        }
        finally {
            if (this.zkUtil instanceof ZooKeeperClusterUtil) {
                System.setProperty("readonlymode.enabled", "false");
                ((ZooKeeperClusterUtil)this.zkUtil).enableLocalSession(false);
            }
        }
    }

    static {
        ZooKeeperClusterUtil.enableZookeeperTestEnvVariables();
        logger = LoggerFactory.getLogger(TestZooKeeperClient.class);
    }

    class ShutdownZkServerClient
    extends ZooKeeperClient {
        ShutdownZkServerClient(String connectString, int sessionTimeoutMs, ZooKeeperWatcherBase watcher, RetryPolicy operationRetryPolicy) throws IOException {
            super(connectString, sessionTimeoutMs, watcher, (RetryPolicy)new BoundExponentialBackoffRetryPolicy((long)sessionTimeoutMs, (long)sessionTimeoutMs, Integer.MAX_VALUE), operationRetryPolicy, (StatsLogger)NullStatsLogger.INSTANCE, 1, 0.0, false);
        }

        public void process(WatchedEvent event) {
            if (event.getType() == Watcher.Event.EventType.None && event.getState() == Watcher.Event.KeeperState.Expired) {
                try {
                    TestZooKeeperClient.this.zkUtil.stopCluster();
                }
                catch (Exception e) {
                    logger.error("Failed to stop zookeeper server : ", (Throwable)e);
                }
            }
            super.process(event);
        }
    }
}

