/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;

public class BookieDeferredSyncTest
extends BookKeeperClusterTestCase {
    public BookieDeferredSyncTest() {
        super(1);
    }

    @Test
    public void testWriteAndRecovery() throws Exception {
        WriteHandle lh = (WriteHandle)FutureUtils.result((CompletableFuture)this.bkc.newCreateLedgerOp().withEnsembleSize(1).withWriteQuorumSize(1).withAckQuorumSize(1).withWriteFlags(new WriteFlag[]{WriteFlag.DEFERRED_SYNC}).withDigestType(DigestType.CRC32C).withPassword(new byte[0]).execute());
        int n = 10;
        long ledgerId = lh.getId();
        for (int i = 0; i < n; ++i) {
            lh.append(("entry-" + i).getBytes(StandardCharsets.UTF_8));
        }
        try (ReadHandle readLh = (ReadHandle)FutureUtils.result((CompletableFuture)this.bkc.newOpenLedgerOp().withLedgerId(ledgerId).withRecovery(true).withPassword(new byte[0]).execute());
             LedgerEntries entries = readLh.read(0L, (long)(n - 1));){
            for (int i = 0; i < n; ++i) {
                LedgerEntry entry = entries.getEntry((long)i);
                Assert.assertEquals((Object)("entry-" + i), (Object)new String(entry.getEntryBytes()));
            }
        }
    }

    @Test
    public void testCloseNoForce() throws Exception {
        this.testClose(true);
    }

    @Test
    public void testCloseWithForce() throws Exception {
        this.testClose(false);
    }

    private void testClose(boolean force) throws Exception {
        block45: {
            ReadHandle readLh;
            long ledgerId;
            int n = 10;
            try (WriteHandle lh = (WriteHandle)FutureUtils.result((CompletableFuture)this.bkc.newCreateLedgerOp().withEnsembleSize(1).withWriteQuorumSize(1).withAckQuorumSize(1).withWriteFlags(new WriteFlag[]{WriteFlag.DEFERRED_SYNC}).withDigestType(DigestType.CRC32C).withPassword(new byte[0]).execute());){
                ledgerId = lh.getId();
                for (int i = 0; i < 10; ++i) {
                    lh.append(("entry-" + i).getBytes(StandardCharsets.UTF_8));
                }
                if (force) {
                    FutureUtils.result((CompletableFuture)lh.force());
                    Assert.assertEquals((long)9L, (long)lh.getLastAddConfirmed());
                } else {
                    Assert.assertEquals((long)-1L, (long)lh.getLastAddConfirmed());
                }
            }
            if (force) {
                readLh = (ReadHandle)FutureUtils.result((CompletableFuture)this.bkc.newOpenLedgerOp().withLedgerId(ledgerId).withRecovery(true).withPassword(new byte[0]).execute());
                try {
                    LedgerEntry entry;
                    int i;
                    try (LedgerEntries entries = readLh.read(0L, 9L);){
                        for (i = 0; i < 10; ++i) {
                            entry = entries.getEntry((long)i);
                            Assert.assertEquals((Object)("entry-" + i), (Object)new String(entry.getEntryBytes()));
                        }
                    }
                    entries = readLh.readUnconfirmed(0L, 9L);
                    try {
                        for (i = 0; i < 10; ++i) {
                            entry = entries.getEntry((long)i);
                            Assert.assertEquals((Object)("entry-" + i), (Object)new String(entry.getEntryBytes()));
                        }
                        break block45;
                    }
                    finally {
                        if (entries != null) {
                            entries.close();
                        }
                    }
                }
                finally {
                    if (readLh != null) {
                        readLh.close();
                    }
                }
            }
            readLh = (ReadHandle)FutureUtils.result((CompletableFuture)this.bkc.newOpenLedgerOp().withLedgerId(ledgerId).withRecovery(true).withPassword(new byte[0]).execute());
            try {
                Assert.assertEquals((long)-1L, (long)readLh.getLastAddConfirmed());
                try (LedgerEntries entries = readLh.readUnconfirmed(0L, 9L);){
                    for (int i = 0; i < 10; ++i) {
                        LedgerEntry entry = entries.getEntry((long)i);
                        Assert.assertEquals((Object)("entry-" + i), (Object)new String(entry.getEntryBytes()));
                    }
                }
            }
            finally {
                if (readLh != null) {
                    readLh.close();
                }
            }
        }
    }

    @Test
    public void testForceWithDeferredSyncWriteFlags() throws Exception {
        this.testForce(EnumSet.of(WriteFlag.DEFERRED_SYNC));
    }

    @Test
    public void testForceNoWriteFlag() throws Exception {
        this.testForce(WriteFlag.NONE);
    }

    private void testForce(EnumSet<WriteFlag> writeFlags) throws Exception {
        try (WriteHandle lh = (WriteHandle)FutureUtils.result((CompletableFuture)this.bkc.newCreateLedgerOp().withEnsembleSize(1).withWriteQuorumSize(1).withAckQuorumSize(1).withWriteFlags(writeFlags).withDigestType(DigestType.CRC32C).withPassword(new byte[0]).execute());){
            int n = 10;
            for (int i = 0; i < n; ++i) {
                lh.append(("entry-" + i).getBytes(StandardCharsets.UTF_8));
            }
            FutureUtils.result((CompletableFuture)lh.force());
            Assert.assertEquals((long)(n - 1), (long)lh.getLastAddConfirmed());
        }
    }
}

