/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.Journal;
import org.apache.bookkeeper.bookie.JournalAliveListener;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.TestBookieImpl;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class BookieWriteToJournalTest {
    private static final Logger log = LoggerFactory.getLogger(BookieWriteToJournalTest.class);
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJournalLogAddEntryCalledCorrectly() throws Exception {
        File journalDir = this.tempDir.newFolder();
        BookieImpl.checkDirectoryStructure((File)BookieImpl.getCurrentDirectory((File)journalDir));
        File ledgerDir = this.tempDir.newFolder();
        BookieImpl.checkDirectoryStructure((File)BookieImpl.getCurrentDirectory((File)ledgerDir));
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir.getPath()).setLedgerDirNames(new String[]{ledgerDir.getPath()}).setMetadataServiceUri(null);
        BookieId bookieAddress = BookieImpl.getBookieId((ServerConfiguration)conf);
        CountDownLatch journalJoinLatch = new CountDownLatch(1);
        Journal journal = (Journal)Mockito.mock(Journal.class);
        MutableBoolean effectiveAckBeforeSync = new MutableBoolean(false);
        ((Journal)Mockito.doAnswer(iom -> {
            ByteBuf entry = (ByteBuf)iom.getArgument(0);
            long ledgerId = entry.getLong(entry.readerIndex() + 0);
            long entryId = entry.getLong(entry.readerIndex() + 8);
            boolean ackBeforeSync = (Boolean)iom.getArgument(1);
            BookkeeperInternalCallbacks.WriteCallback callback = (BookkeeperInternalCallbacks.WriteCallback)iom.getArgument(2);
            Object ctx = iom.getArgument(3);
            effectiveAckBeforeSync.setValue(ackBeforeSync);
            callback.writeComplete(0, ledgerId, entryId, bookieAddress, ctx);
            return null;
        }).when((Object)journal)).logAddEntry((ByteBuf)ArgumentMatchers.any(ByteBuf.class), ArgumentMatchers.anyBoolean(), (BookkeeperInternalCallbacks.WriteCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.WriteCallback.class), ArgumentMatchers.any());
        ((Journal)Mockito.doAnswer(iom -> {
            journalJoinLatch.await();
            return null;
        }).when((Object)journal)).joinThread();
        MockedStatic journalMockedStatic = Mockito.mockStatic(Journal.class);
        try {
            journalMockedStatic.when(() -> Journal.newJournal((int)ArgumentMatchers.anyInt(), (File)((File)ArgumentMatchers.any()), (ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any()), (LedgerDirsManager)((LedgerDirsManager)ArgumentMatchers.any()), (StatsLogger)((StatsLogger)ArgumentMatchers.any()), (ByteBufAllocator)((ByteBufAllocator)ArgumentMatchers.any()), (JournalAliveListener)((JournalAliveListener)ArgumentMatchers.any()))).thenReturn((Object)journal);
            NoOpJournalReplayBookie b = new NoOpJournalReplayBookie(conf);
            b.start();
            long ledgerId = 1L;
            long entryId = 0L;
            String expectedCtx = "foo";
            byte[] masterKey = new byte[64];
            for (boolean ackBeforeSync : new boolean[]{true, false}) {
                CountDownLatch latch = new CountDownLatch(1);
                ByteBuf data = BookieWriteToJournalTest.buildEntry(ledgerId, entryId, -1L);
                long expectedEntryId = entryId++;
                b.addEntry(data, ackBeforeSync, (rc, ledgerId1, entryId1, addr, ctx) -> {
                    Assert.assertSame((Object)expectedCtx, (Object)ctx);
                    Assert.assertEquals((long)ledgerId, (long)ledgerId1);
                    Assert.assertEquals((long)expectedEntryId, (long)entryId1);
                    latch.countDown();
                }, expectedCtx, masterKey);
                latch.await(30L, TimeUnit.SECONDS);
                Assert.assertEquals((Object)ackBeforeSync, (Object)effectiveAckBeforeSync.booleanValue());
            }
            journalJoinLatch.countDown();
            b.shutdown();
        }
        finally {
            if (Collections.singletonList(journalMockedStatic).get(0) != null) {
                journalMockedStatic.close();
            }
        }
    }

    @Test
    public void testForceLedger() throws Exception {
        File journalDir = this.tempDir.newFolder();
        BookieImpl.checkDirectoryStructure((File)BookieImpl.getCurrentDirectory((File)journalDir));
        File ledgerDir = this.tempDir.newFolder();
        BookieImpl.checkDirectoryStructure((File)BookieImpl.getCurrentDirectory((File)ledgerDir));
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir.getPath()).setLedgerDirNames(new String[]{ledgerDir.getPath()});
        TestBookieImpl b = new TestBookieImpl(conf);
        b.start();
        long ledgerId = 1L;
        long entryId = 0L;
        String expectedCtx = "foo";
        byte[] masterKey = new byte[64];
        CompletableFuture latchForceLedger1 = new CompletableFuture();
        CompletableFuture latchForceLedger2 = new CompletableFuture();
        CompletableFuture latchAddEntry = new CompletableFuture();
        ByteBuf data = BookieWriteToJournalTest.buildEntry(ledgerId, entryId, -1L);
        long expectedEntryId = entryId;
        b.forceLedger(ledgerId, (rc, ledgerId1, entryId1, addr, ctx) -> {
            if (rc != 0) {
                latchForceLedger1.completeExceptionally(BKException.create((int)rc));
                return;
            }
            FutureUtils.complete((CompletableFuture)latchForceLedger1, null);
        }, expectedCtx);
        FutureUtils.result(latchForceLedger1);
        b.addEntry(data, true, (rc, ledgerId1, entryId1, addr, ctx) -> {
            if (rc != 0) {
                latchAddEntry.completeExceptionally(BKException.create((int)rc));
                return;
            }
            latchAddEntry.complete(entryId);
        }, expectedCtx, masterKey);
        Assert.assertEquals((long)expectedEntryId, (long)((Long)FutureUtils.result(latchAddEntry)));
        b.forceLedger(ledgerId, (rc, ledgerId1, entryId1, addr, ctx) -> {
            if (rc != 0) {
                latchForceLedger2.completeExceptionally(BKException.create((int)rc));
                return;
            }
            FutureUtils.complete((CompletableFuture)latchForceLedger2, null);
        }, expectedCtx);
        FutureUtils.result(latchForceLedger2);
        b.shutdown();
    }

    @Test
    public void testSmallJournalQueueWithHighFlushFrequency() throws IOException, InterruptedException {
        ServerConfiguration conf = new ServerConfiguration();
        conf.setJournalQueueSize(1);
        conf.setJournalFlushWhenQueueEmpty(true);
        conf.setJournalBufferedWritesThreshold(1L);
        conf.setJournalDirName(this.tempDir.newFolder().getPath());
        conf.setLedgerDirNames(new String[]{this.tempDir.newFolder().getPath()});
        DiskChecker diskChecker = new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold());
        LedgerDirsManager ledgerDirsManager = new LedgerDirsManager(conf, conf.getLedgerDirs(), diskChecker);
        Journal journal = new Journal(0, conf.getJournalDirs()[0], conf, ledgerDirsManager);
        journal.start();
        int entries = 1000;
        CountDownLatch entriesLatch = new CountDownLatch(1000);
        for (int j = 1; j <= 1000; ++j) {
            ByteBuf entry = BookieWriteToJournalTest.buildEntry(1L, j, -1L);
            journal.logAddEntry(entry, false, (rc, ledgerId, entryId, addr, ctx) -> entriesLatch.countDown(), null);
        }
        entriesLatch.await();
        journal.shutdown();
    }

    private static ByteBuf buildEntry(long ledgerId, long entryId, long lastAddConfirmed) {
        ByteBuf data = Unpooled.buffer();
        data.writeLong(ledgerId);
        data.writeLong(entryId);
        data.writeLong(lastAddConfirmed);
        return data;
    }

    class NoOpJournalReplayBookie
    extends TestBookieImpl {
        public NoOpJournalReplayBookie(ServerConfiguration conf) throws Exception {
            super(conf);
        }

        void readJournal() throws IOException, BookieException {
        }
    }
}

